/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.entrypoint.component;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.dispatcher.runner.DispatcherRunner;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.resourcemanager.ResourceManager;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.webmonitor.WebMonitorEndpoint;
import org.apache.flink.util.AutoCloseableAsync;
import org.apache.flink.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherResourceManagerComponent
implements AutoCloseableAsync {
    private static final Logger LOG = LoggerFactory.getLogger(DispatcherResourceManagerComponent.class);
    @Nonnull
    private final DispatcherRunner dispatcherRunner;
    @Nonnull
    private final ResourceManager<?> resourceManager;
    @Nonnull
    private final LeaderRetrievalService dispatcherLeaderRetrievalService;
    @Nonnull
    private final LeaderRetrievalService resourceManagerRetrievalService;
    @Nonnull
    private final WebMonitorEndpoint<?> webMonitorEndpoint;
    private final CompletableFuture<Void> terminationFuture;
    private final CompletableFuture<ApplicationStatus> shutDownFuture;
    private final AtomicBoolean isRunning = new AtomicBoolean(true);

    DispatcherResourceManagerComponent(@Nonnull DispatcherRunner dispatcherRunner, @Nonnull ResourceManager<?> resourceManager, @Nonnull LeaderRetrievalService dispatcherLeaderRetrievalService, @Nonnull LeaderRetrievalService resourceManagerRetrievalService, @Nonnull WebMonitorEndpoint<?> webMonitorEndpoint) {
        this.dispatcherRunner = dispatcherRunner;
        this.resourceManager = resourceManager;
        this.dispatcherLeaderRetrievalService = dispatcherLeaderRetrievalService;
        this.resourceManagerRetrievalService = resourceManagerRetrievalService;
        this.webMonitorEndpoint = webMonitorEndpoint;
        this.terminationFuture = new CompletableFuture();
        this.shutDownFuture = new CompletableFuture();
        this.registerShutDownFuture();
    }

    private void registerShutDownFuture() {
        FutureUtils.forward(this.dispatcherRunner.getShutDownFuture(), this.shutDownFuture);
    }

    public final CompletableFuture<ApplicationStatus> getShutDownFuture() {
        return this.shutDownFuture;
    }

    public CompletableFuture<Void> deregisterApplicationAndClose(ApplicationStatus applicationStatus, @Nullable String diagnostics) {
        if (this.isRunning.compareAndSet(true, false)) {
            CompletableFuture<Void> closeWebMonitorAndDeregisterAppFuture = FutureUtils.composeAfterwards(this.webMonitorEndpoint.closeAsync(), () -> this.deregisterApplication(applicationStatus, diagnostics));
            return FutureUtils.composeAfterwards(closeWebMonitorAndDeregisterAppFuture, this::closeAsyncInternal);
        }
        return this.terminationFuture;
    }

    private CompletableFuture<Void> deregisterApplication(ApplicationStatus applicationStatus, @Nullable String diagnostics) {
        ResourceManagerGateway selfGateway = this.resourceManager.getSelfGateway(ResourceManagerGateway.class);
        return selfGateway.deregisterApplication(applicationStatus, diagnostics).thenApply(ack -> null);
    }

    private CompletableFuture<Void> closeAsyncInternal() {
        LOG.info("Closing components.");
        Exception exception = null;
        ArrayList terminationFutures = new ArrayList(3);
        try {
            this.dispatcherLeaderRetrievalService.stop();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, exception);
        }
        try {
            this.resourceManagerRetrievalService.stop();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        terminationFutures.add(this.dispatcherRunner.closeAsync());
        terminationFutures.add(this.resourceManager.closeAsync());
        if (exception != null) {
            terminationFutures.add(FutureUtils.completedExceptionally(exception));
        }
        FutureUtils.ConjunctFuture<Void> componentTerminationFuture = FutureUtils.completeAll(terminationFutures);
        componentTerminationFuture.whenComplete((aVoid, throwable) -> {
            if (throwable != null) {
                this.terminationFuture.completeExceptionally((Throwable)throwable);
            } else {
                this.terminationFuture.complete((Void)aVoid);
            }
        });
        return this.terminationFuture;
    }

    public CompletableFuture<Void> closeAsync() {
        return this.deregisterApplicationAndClose(ApplicationStatus.CANCELED, "DispatcherResourceManagerComponent has been closed.");
    }
}

