/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.heartbeat;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.heartbeat.HeartbeatListener;
import org.apache.flink.runtime.heartbeat.HeartbeatMonitor;
import org.apache.flink.runtime.heartbeat.HeartbeatTarget;
import org.apache.flink.util.Preconditions;

public class HeartbeatMonitorImpl<O>
implements HeartbeatMonitor<O>,
Runnable {
    private final ResourceID resourceID;
    private final HeartbeatTarget<O> heartbeatTarget;
    private final ScheduledExecutor scheduledExecutor;
    private final HeartbeatListener<?, ?> heartbeatListener;
    private final long heartbeatTimeoutIntervalMs;
    private volatile ScheduledFuture<?> futureTimeout;
    private final AtomicReference<State> state = new AtomicReference<State>(State.RUNNING);
    private volatile long lastHeartbeat;

    HeartbeatMonitorImpl(ResourceID resourceID, HeartbeatTarget<O> heartbeatTarget, ScheduledExecutor scheduledExecutor, HeartbeatListener<?, O> heartbeatListener, long heartbeatTimeoutIntervalMs) {
        this.resourceID = (ResourceID)Preconditions.checkNotNull((Object)resourceID);
        this.heartbeatTarget = (HeartbeatTarget)Preconditions.checkNotNull(heartbeatTarget);
        this.scheduledExecutor = (ScheduledExecutor)Preconditions.checkNotNull((Object)scheduledExecutor);
        this.heartbeatListener = (HeartbeatListener)Preconditions.checkNotNull(heartbeatListener);
        Preconditions.checkArgument((heartbeatTimeoutIntervalMs > 0L ? 1 : 0) != 0, (Object)"The heartbeat timeout interval has to be larger than 0.");
        this.heartbeatTimeoutIntervalMs = heartbeatTimeoutIntervalMs;
        this.lastHeartbeat = 0L;
        this.resetHeartbeatTimeout(heartbeatTimeoutIntervalMs);
    }

    @Override
    public HeartbeatTarget<O> getHeartbeatTarget() {
        return this.heartbeatTarget;
    }

    @Override
    public ResourceID getHeartbeatTargetId() {
        return this.resourceID;
    }

    @Override
    public long getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    @Override
    public void reportHeartbeat() {
        this.lastHeartbeat = System.currentTimeMillis();
        this.resetHeartbeatTimeout(this.heartbeatTimeoutIntervalMs);
    }

    @Override
    public void cancel() {
        if (this.state.compareAndSet(State.RUNNING, State.CANCELED)) {
            this.cancelTimeout();
        }
    }

    @Override
    public void run() {
        if (this.state.compareAndSet(State.RUNNING, State.TIMEOUT)) {
            this.heartbeatListener.notifyHeartbeatTimeout(this.resourceID);
        }
    }

    public boolean isCanceled() {
        return this.state.get() == State.CANCELED;
    }

    void resetHeartbeatTimeout(long heartbeatTimeout) {
        if (this.state.get() == State.RUNNING) {
            this.cancelTimeout();
            this.futureTimeout = this.scheduledExecutor.schedule(this, heartbeatTimeout, TimeUnit.MILLISECONDS);
            if (this.state.get() != State.RUNNING) {
                this.cancelTimeout();
            }
        }
    }

    private void cancelTimeout() {
        if (this.futureTimeout != null) {
            this.futureTimeout.cancel(true);
        }
    }

    static class Factory<O>
    implements HeartbeatMonitor.Factory<O> {
        Factory() {
        }

        @Override
        public HeartbeatMonitor<O> createHeartbeatMonitor(ResourceID resourceID, HeartbeatTarget<O> heartbeatTarget, ScheduledExecutor mainThreadExecutor, HeartbeatListener<?, O> heartbeatListener, long heartbeatTimeoutIntervalMs) {
            return new HeartbeatMonitorImpl<O>(resourceID, heartbeatTarget, mainThreadExecutor, heartbeatListener, heartbeatTimeoutIntervalMs);
        }
    }

    private static enum State {
        RUNNING,
        TIMEOUT,
        CANCELED;

    }
}

