/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.io.network.partition.AbstractPartitionTracker;
import org.apache.flink.runtime.io.network.partition.PartitionTrackerEntry;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.TaskExecutorPartitionInfo;
import org.apache.flink.runtime.io.network.partition.TaskExecutorPartitionTracker;
import org.apache.flink.runtime.shuffle.ShuffleEnvironment;
import org.apache.flink.runtime.taskexecutor.partition.ClusterPartitionReport;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;

public class TaskExecutorPartitionTrackerImpl
extends AbstractPartitionTracker<JobID, TaskExecutorPartitionInfo>
implements TaskExecutorPartitionTracker {
    private final Map<TaskExecutorPartitionInfo, Set<ResultPartitionID>> clusterPartitions = new HashMap<TaskExecutorPartitionInfo, Set<ResultPartitionID>>();
    private final ShuffleEnvironment<?, ?> shuffleEnvironment;

    public TaskExecutorPartitionTrackerImpl(ShuffleEnvironment<?, ?> shuffleEnvironment) {
        this.shuffleEnvironment = shuffleEnvironment;
    }

    @Override
    public void startTrackingPartition(JobID producingJobId, TaskExecutorPartitionInfo partitionInfo) {
        Preconditions.checkNotNull((Object)producingJobId);
        Preconditions.checkNotNull((Object)partitionInfo);
        this.startTrackingPartition(producingJobId, partitionInfo.getResultPartitionId(), partitionInfo);
    }

    @Override
    public void stopTrackingAndReleaseJobPartitions(Collection<ResultPartitionID> partitionsToRelease) {
        this.stopTrackingPartitions(partitionsToRelease);
        this.shuffleEnvironment.releasePartitionsLocally(partitionsToRelease);
    }

    @Override
    public void stopTrackingAndReleaseJobPartitionsFor(JobID producingJobId) {
        Collection partitionsForJob = CollectionUtil.project(this.stopTrackingPartitionsFor(producingJobId), PartitionTrackerEntry::getResultPartitionId);
        this.shuffleEnvironment.releasePartitionsLocally(partitionsForJob);
    }

    @Override
    public void promoteJobPartitions(Collection<ResultPartitionID> partitionsToPromote) {
        Collection partitionTrackerEntries = this.stopTrackingPartitions(partitionsToPromote);
        Map newClusterPartitions = partitionTrackerEntries.stream().collect(Collectors.groupingBy(PartitionTrackerEntry::getMetaInfo, Collectors.mapping(PartitionTrackerEntry::getResultPartitionId, Collectors.toSet())));
        newClusterPartitions.forEach((dataSetMetaInfo, newPartitionEntries) -> this.clusterPartitions.compute((TaskExecutorPartitionInfo)dataSetMetaInfo, (ignored, existingPartitions) -> {
            if (existingPartitions == null) {
                return newPartitionEntries;
            }
            existingPartitions.addAll(newPartitionEntries);
            return existingPartitions;
        }));
    }

    @Override
    public void stopTrackingAndReleaseAllClusterPartitions() {
        this.clusterPartitions.values().forEach(this.shuffleEnvironment::releasePartitionsLocally);
        this.clusterPartitions.clear();
    }

    @Override
    public ClusterPartitionReport createClusterPartitionReport() {
        List<ClusterPartitionReport.ClusterPartitionReportEntry> collect = this.clusterPartitions.entrySet().stream().map(entry -> {
            TaskExecutorPartitionInfo dataSetMetaInfo = (TaskExecutorPartitionInfo)entry.getKey();
            Set partitionsIds = (Set)entry.getValue();
            return new ClusterPartitionReport.ClusterPartitionReportEntry(dataSetMetaInfo.getIntermediateDataSetId(), partitionsIds, dataSetMetaInfo.getNumberOfPartitions());
        }).collect(Collectors.toList());
        return new ClusterPartitionReport(collect);
    }
}

