/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition.consumer;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.runtime.event.TaskEvent;
import org.apache.flink.runtime.io.network.api.EndOfPartitionEvent;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.shaded.guava18.com.google.common.collect.Maps;
import org.apache.flink.shaded.guava18.com.google.common.collect.Sets;
import org.apache.flink.util.Preconditions;

public class UnionInputGate
extends InputGate {
    private final InputGate[] inputGates;
    private final Set<InputGate> inputGatesWithRemainingData;
    private final LinkedHashSet<InputGate> inputGatesWithData = new LinkedHashSet();
    private final int totalNumberOfInputChannels;
    private final Map<InputGate, Integer> inputGateToIndexOffsetMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UnionInputGate(InputGate ... inputGates) {
        this.inputGates = (InputGate[])Preconditions.checkNotNull((Object)inputGates);
        Preconditions.checkArgument((inputGates.length > 1 ? 1 : 0) != 0, (Object)"Union input gate should union at least two input gates.");
        this.inputGateToIndexOffsetMap = Maps.newHashMapWithExpectedSize((int)inputGates.length);
        this.inputGatesWithRemainingData = Sets.newHashSetWithExpectedSize((int)inputGates.length);
        int currentNumberOfInputChannels = 0;
        LinkedHashSet<InputGate> linkedHashSet = this.inputGatesWithData;
        synchronized (linkedHashSet) {
            for (InputGate inputGate : inputGates) {
                if (inputGate instanceof UnionInputGate) {
                    throw new UnsupportedOperationException("Cannot union a union of input gates.");
                }
                this.inputGateToIndexOffsetMap.put((InputGate)Preconditions.checkNotNull((Object)inputGate), currentNumberOfInputChannels);
                this.inputGatesWithRemainingData.add(inputGate);
                currentNumberOfInputChannels += inputGate.getNumberOfInputChannels();
                CompletableFuture<?> available = inputGate.getAvailableFuture();
                if (available.isDone()) {
                    this.inputGatesWithData.add(inputGate);
                    continue;
                }
                available.thenRun(() -> this.queueInputGate(inputGate));
            }
            if (!this.inputGatesWithData.isEmpty()) {
                this.availabilityHelper.resetAvailable();
            }
        }
        this.totalNumberOfInputChannels = currentNumberOfInputChannels;
    }

    @Override
    public int getNumberOfInputChannels() {
        return this.totalNumberOfInputChannels;
    }

    @Override
    public boolean isFinished() {
        return this.inputGatesWithRemainingData.isEmpty();
    }

    @Override
    public Optional<BufferOrEvent> getNext() throws IOException, InterruptedException {
        return this.getNextBufferOrEvent(true);
    }

    @Override
    public Optional<BufferOrEvent> pollNext() throws IOException, InterruptedException {
        return this.getNextBufferOrEvent(false);
    }

    private Optional<BufferOrEvent> getNextBufferOrEvent(boolean blocking) throws IOException, InterruptedException {
        if (this.inputGatesWithRemainingData.isEmpty()) {
            return Optional.empty();
        }
        Optional<InputGate.InputWithData<InputGate, BufferOrEvent>> next = this.waitAndGetNextData(blocking);
        if (!next.isPresent()) {
            return Optional.empty();
        }
        InputGate.InputWithData<InputGate, BufferOrEvent> inputWithData = next.get();
        this.handleEndOfPartitionEvent((BufferOrEvent)inputWithData.data, (InputGate)inputWithData.input);
        return Optional.of(this.adjustForUnionInputGate((BufferOrEvent)inputWithData.data, (InputGate)inputWithData.input, inputWithData.moreAvailable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<InputGate.InputWithData<InputGate, BufferOrEvent>> waitAndGetNextData(boolean blocking) throws IOException, InterruptedException {
        Optional<InputGate> inputGate;
        while ((inputGate = this.getInputGate(blocking)).isPresent()) {
            Optional<BufferOrEvent> bufferOrEvent = inputGate.get().pollNext();
            LinkedHashSet<InputGate> linkedHashSet = this.inputGatesWithData;
            synchronized (linkedHashSet) {
                if (bufferOrEvent.isPresent() && bufferOrEvent.get().moreAvailable()) {
                    this.inputGatesWithData.add(inputGate.get());
                } else if (!inputGate.get().isFinished()) {
                    inputGate.get().getAvailableFuture().thenRun(() -> this.queueInputGate((InputGate)inputGate.get()));
                }
                if (this.inputGatesWithData.isEmpty()) {
                    this.availabilityHelper.resetUnavailable();
                }
                if (bufferOrEvent.isPresent()) {
                    return Optional.of(new InputGate.InputWithData<InputGate, BufferOrEvent>(inputGate.get(), bufferOrEvent.get(), !this.inputGatesWithData.isEmpty()));
                }
            }
        }
        return Optional.empty();
    }

    private BufferOrEvent adjustForUnionInputGate(BufferOrEvent bufferOrEvent, InputGate inputGate, boolean moreInputGatesAvailable) {
        int channelIndexOffset = this.inputGateToIndexOffsetMap.get(inputGate);
        bufferOrEvent.setChannelIndex(channelIndexOffset + bufferOrEvent.getChannelIndex());
        bufferOrEvent.setMoreAvailable(bufferOrEvent.moreAvailable() || moreInputGatesAvailable);
        return bufferOrEvent;
    }

    private void handleEndOfPartitionEvent(BufferOrEvent bufferOrEvent, InputGate inputGate) {
        if (bufferOrEvent.isEvent() && bufferOrEvent.getEvent().getClass() == EndOfPartitionEvent.class && inputGate.isFinished()) {
            Preconditions.checkState((!bufferOrEvent.moreAvailable() ? 1 : 0) != 0);
            if (!this.inputGatesWithRemainingData.remove(inputGate)) {
                throw new IllegalStateException("Couldn't find input gate in set of remaining input gates.");
            }
            if (this.isFinished()) {
                this.markAvailable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAvailable() {
        CompletableFuture<?> toNotify;
        LinkedHashSet<InputGate> linkedHashSet = this.inputGatesWithData;
        synchronized (linkedHashSet) {
            toNotify = this.availabilityHelper.getUnavailableToResetAvailable();
        }
        toNotify.complete(null);
    }

    @Override
    public void sendTaskEvent(TaskEvent event) throws IOException {
        for (InputGate inputGate : this.inputGates) {
            inputGate.sendTaskEvent(event);
        }
    }

    @Override
    public void setup() {
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queueInputGate(InputGate inputGate) {
        Preconditions.checkNotNull((Object)inputGate);
        CompletableFuture<?> toNotify = null;
        LinkedHashSet<InputGate> linkedHashSet = this.inputGatesWithData;
        synchronized (linkedHashSet) {
            if (this.inputGatesWithData.contains(inputGate)) {
                return;
            }
            int availableInputGates = this.inputGatesWithData.size();
            this.inputGatesWithData.add(inputGate);
            if (availableInputGates == 0) {
                this.inputGatesWithData.notifyAll();
                toNotify = this.availabilityHelper.getUnavailableToResetAvailable();
            }
        }
        if (toNotify != null) {
            toNotify.complete(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<InputGate> getInputGate(boolean blocking) throws InterruptedException {
        LinkedHashSet<InputGate> linkedHashSet = this.inputGatesWithData;
        synchronized (linkedHashSet) {
            while (this.inputGatesWithData.size() == 0) {
                if (blocking) {
                    this.inputGatesWithData.wait();
                    continue;
                }
                this.availabilityHelper.resetUnavailable();
                return Optional.empty();
            }
            Iterator inputGateIterator = this.inputGatesWithData.iterator();
            InputGate inputGate = (InputGate)inputGateIterator.next();
            inputGateIterator.remove();
            return Optional.of(inputGate);
        }
    }
}

