/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.shaded.zookeeper.org.apache.zookeeper.server.util;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.jute.BinaryInputArchive;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.jute.InputArchive;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.jute.OutputArchive;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.jute.Record;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.server.DataTree;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.server.ZooTrace;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.txn.CreateSessionTxn;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.txn.CreateTxn;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.txn.CreateTxnV0;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.txn.DeleteTxn;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.txn.ErrorTxn;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.txn.MultiTxn;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.txn.SetACLTxn;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.txn.SetDataTxn;
import org.apache.flink.shaded.zookeeper.org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializeUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SerializeUtils.class);

    public static Record deserializeTxn(byte[] txnBytes, TxnHeader hdr) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(txnBytes);
        BinaryInputArchive ia = BinaryInputArchive.getArchive(bais);
        hdr.deserialize(ia, "hdr");
        bais.mark(bais.available());
        Record txn = null;
        switch (hdr.getType()) {
            case -10: {
                txn = new CreateSessionTxn();
                break;
            }
            case -11: {
                return null;
            }
            case 1: {
                txn = new CreateTxn();
                break;
            }
            case 2: {
                txn = new DeleteTxn();
                break;
            }
            case 5: {
                txn = new SetDataTxn();
                break;
            }
            case 7: {
                txn = new SetACLTxn();
                break;
            }
            case -1: {
                txn = new ErrorTxn();
                break;
            }
            case 14: {
                txn = new MultiTxn();
                break;
            }
            default: {
                throw new IOException("Unsupported Txn with type=%d" + hdr.getType());
            }
        }
        if (txn != null) {
            try {
                txn.deserialize(ia, "txn");
            }
            catch (EOFException e) {
                if (hdr.getType() == 1) {
                    CreateTxn create2 = (CreateTxn)txn;
                    bais.reset();
                    CreateTxnV0 createv0 = new CreateTxnV0();
                    createv0.deserialize(ia, "txn");
                    create2.setPath(createv0.getPath());
                    create2.setData(createv0.getData());
                    create2.setAcl(createv0.getAcl());
                    create2.setEphemeral(createv0.getEphemeral());
                    create2.setParentCVersion(-1);
                }
                throw e;
            }
        }
        return txn;
    }

    public static void deserializeSnapshot(DataTree dt, InputArchive ia, Map<Long, Integer> sessions) throws IOException {
        for (int count = ia.readInt("count"); count > 0; --count) {
            long id = ia.readLong("id");
            int to = ia.readInt("timeout");
            sessions.put(id, to);
            if (!LOG.isTraceEnabled()) continue;
            ZooTrace.logTraceMessage(LOG, 32L, "loadData --- session in archive: " + id + " with timeout: " + to);
        }
        dt.deserialize(ia, "tree");
    }

    public static void serializeSnapshot(DataTree dt, OutputArchive oa, Map<Long, Integer> sessions) throws IOException {
        HashMap<Long, Integer> sessSnap = new HashMap<Long, Integer>(sessions);
        oa.writeInt(sessSnap.size(), "count");
        for (Map.Entry<Long, Integer> entry : sessSnap.entrySet()) {
            oa.writeLong(entry.getKey(), "id");
            oa.writeInt(entry.getValue(), "timeout");
        }
        dt.serialize(oa, "tree");
    }
}

