/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.camel.StaticService;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.support.service.ServiceSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedResource(description="Managed ReactiveExecutor")
public class DefaultReactiveExecutor
extends ServiceSupport
implements ReactiveExecutor,
StaticService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultReactiveExecutor.class);
    private final ThreadLocal<Worker> workers = ThreadLocal.withInitial(new Supplier<Worker>(){

        @Override
        public Worker get() {
            int number = DefaultReactiveExecutor.this.createdWorkers.incrementAndGet();
            return new Worker(number, DefaultReactiveExecutor.this);
        }
    });
    private final AtomicInteger createdWorkers = new AtomicInteger();
    private final AtomicInteger runningWorkers = new AtomicInteger();
    private final AtomicInteger pendingTasks = new AtomicInteger();

    public void schedule(Runnable runnable) {
        this.workers.get().schedule(runnable, true, false, false);
    }

    public void scheduleMain(Runnable runnable) {
        this.workers.get().schedule(runnable, true, true, false);
    }

    public void scheduleSync(Runnable runnable) {
        this.workers.get().schedule(runnable, false, true, true);
    }

    public boolean executeFromQueue() {
        return this.workers.get().executeFromQueue();
    }

    @ManagedAttribute(description="Number of created workers")
    public int getCreatedWorkers() {
        return this.createdWorkers.get();
    }

    @ManagedAttribute(description="Number of running workers")
    public int getRunningWorkers() {
        return this.runningWorkers.get();
    }

    @ManagedAttribute(description="Number of pending tasks")
    public int getPendingTasks() {
        return this.pendingTasks.get();
    }

    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping DefaultReactiveExecutor [createdWorkers: {}, runningWorkers: {}, pendingTasks: {}]", new Object[]{this.getCreatedWorkers(), this.getRunningWorkers(), this.getPendingTasks()});
        }
    }

    private static class Worker {
        private final int number;
        private final DefaultReactiveExecutor executor;
        private volatile Deque<Runnable> queue = new ArrayDeque<Runnable>();
        private volatile Deque<Deque<Runnable>> back;
        private volatile boolean running;

        public Worker(int number, DefaultReactiveExecutor executor) {
            this.number = number;
            this.executor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void schedule(Runnable runnable, boolean first, boolean main, boolean sync) {
            block17: {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Schedule [first={}, main={}, sync={}]: {}", new Object[]{first, main, sync, runnable});
                }
                if (main && !this.queue.isEmpty()) {
                    if (this.back == null) {
                        this.back = new ArrayDeque<Deque<Runnable>>();
                    }
                    this.back.push(this.queue);
                    this.queue = new ArrayDeque<Runnable>();
                }
                if (first) {
                    this.queue.addFirst(runnable);
                    this.executor.pendingTasks.incrementAndGet();
                } else {
                    this.queue.addLast(runnable);
                    this.executor.pendingTasks.incrementAndGet();
                }
                if (!this.running || sync) {
                    this.running = true;
                    this.executor.runningWorkers.incrementAndGet();
                    block5: while (true) {
                        while (true) {
                            Runnable polled;
                            if ((polled = this.queue.pollFirst()) == null) {
                                if (this.back != null && !this.back.isEmpty()) {
                                    this.queue = this.back.pollFirst();
                                    continue;
                                }
                                break block17;
                            }
                            try {
                                this.executor.pendingTasks.decrementAndGet();
                                if (LOG.isTraceEnabled()) {
                                    LOG.trace("Worker #{} running: {}", (Object)this.number, (Object)runnable);
                                }
                                polled.run();
                                continue block5;
                            }
                            catch (Throwable t) {
                                LOG.warn("Error executing reactive work due to " + t.getMessage() + ". This exception is ignored.", t);
                                continue;
                            }
                            break;
                        }
                    }
                    finally {
                        this.running = false;
                        this.executor.runningWorkers.decrementAndGet();
                    }
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Queuing reactive work: {}", (Object)runnable);
                }
            }
        }

        boolean executeFromQueue() {
            Runnable polled;
            Runnable runnable = polled = this.queue != null ? this.queue.pollFirst() : null;
            if (polled == null) {
                return false;
            }
            try {
                this.executor.pendingTasks.decrementAndGet();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Running: {}", (Object)polled);
                }
                polled.run();
            }
            catch (Throwable t) {
                LOG.warn("Error executing reactive work due to " + t.getMessage() + ". This exception is ignored.", t);
            }
            return true;
        }
    }
}

