/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.cli;

import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.flink.annotation.Internal;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.UnmodifiableConfiguration;
import org.apache.flink.core.execution.DefaultExecutorServiceLoader;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ExecutorCLI
implements CustomCommandLine {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutorCLI.class);
    private static final String ID = "executor";
    private final Option executorOption = new Option("e", "executor", true, "The name of the executor to be used for executing the given job, which is equivalent to the \"" + DeploymentOptions.TARGET.key() + "\" config option. The currently available executors are: " + ExecutorCLI.getExecutorFactoryNames() + ".");
    private final Option dynamicProperties = Option.builder((String)"D").argName("property=value").numberOfArgs(2).valueSeparator('=').desc("Generic configuration options for execution/deployment and for the configured executor. The available options can be found at https://ci.apache.org/projects/flink/flink-docs-stable/ops/config.html").build();
    private final Configuration baseConfiguration;

    public ExecutorCLI(Configuration configuration) {
        this.baseConfiguration = new UnmodifiableConfiguration((Configuration)Preconditions.checkNotNull((Object)configuration));
    }

    @Override
    public boolean isActive(CommandLine commandLine) {
        return this.baseConfiguration.getOptional(DeploymentOptions.TARGET).isPresent() || commandLine.hasOption(this.executorOption.getOpt());
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public void addRunOptions(Options baseOptions) {
    }

    @Override
    public void addGeneralOptions(Options baseOptions) {
        baseOptions.addOption(this.executorOption);
        baseOptions.addOption(this.dynamicProperties);
    }

    @Override
    public Configuration applyCommandLineOptionsToConfiguration(CommandLine commandLine) {
        Configuration effectiveConfiguration = new Configuration(this.baseConfiguration);
        String executorName = commandLine.getOptionValue(this.executorOption.getOpt());
        if (executorName != null) {
            effectiveConfiguration.setString(DeploymentOptions.TARGET, executorName);
        }
        this.encodeDynamicProperties(commandLine, effectiveConfiguration);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Effective Configuration: {}", (Object)effectiveConfiguration);
        }
        return effectiveConfiguration;
    }

    private void encodeDynamicProperties(CommandLine commandLine, Configuration effectiveConfiguration) {
        Properties properties = commandLine.getOptionProperties(this.dynamicProperties.getOpt());
        properties.stringPropertyNames().forEach(key -> {
            String value = properties.getProperty((String)key);
            if (value != null) {
                effectiveConfiguration.setString(key, value);
            } else {
                effectiveConfiguration.setString(key, "true");
            }
        });
    }

    private static String getExecutorFactoryNames() {
        return DefaultExecutorServiceLoader.INSTANCE.getExecutorNames().map(name -> String.format("\"%s\"", name)).collect(Collectors.joining(", "));
    }
}

