/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.FallbackKey;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.description.Description;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class ConfigOptions {
    public static OptionBuilder key(String key) {
        Preconditions.checkNotNull(key);
        return new OptionBuilder(key);
    }

    private ConfigOptions() {
    }

    public static class ListConfigOptionBuilder<T> {
        private final String key;
        private final Class clazz;

        ListConfigOptionBuilder(String key, Class clazz) {
            this.key = key;
            this.clazz = clazz;
        }

        @SafeVarargs
        public final ConfigOption<List<T>> defaultValues(T ... values) {
            return new ConfigOption<List<T>>(this.key, this.clazz, ConfigOption.EMPTY_DESCRIPTION, Arrays.asList(values), true, new FallbackKey[0]);
        }

        public ConfigOption<List<T>> noDefaultValue() {
            return new ConfigOption<Object>(this.key, this.clazz, ConfigOption.EMPTY_DESCRIPTION, null, true, new FallbackKey[0]);
        }
    }

    public static class TypedConfigOptionBuilder<T> {
        private final String key;
        private final Class clazz;

        TypedConfigOptionBuilder(String key, Class clazz) {
            this.key = key;
            this.clazz = clazz;
        }

        public ListConfigOptionBuilder<T> asList() {
            return new ListConfigOptionBuilder(this.key, this.clazz);
        }

        public ConfigOption<T> defaultValue(T value) {
            return new ConfigOption<T>(this.key, this.clazz, ConfigOption.EMPTY_DESCRIPTION, value, false, new FallbackKey[0]);
        }

        public ConfigOption<T> noDefaultValue() {
            return new ConfigOption<Object>(this.key, this.clazz, Description.builder().text("").build(), null, false, new FallbackKey[0]);
        }
    }

    public static final class OptionBuilder {
        private final String key;

        OptionBuilder(String key) {
            this.key = key;
        }

        public TypedConfigOptionBuilder<Boolean> booleanType() {
            return new TypedConfigOptionBuilder<Boolean>(this.key, Boolean.class);
        }

        public TypedConfigOptionBuilder<Integer> intType() {
            return new TypedConfigOptionBuilder<Integer>(this.key, Integer.class);
        }

        public TypedConfigOptionBuilder<Long> longType() {
            return new TypedConfigOptionBuilder<Long>(this.key, Long.class);
        }

        public TypedConfigOptionBuilder<Float> floatType() {
            return new TypedConfigOptionBuilder<Float>(this.key, Float.class);
        }

        public TypedConfigOptionBuilder<Double> doubleType() {
            return new TypedConfigOptionBuilder<Double>(this.key, Double.class);
        }

        public TypedConfigOptionBuilder<String> stringType() {
            return new TypedConfigOptionBuilder<String>(this.key, String.class);
        }

        public TypedConfigOptionBuilder<Duration> durationType() {
            return new TypedConfigOptionBuilder<Duration>(this.key, Duration.class);
        }

        public TypedConfigOptionBuilder<MemorySize> memoryType() {
            return new TypedConfigOptionBuilder<MemorySize>(this.key, MemorySize.class);
        }

        public <T extends Enum<T>> TypedConfigOptionBuilder<T> enumType(Class<T> enumClass) {
            return new TypedConfigOptionBuilder(this.key, enumClass);
        }

        public TypedConfigOptionBuilder<Map<String, String>> mapType() {
            return new TypedConfigOptionBuilder<Map<String, String>>(this.key, Map.class);
        }

        @Deprecated
        public <T> ConfigOption<T> defaultValue(T value) {
            Preconditions.checkNotNull(value);
            return new ConfigOption<T>(this.key, value.getClass(), ConfigOption.EMPTY_DESCRIPTION, value, false, new FallbackKey[0]);
        }

        @Deprecated
        public ConfigOption<String> noDefaultValue() {
            return new ConfigOption<Object>(this.key, String.class, ConfigOption.EMPTY_DESCRIPTION, null, false, new FallbackKey[0]);
        }
    }
}

