/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.util.Preconditions;

@Internal
public class ConfigUtils {
    public static <IN, OUT> void encodeArrayToConfig(WritableConfig configuration, ConfigOption<List<OUT>> key, @Nullable IN[] values, Function<IN, OUT> mapper) {
        Preconditions.checkNotNull(configuration);
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(mapper);
        if (values == null) {
            return;
        }
        ConfigUtils.encodeCollectionToConfig(configuration, key, Arrays.asList(values), mapper);
    }

    public static <IN, OUT> void encodeCollectionToConfig(WritableConfig configuration, ConfigOption<List<OUT>> key, @Nullable Collection<IN> values, Function<IN, OUT> mapper) {
        Preconditions.checkNotNull(configuration);
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(mapper);
        if (values == null) {
            return;
        }
        List encodedOption = values.stream().filter(Objects::nonNull).map(mapper).filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
        if (!encodedOption.isEmpty()) {
            configuration.set(key, encodedOption);
        }
    }

    public static <IN, OUT> List<OUT> decodeListFromConfig(ReadableConfig configuration, ConfigOption<List<IN>> key, Function<IN, OUT> mapper) {
        Preconditions.checkNotNull(configuration);
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(mapper);
        List<IN> encodedString = configuration.get(key);
        return encodedString != null ? encodedString.stream().map(mapper).collect(Collectors.toList()) : Collections.emptyList();
    }

    private ConfigUtils() {
    }
}

