/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.annotation.Internal;
import org.apache.flink.util.JavaGcCleanerWrapper;
import sun.misc.Unsafe;

@Internal
public class MemoryUtils {
    public static final Unsafe UNSAFE = MemoryUtils.getUnsafe();
    public static final ByteOrder NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();
    private static final Constructor<?> DIRECT_BUFFER_CONSTRUCTOR = MemoryUtils.getDirectBufferPrivateConstructor();

    private static Unsafe getUnsafe() {
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            return (Unsafe)unsafeField.get(null);
        }
        catch (SecurityException e) {
            throw new Error("Could not access the sun.misc.Unsafe handle, permission denied by security manager.", e);
        }
        catch (NoSuchFieldException e) {
            throw new Error("The static handle field in sun.misc.Unsafe was not found.");
        }
        catch (IllegalArgumentException e) {
            throw new Error("Bug: Illegal argument reflection access for static field.", e);
        }
        catch (IllegalAccessException e) {
            throw new Error("Access to sun.misc.Unsafe is forbidden by the runtime.", e);
        }
        catch (Throwable t) {
            throw new Error("Unclassified error while trying to access the sun.misc.Unsafe handle.", t);
        }
    }

    private MemoryUtils() {
    }

    private static Constructor<? extends ByteBuffer> getDirectBufferPrivateConstructor() {
        try {
            Constructor<?> constructor = ByteBuffer.allocateDirect(1).getClass().getDeclaredConstructor(Long.TYPE, Integer.TYPE);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new Error("The private constructor java.nio.DirectByteBuffer.<init>(long, int) is not available.", e);
        }
        catch (SecurityException e) {
            throw new Error("The private constructor java.nio.DirectByteBuffer.<init>(long, int) is not available, permission denied by security manager", e);
        }
        catch (Throwable t) {
            throw new Error("Unclassified error while trying to access private constructor java.nio.DirectByteBuffer.<init>(long, int).", t);
        }
    }

    static long allocateUnsafe(long size) {
        return UNSAFE.allocateMemory(Math.max(1L, size));
    }

    static Runnable createMemoryGcCleaner(Object owner, long address) {
        return JavaGcCleanerWrapper.create(owner, () -> MemoryUtils.releaseUnsafe(address));
    }

    private static void releaseUnsafe(long address) {
        UNSAFE.freeMemory(address);
    }

    static ByteBuffer wrapUnsafeMemoryWithByteBuffer(long address, int size) {
        try {
            return (ByteBuffer)DIRECT_BUFFER_CONSTRUCTOR.newInstance(address, size);
        }
        catch (Throwable t) {
            throw new Error("Failed to wrap unsafe off-heap memory with ByteBuffer", t);
        }
    }
}

