/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.flink.client.deployment.ClusterClientFactory;
import org.apache.flink.client.deployment.ClusterClientServiceLoader;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClusterClientServiceLoader
implements ClusterClientServiceLoader {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultClusterClientServiceLoader.class);
    private static final ServiceLoader<ClusterClientFactory> defaultLoader = ServiceLoader.load(ClusterClientFactory.class);

    @Override
    public <ClusterID> ClusterClientFactory<ClusterID> getClusterClientFactory(Configuration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        ArrayList<ClusterClientFactory> compatibleFactories = new ArrayList<ClusterClientFactory>();
        Iterator<ClusterClientFactory> factories = defaultLoader.iterator();
        while (factories.hasNext()) {
            try {
                ClusterClientFactory factory = factories.next();
                if (factory == null || !factory.isCompatibleWith(configuration)) continue;
                compatibleFactories.add(factory);
            }
            catch (Throwable e2) {
                if (e2.getCause() instanceof NoClassDefFoundError) {
                    LOG.info("Could not load factory due to missing dependencies.");
                    continue;
                }
                throw e2;
            }
        }
        if (compatibleFactories.size() > 1) {
            List configStr = configuration.toMap().entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.toList());
            throw new IllegalStateException("Multiple compatible client factories found for:\n" + String.join((CharSequence)"\n", configStr) + ".");
        }
        return compatibleFactories.isEmpty() ? null : (ClusterClientFactory)compatibleFactories.get(0);
    }
}

