/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.executors;

import javax.annotation.Nonnull;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.client.FlinkPipelineTranslationUtil;
import org.apache.flink.client.cli.ExecutionConfigAccessor;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.util.Preconditions;

public class ExecutorUtils {
    public static JobGraph getJobGraph(@Nonnull Pipeline pipeline, @Nonnull Configuration configuration) {
        Preconditions.checkNotNull((Object)pipeline);
        Preconditions.checkNotNull((Object)configuration);
        ExecutionConfigAccessor executionConfigAccessor = ExecutionConfigAccessor.fromConfiguration(configuration);
        JobGraph jobGraph = FlinkPipelineTranslationUtil.getJobGraph(pipeline, configuration, executionConfigAccessor.getParallelism());
        jobGraph.addJars(executionConfigAccessor.getJars());
        jobGraph.setClasspaths(executionConfigAccessor.getClasspaths());
        jobGraph.setSavepointRestoreSettings(executionConfigAccessor.getSavepointRestoreSettings());
        return jobGraph;
    }
}

