/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.RunnableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.DoneFuture;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.StateUtil;
import org.apache.flink.util.ExceptionUtils;

public class OperatorSnapshotFutures {
    @Nonnull
    private RunnableFuture<SnapshotResult<KeyedStateHandle>> keyedStateManagedFuture;
    @Nonnull
    private RunnableFuture<SnapshotResult<KeyedStateHandle>> keyedStateRawFuture;
    @Nonnull
    private RunnableFuture<SnapshotResult<OperatorStateHandle>> operatorStateManagedFuture;
    @Nonnull
    private RunnableFuture<SnapshotResult<OperatorStateHandle>> operatorStateRawFuture;

    public OperatorSnapshotFutures() {
        this((RunnableFuture<SnapshotResult<KeyedStateHandle>>)DoneFuture.of((Object)SnapshotResult.empty()), (RunnableFuture<SnapshotResult<KeyedStateHandle>>)DoneFuture.of((Object)SnapshotResult.empty()), (RunnableFuture<SnapshotResult<OperatorStateHandle>>)DoneFuture.of((Object)SnapshotResult.empty()), (RunnableFuture<SnapshotResult<OperatorStateHandle>>)DoneFuture.of((Object)SnapshotResult.empty()));
    }

    public OperatorSnapshotFutures(@Nonnull RunnableFuture<SnapshotResult<KeyedStateHandle>> keyedStateManagedFuture, @Nonnull RunnableFuture<SnapshotResult<KeyedStateHandle>> keyedStateRawFuture, @Nonnull RunnableFuture<SnapshotResult<OperatorStateHandle>> operatorStateManagedFuture, @Nonnull RunnableFuture<SnapshotResult<OperatorStateHandle>> operatorStateRawFuture) {
        this.keyedStateManagedFuture = keyedStateManagedFuture;
        this.keyedStateRawFuture = keyedStateRawFuture;
        this.operatorStateManagedFuture = operatorStateManagedFuture;
        this.operatorStateRawFuture = operatorStateRawFuture;
    }

    @Nonnull
    public RunnableFuture<SnapshotResult<KeyedStateHandle>> getKeyedStateManagedFuture() {
        return this.keyedStateManagedFuture;
    }

    public void setKeyedStateManagedFuture(@Nonnull RunnableFuture<SnapshotResult<KeyedStateHandle>> keyedStateManagedFuture) {
        this.keyedStateManagedFuture = keyedStateManagedFuture;
    }

    @Nonnull
    public RunnableFuture<SnapshotResult<KeyedStateHandle>> getKeyedStateRawFuture() {
        return this.keyedStateRawFuture;
    }

    public void setKeyedStateRawFuture(@Nonnull RunnableFuture<SnapshotResult<KeyedStateHandle>> keyedStateRawFuture) {
        this.keyedStateRawFuture = keyedStateRawFuture;
    }

    @Nonnull
    public RunnableFuture<SnapshotResult<OperatorStateHandle>> getOperatorStateManagedFuture() {
        return this.operatorStateManagedFuture;
    }

    public void setOperatorStateManagedFuture(@Nonnull RunnableFuture<SnapshotResult<OperatorStateHandle>> operatorStateManagedFuture) {
        this.operatorStateManagedFuture = operatorStateManagedFuture;
    }

    @Nonnull
    public RunnableFuture<SnapshotResult<OperatorStateHandle>> getOperatorStateRawFuture() {
        return this.operatorStateRawFuture;
    }

    public void setOperatorStateRawFuture(@Nonnull RunnableFuture<SnapshotResult<OperatorStateHandle>> operatorStateRawFuture) {
        this.operatorStateRawFuture = operatorStateRawFuture;
    }

    public void cancel() throws Exception {
        Exception exception = null;
        try {
            StateUtil.discardStateFuture(this.getKeyedStateManagedFuture());
        }
        catch (Exception e) {
            exception = new Exception("Could not properly cancel managed keyed state future.", e);
        }
        try {
            StateUtil.discardStateFuture(this.getOperatorStateManagedFuture());
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)new Exception("Could not properly cancel managed operator state future.", e), (Throwable)exception);
        }
        try {
            StateUtil.discardStateFuture(this.getKeyedStateRawFuture());
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)new Exception("Could not properly cancel raw keyed state future.", e), (Throwable)exception);
        }
        try {
            StateUtil.discardStateFuture(this.getOperatorStateRawFuture());
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)new Exception("Could not properly cancel raw operator state future.", e), (Throwable)exception);
        }
        if (exception != null) {
            throw exception;
        }
    }
}

