/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators.co;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.base.ListSerializer;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.state.StateInitializationContext;
import org.apache.flink.streaming.api.functions.co.ProcessJoinFunction;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class IntervalJoinOperator<K, T1, T2, OUT>
extends AbstractUdfStreamOperator<OUT, ProcessJoinFunction<T1, T2, OUT>>
implements TwoInputStreamOperator<T1, T2, OUT>,
Triggerable<K, String> {
    private static final long serialVersionUID = -5380774605111543454L;
    private static final Logger logger = LoggerFactory.getLogger(IntervalJoinOperator.class);
    private static final String LEFT_BUFFER = "LEFT_BUFFER";
    private static final String RIGHT_BUFFER = "RIGHT_BUFFER";
    private static final String CLEANUP_TIMER_NAME = "CLEANUP_TIMER";
    private static final String CLEANUP_NAMESPACE_LEFT = "CLEANUP_LEFT";
    private static final String CLEANUP_NAMESPACE_RIGHT = "CLEANUP_RIGHT";
    private final long lowerBound;
    private final long upperBound;
    private final TypeSerializer<T1> leftTypeSerializer;
    private final TypeSerializer<T2> rightTypeSerializer;
    private transient MapState<Long, List<BufferEntry<T1>>> leftBuffer;
    private transient MapState<Long, List<BufferEntry<T2>>> rightBuffer;
    private transient TimestampedCollector<OUT> collector;
    private transient ContextImpl context;
    private transient InternalTimerService<String> internalTimerService;

    public IntervalJoinOperator(long lowerBound, long upperBound, boolean lowerBoundInclusive, boolean upperBoundInclusive, TypeSerializer<T1> leftTypeSerializer, TypeSerializer<T2> rightTypeSerializer, ProcessJoinFunction<T1, T2, OUT> udf) {
        super((Function)Preconditions.checkNotNull(udf));
        Preconditions.checkArgument((lowerBound <= upperBound ? 1 : 0) != 0, (Object)"lowerBound <= upperBound must be fulfilled");
        this.lowerBound = lowerBoundInclusive ? lowerBound : lowerBound + 1L;
        this.upperBound = upperBoundInclusive ? upperBound : upperBound - 1L;
        this.leftTypeSerializer = (TypeSerializer)Preconditions.checkNotNull(leftTypeSerializer);
        this.rightTypeSerializer = (TypeSerializer)Preconditions.checkNotNull(rightTypeSerializer);
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.collector = new TimestampedCollector(this.output);
        this.context = new ContextImpl((ProcessJoinFunction)this.userFunction);
        this.internalTimerService = this.getInternalTimerService(CLEANUP_TIMER_NAME, StringSerializer.INSTANCE, this);
    }

    @Override
    public void initializeState(StateInitializationContext context) throws Exception {
        super.initializeState(context);
        this.leftBuffer = context.getKeyedStateStore().getMapState(new MapStateDescriptor(LEFT_BUFFER, (TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)new ListSerializer(new BufferEntrySerializer<T1>(this.leftTypeSerializer))));
        this.rightBuffer = context.getKeyedStateStore().getMapState(new MapStateDescriptor(RIGHT_BUFFER, (TypeSerializer)LongSerializer.INSTANCE, (TypeSerializer)new ListSerializer(new BufferEntrySerializer<T2>(this.rightTypeSerializer))));
    }

    @Override
    public void processElement1(StreamRecord<T1> record) throws Exception {
        this.processElement(record, this.leftBuffer, this.rightBuffer, this.lowerBound, this.upperBound, true);
    }

    @Override
    public void processElement2(StreamRecord<T2> record) throws Exception {
        this.processElement(record, this.rightBuffer, this.leftBuffer, -this.upperBound, -this.lowerBound, false);
    }

    private <THIS, OTHER> void processElement(StreamRecord<THIS> record, MapState<Long, List<BufferEntry<THIS>>> ourBuffer, MapState<Long, List<BufferEntry<OTHER>>> otherBuffer, long relativeLowerBound, long relativeUpperBound, boolean isLeft) throws Exception {
        long cleanupTime;
        THIS ourValue = record.getValue();
        long ourTimestamp = record.getTimestamp();
        if (ourTimestamp == Long.MIN_VALUE) {
            throw new FlinkException("Long.MIN_VALUE timestamp: Elements used in interval stream joins need to have timestamps meaningful timestamps.");
        }
        if (this.isLate(ourTimestamp)) {
            return;
        }
        IntervalJoinOperator.addToBuffer(ourBuffer, ourValue, ourTimestamp);
        for (Map.Entry bucket : otherBuffer.entries()) {
            long timestamp = (Long)bucket.getKey();
            if (timestamp < ourTimestamp + relativeLowerBound || timestamp > ourTimestamp + relativeUpperBound) continue;
            for (BufferEntry entry : (List)bucket.getValue()) {
                if (isLeft) {
                    this.collect(ourValue, entry.element, ourTimestamp, timestamp);
                    continue;
                }
                this.collect(entry.element, ourValue, timestamp, ourTimestamp);
            }
        }
        long l = cleanupTime = relativeUpperBound > 0L ? ourTimestamp + relativeUpperBound : ourTimestamp;
        if (isLeft) {
            this.internalTimerService.registerEventTimeTimer(CLEANUP_NAMESPACE_LEFT, cleanupTime);
        } else {
            this.internalTimerService.registerEventTimeTimer(CLEANUP_NAMESPACE_RIGHT, cleanupTime);
        }
    }

    private boolean isLate(long timestamp) {
        long currentWatermark = this.internalTimerService.currentWatermark();
        return currentWatermark != Long.MIN_VALUE && timestamp < currentWatermark;
    }

    private void collect(T1 left, T2 right, long leftTimestamp, long rightTimestamp) throws Exception {
        long resultTimestamp = Math.max(leftTimestamp, rightTimestamp);
        this.collector.setAbsoluteTimestamp(resultTimestamp);
        this.context.updateTimestamps(leftTimestamp, rightTimestamp, resultTimestamp);
        ((ProcessJoinFunction)this.userFunction).processElement(left, right, this.context, this.collector);
    }

    private static <T> void addToBuffer(MapState<Long, List<BufferEntry<T>>> buffer, T value, long timestamp) throws Exception {
        ArrayList<BufferEntry<T>> elemsInBucket = (ArrayList<BufferEntry<T>>)buffer.get((Object)timestamp);
        if (elemsInBucket == null) {
            elemsInBucket = new ArrayList<BufferEntry<T>>();
        }
        elemsInBucket.add(new BufferEntry<T>(value, false));
        buffer.put((Object)timestamp, elemsInBucket);
    }

    @Override
    public void onEventTime(InternalTimer<K, String> timer) throws Exception {
        long timerTimestamp = timer.getTimestamp();
        String namespace = timer.getNamespace();
        logger.trace("onEventTime @ {}", (Object)timerTimestamp);
        switch (namespace) {
            case "CLEANUP_LEFT": {
                long timestamp = this.upperBound <= 0L ? timerTimestamp : timerTimestamp - this.upperBound;
                logger.trace("Removing from left buffer @ {}", (Object)timestamp);
                this.leftBuffer.remove((Object)timestamp);
                break;
            }
            case "CLEANUP_RIGHT": {
                long timestamp = this.lowerBound <= 0L ? timerTimestamp + this.lowerBound : timerTimestamp;
                logger.trace("Removing from right buffer @ {}", (Object)timestamp);
                this.rightBuffer.remove((Object)timestamp);
                break;
            }
            default: {
                throw new RuntimeException("Invalid namespace " + namespace);
            }
        }
    }

    @Override
    public void onProcessingTime(InternalTimer<K, String> timer) throws Exception {
    }

    @VisibleForTesting
    MapState<Long, List<BufferEntry<T1>>> getLeftBuffer() {
        return this.leftBuffer;
    }

    @VisibleForTesting
    MapState<Long, List<BufferEntry<T2>>> getRightBuffer() {
        return this.rightBuffer;
    }

    public static final class BufferEntrySerializerSnapshot<T>
    extends CompositeTypeSerializerSnapshot<BufferEntry<T>, BufferEntrySerializer<T>> {
        private static final int VERSION = 2;

        public BufferEntrySerializerSnapshot() {
            super(BufferEntrySerializer.class);
        }

        BufferEntrySerializerSnapshot(BufferEntrySerializer<T> serializerInstance) {
            super(serializerInstance);
        }

        protected int getCurrentOuterSnapshotVersion() {
            return 2;
        }

        protected TypeSerializer<?>[] getNestedSerializers(BufferEntrySerializer<T> outerSerializer) {
            return new TypeSerializer[]{((BufferEntrySerializer)outerSerializer).elementSerializer};
        }

        protected BufferEntrySerializer<T> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            return new BufferEntrySerializer(nestedSerializers[0]);
        }
    }

    @Deprecated
    public static class BufferSerializerConfigSnapshot<T>
    extends CompositeTypeSerializerConfigSnapshot<BufferEntry<T>> {
        private static final int VERSION = 1;

        public BufferSerializerConfigSnapshot() {
        }

        public BufferSerializerConfigSnapshot(TypeSerializer<T> userTypeSerializer) {
            super(new TypeSerializer[]{userTypeSerializer});
        }

        public int getVersion() {
            return 1;
        }

        public TypeSerializerSchemaCompatibility<BufferEntry<T>> resolveSchemaCompatibility(TypeSerializer<BufferEntry<T>> newSerializer) {
            return CompositeTypeSerializerUtil.delegateCompatibilityCheckToNewSnapshot(newSerializer, new BufferEntrySerializerSnapshot(), (TypeSerializerSnapshot[])new TypeSerializerSnapshot[]{(TypeSerializerSnapshot)this.getSingleNestedSerializerAndConfig().f1});
        }
    }

    @Internal
    @VisibleForTesting
    static class BufferEntrySerializer<T>
    extends TypeSerializer<BufferEntry<T>> {
        private static final long serialVersionUID = -20197698803836236L;
        private final TypeSerializer<T> elementSerializer;

        BufferEntrySerializer(TypeSerializer<T> elementSerializer) {
            this.elementSerializer = (TypeSerializer)Preconditions.checkNotNull(elementSerializer);
        }

        public boolean isImmutableType() {
            return true;
        }

        public TypeSerializer<BufferEntry<T>> duplicate() {
            return new BufferEntrySerializer<T>(this.elementSerializer.duplicate());
        }

        public BufferEntry<T> createInstance() {
            return null;
        }

        public BufferEntry<T> copy(BufferEntry<T> from) {
            return new BufferEntry<Object>(((BufferEntry)from).element, ((BufferEntry)from).hasBeenJoined);
        }

        public BufferEntry<T> copy(BufferEntry<T> from, BufferEntry<T> reuse) {
            return this.copy(from);
        }

        public int getLength() {
            return -1;
        }

        public void serialize(BufferEntry<T> record, DataOutputView target) throws IOException {
            target.writeBoolean(((BufferEntry)record).hasBeenJoined);
            this.elementSerializer.serialize(((BufferEntry)record).element, target);
        }

        public BufferEntry<T> deserialize(DataInputView source) throws IOException {
            boolean hasBeenJoined = source.readBoolean();
            Object element = this.elementSerializer.deserialize(source);
            return new BufferEntry<Object>(element, hasBeenJoined);
        }

        public BufferEntry<T> deserialize(BufferEntry<T> reuse, DataInputView source) throws IOException {
            return this.deserialize(source);
        }

        public void copy(DataInputView source, DataOutputView target) throws IOException {
            target.writeBoolean(source.readBoolean());
            this.elementSerializer.copy(source, target);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            BufferEntrySerializer that = (BufferEntrySerializer)((Object)o);
            return Objects.equals(this.elementSerializer, that.elementSerializer);
        }

        public int hashCode() {
            return Objects.hash(this.elementSerializer);
        }

        public TypeSerializerSnapshot<BufferEntry<T>> snapshotConfiguration() {
            return new BufferEntrySerializerSnapshot(this);
        }
    }

    @Internal
    @VisibleForTesting
    static class BufferEntry<T> {
        private final T element;
        private final boolean hasBeenJoined;

        BufferEntry(T element, boolean hasBeenJoined) {
            this.element = element;
            this.hasBeenJoined = hasBeenJoined;
        }
    }

    private final class ContextImpl
    extends ProcessJoinFunction.Context {
        private long resultTimestamp;
        private long leftTimestamp;
        private long rightTimestamp;

        private ContextImpl(ProcessJoinFunction<T1, T2, OUT> func) {
            super(func);
            this.resultTimestamp = Long.MIN_VALUE;
            this.leftTimestamp = Long.MIN_VALUE;
            this.rightTimestamp = Long.MIN_VALUE;
        }

        private void updateTimestamps(long left, long right, long result) {
            this.leftTimestamp = left;
            this.rightTimestamp = right;
            this.resultTimestamp = result;
        }

        @Override
        public long getLeftTimestamp() {
            return this.leftTimestamp;
        }

        @Override
        public long getRightTimestamp() {
            return this.rightTimestamp;
        }

        @Override
        public long getTimestamp() {
            return this.resultTimestamp;
        }

        @Override
        public <X> void output(OutputTag<X> outputTag, X value) {
            Preconditions.checkArgument((outputTag != null ? 1 : 0) != 0, (Object)"OutputTag must not be null");
            IntervalJoinOperator.this.output.collect(outputTag, new StreamRecord<X>(value, this.getTimestamp()));
        }
    }
}

