/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.core.fs.FileSystemSafetyNet;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.SimpleCounter;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.TaskStateSnapshot;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.execution.CancelTaskException;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.api.CancelCheckpointMarker;
import org.apache.flink.runtime.io.network.api.writer.MultipleRecordWriters;
import org.apache.flink.runtime.io.network.api.writer.NonRecordWriter;
import org.apache.flink.runtime.io.network.api.writer.RecordWriter;
import org.apache.flink.runtime.io.network.api.writer.RecordWriterBuilder;
import org.apache.flink.runtime.io.network.api.writer.RecordWriterDelegate;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.api.writer.SingleRecordWriter;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.plugable.SerializationDelegate;
import org.apache.flink.runtime.state.CheckpointStorageWorkerView;
import org.apache.flink.runtime.state.CheckpointStreamFactory;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StateBackendLoader;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.taskmanager.DispatcherThreadFactory;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.runtime.util.FatalExitExceptionHandler;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.api.operators.MailboxExecutor;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFinalizer;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamTaskStateInitializer;
import org.apache.flink.streaming.api.operators.StreamTaskStateInitializerImpl;
import org.apache.flink.streaming.runtime.io.InputStatus;
import org.apache.flink.streaming.runtime.io.RecordWriterOutput;
import org.apache.flink.streaming.runtime.io.StreamInputProcessor;
import org.apache.flink.streaming.runtime.partitioner.ConfigurableStreamPartitioner;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusMaintainer;
import org.apache.flink.streaming.runtime.tasks.AsyncExceptionHandler;
import org.apache.flink.streaming.runtime.tasks.AsynchronousException;
import org.apache.flink.streaming.runtime.tasks.OperatorChain;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeCallback;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeServiceImpl;
import org.apache.flink.streaming.runtime.tasks.StreamTaskActionExecutor;
import org.apache.flink.streaming.runtime.tasks.SystemProcessingTimeService;
import org.apache.flink.streaming.runtime.tasks.TimerException;
import org.apache.flink.streaming.runtime.tasks.TimerService;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxDefaultAction;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxExecutorFactory;
import org.apache.flink.streaming.runtime.tasks.mailbox.MailboxProcessor;
import org.apache.flink.streaming.runtime.tasks.mailbox.TaskMailbox;
import org.apache.flink.streaming.runtime.tasks.mailbox.TaskMailboxImpl;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public abstract class StreamTask<OUT, OP extends StreamOperator<OUT>>
extends AbstractInvokable
implements AsyncExceptionHandler {
    public static final ThreadGroup TRIGGER_THREAD_GROUP = new ThreadGroup("Triggers");
    protected static final Logger LOG = LoggerFactory.getLogger(StreamTask.class);
    private final StreamTaskActionExecutor.SynchronizedStreamTaskActionExecutor actionExecutor;
    @Nullable
    protected StreamInputProcessor inputProcessor;
    protected OP headOperator;
    protected OperatorChain<OUT, OP> operatorChain;
    protected final StreamConfig configuration;
    protected StateBackend stateBackend;
    private CheckpointStorageWorkerView checkpointStorage;
    protected TimerService timerService;
    private final Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private final Map<String, Accumulator<?, ?>> accumulatorMap;
    private final CloseableRegistry cancelables = new CloseableRegistry();
    private final StreamTaskAsyncExceptionHandler asyncExceptionHandler;
    private volatile boolean isRunning;
    private volatile boolean canceled;
    private boolean disposedOperators;
    private ExecutorService asyncOperationsThreadPool;
    private final RecordWriterDelegate<SerializationDelegate<StreamRecord<OUT>>> recordWriter;
    protected final MailboxProcessor mailboxProcessor;
    private Long syncSavepointId = null;

    protected StreamTask(Environment env) {
        this(env, null);
    }

    protected StreamTask(Environment env, @Nullable TimerService timerService) {
        this(env, timerService, (Thread.UncaughtExceptionHandler)FatalExitExceptionHandler.INSTANCE);
    }

    protected StreamTask(Environment environment, @Nullable TimerService timerService, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this(environment, timerService, uncaughtExceptionHandler, StreamTaskActionExecutor.synchronizedExecutor());
    }

    protected StreamTask(Environment environment, @Nullable TimerService timerService, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, StreamTaskActionExecutor.SynchronizedStreamTaskActionExecutor actionExecutor) {
        this(environment, timerService, uncaughtExceptionHandler, actionExecutor, new TaskMailboxImpl(Thread.currentThread()));
    }

    protected StreamTask(Environment environment, @Nullable TimerService timerService, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, StreamTaskActionExecutor.SynchronizedStreamTaskActionExecutor actionExecutor, TaskMailbox mailbox) {
        super(environment);
        this.timerService = timerService;
        this.uncaughtExceptionHandler = (Thread.UncaughtExceptionHandler)Preconditions.checkNotNull((Object)uncaughtExceptionHandler);
        this.configuration = new StreamConfig(this.getTaskConfiguration());
        this.accumulatorMap = this.getEnvironment().getAccumulatorRegistry().getUserMap();
        this.recordWriter = StreamTask.createRecordWriterDelegate(this.configuration, environment);
        this.actionExecutor = (StreamTaskActionExecutor.SynchronizedStreamTaskActionExecutor)Preconditions.checkNotNull((Object)actionExecutor);
        this.mailboxProcessor = new MailboxProcessor(this::processInput, mailbox, actionExecutor);
        this.asyncExceptionHandler = new StreamTaskAsyncExceptionHandler(environment);
    }

    protected abstract void init() throws Exception;

    protected void cancelTask() throws Exception {
    }

    protected void cleanup() throws Exception {
        if (this.inputProcessor != null) {
            this.inputProcessor.close();
        }
    }

    protected void processInput(MailboxDefaultAction.Controller controller) throws Exception {
        InputStatus status = this.inputProcessor.processInput();
        if (status == InputStatus.MORE_AVAILABLE && this.recordWriter.isAvailable()) {
            return;
        }
        if (status == InputStatus.END_OF_INPUT) {
            controller.allActionsCompleted();
            return;
        }
        CompletableFuture<?> jointFuture = this.getInputOutputJointFuture(status);
        MailboxDefaultAction.Suspension suspendedDefaultAction = controller.suspendDefaultAction();
        jointFuture.thenRun(suspendedDefaultAction::resume);
    }

    private CompletableFuture<?> getInputOutputJointFuture(InputStatus status) {
        if (status == InputStatus.NOTHING_AVAILABLE && !this.recordWriter.isAvailable()) {
            return CompletableFuture.allOf(this.inputProcessor.getAvailableFuture(), this.recordWriter.getAvailableFuture());
        }
        if (status == InputStatus.NOTHING_AVAILABLE) {
            return this.inputProcessor.getAvailableFuture();
        }
        return this.recordWriter.getAvailableFuture();
    }

    private void resetSynchronousSavepointId() {
        this.syncSavepointId = null;
    }

    private void setSynchronousSavepointId(long checkpointId) {
        Preconditions.checkState((this.syncSavepointId == null ? 1 : 0) != 0, (Object)"at most one stop-with-savepoint checkpoint at a time is allowed");
        this.syncSavepointId = checkpointId;
    }

    @VisibleForTesting
    OptionalLong getSynchronousSavepointId() {
        return this.syncSavepointId != null ? OptionalLong.of(this.syncSavepointId) : OptionalLong.empty();
    }

    private boolean isSynchronousSavepointId(long checkpointId) {
        return this.syncSavepointId != null && this.syncSavepointId == checkpointId;
    }

    private void runSynchronousSavepointMailboxLoop() throws Exception {
        assert (this.syncSavepointId != null);
        MailboxExecutor mailboxExecutor = this.mailboxProcessor.getMailboxExecutor(Integer.MAX_VALUE);
        while (!this.canceled && this.syncSavepointId != null) {
            mailboxExecutor.yield();
        }
    }

    protected void advanceToEndOfEventTime() throws Exception {
    }

    protected void finishTask() throws Exception {
    }

    public StreamTaskStateInitializer createStreamTaskStateInitializer() {
        return new StreamTaskStateInitializerImpl(this.getEnvironment(), this.stateBackend);
    }

    protected Counter setupNumRecordsInCounter(StreamOperator streamOperator) {
        try {
            return ((OperatorMetricGroup)streamOperator.getMetricGroup()).getIOMetricGroup().getNumRecordsInCounter();
        }
        catch (Exception e) {
            LOG.warn("An exception occurred during the metrics setup.", (Throwable)e);
            return new SimpleCounter();
        }
    }

    private void beforeInvoke() throws Exception {
        this.disposedOperators = false;
        LOG.debug("Initializing {}.", (Object)this.getName());
        this.asyncOperationsThreadPool = Executors.newCachedThreadPool((ThreadFactory)new ExecutorThreadFactory("AsyncOperations", this.uncaughtExceptionHandler));
        this.stateBackend = this.createStateBackend();
        this.checkpointStorage = this.stateBackend.createCheckpointStorage(this.getEnvironment().getJobID());
        if (this.timerService == null) {
            DispatcherThreadFactory timerThreadFactory = new DispatcherThreadFactory(TRIGGER_THREAD_GROUP, "Time Trigger for " + this.getName());
            this.timerService = new SystemProcessingTimeService(this::handleTimerException, (ThreadFactory)timerThreadFactory);
        }
        this.operatorChain = new OperatorChain(this, this.recordWriter);
        this.headOperator = this.operatorChain.getHeadOperator();
        this.init();
        if (this.canceled) {
            throw new CancelTaskException();
        }
        LOG.debug("Invoking {}", (Object)this.getName());
        this.actionExecutor.runThrowing(() -> this.initializeStateAndOpen());
    }

    public final void invoke() throws Exception {
        try {
            this.beforeInvoke();
            if (this.canceled) {
                throw new CancelTaskException();
            }
            this.isRunning = true;
            this.runMailboxLoop();
            if (this.canceled) {
                throw new CancelTaskException();
            }
            this.afterInvoke();
        }
        finally {
            this.cleanUpInvoke();
        }
    }

    private void runMailboxLoop() throws Exception {
        try {
            this.mailboxProcessor.runMailboxLoop();
        }
        catch (Exception e) {
            Optional interruption = ExceptionUtils.findThrowable((Throwable)e, InterruptedException.class);
            if (interruption.isPresent()) {
                if (!this.canceled) {
                    Thread.currentThread().interrupt();
                    throw (InterruptedException)interruption.get();
                }
            }
            if (this.canceled) {
                LOG.warn("Error while canceling task.", (Throwable)e);
            }
            throw e;
        }
    }

    private void afterInvoke() throws Exception {
        LOG.debug("Finished task {}", (Object)this.getName());
        this.actionExecutor.runThrowing(() -> {
            this.closeAllOperators();
            this.timerService.quiesce();
            this.mailboxProcessor.prepareClose();
            this.isRunning = false;
        });
        this.mailboxProcessor.drain();
        this.timerService.awaitPendingAfterQuiesce();
        LOG.debug("Closed operators for task {}", (Object)this.getName());
        this.operatorChain.flushOutputs();
        this.disposeAllOperators(false);
        this.disposedOperators = true;
    }

    private void cleanUpInvoke() throws Exception {
        this.isRunning = false;
        this.setShouldInterruptOnCancel(false);
        Thread.interrupted();
        this.tryShutdownTimerService();
        try {
            this.cancelables.close();
            this.shutdownAsyncThreads();
        }
        catch (Throwable t) {
            LOG.error("Could not shut down async checkpoint threads", t);
        }
        try {
            this.cleanup();
        }
        catch (Throwable t) {
            LOG.error("Error during cleanup of stream task", t);
        }
        this.disposeAllOperators(true);
        if (this.operatorChain != null) {
            this.actionExecutor.run(() -> this.operatorChain.releaseOutputs());
        } else {
            this.recordWriter.close();
        }
        this.mailboxProcessor.close();
    }

    public final void cancel() throws Exception {
        this.isRunning = false;
        this.canceled = true;
        try {
            this.cancelTask();
        }
        finally {
            this.mailboxProcessor.allActionsCompleted();
            this.cancelables.close();
        }
    }

    public MailboxExecutorFactory getMailboxExecutorFactory() {
        return this.mailboxProcessor::getMailboxExecutor;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final boolean isCanceled() {
        return this.canceled;
    }

    private void closeAllOperators() throws Exception {
        StreamOperator<?>[] allOperators = this.operatorChain.getAllOperators();
        for (int i = allOperators.length - 1; i >= 0; --i) {
            StreamOperator<?> operator = allOperators[i];
            if (operator != null) {
                operator.close();
            }
            if (i <= 0) continue;
            this.operatorChain.endNonHeadOperatorInput(allOperators[i - 1]);
        }
    }

    private void shutdownAsyncThreads() throws Exception {
        if (!this.asyncOperationsThreadPool.isShutdown()) {
            this.asyncOperationsThreadPool.shutdownNow();
        }
    }

    private void disposeAllOperators(boolean logOnlyErrors) throws Exception {
        if (this.operatorChain != null && !this.disposedOperators) {
            for (StreamOperator<?> operator : this.operatorChain.getAllOperators()) {
                if (operator == null) continue;
                if (!logOnlyErrors) {
                    operator.dispose();
                    continue;
                }
                try {
                    operator.dispose();
                }
                catch (Exception e) {
                    LOG.error("Error during disposal of stream operator.", (Throwable)e);
                }
            }
            this.disposedOperators = true;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.timerService != null && !this.timerService.isTerminated()) {
            LOG.info("Timer service is shutting down.");
            this.timerService.shutdownService();
        }
        this.cancelables.close();
    }

    boolean isSerializingTimestamps() {
        TimeCharacteristic tc = this.configuration.getTimeCharacteristic();
        return tc == TimeCharacteristic.EventTime | tc == TimeCharacteristic.IngestionTime;
    }

    public String getName() {
        return this.getEnvironment().getTaskInfo().getTaskNameWithSubtasks();
    }

    String getTaskNameWithSubtaskAndId() {
        return this.getEnvironment().getTaskInfo().getTaskNameWithSubtasks() + " (" + this.getEnvironment().getExecutionId() + ')';
    }

    @Deprecated
    public Object getCheckpointLock() {
        return this.actionExecutor.getMutex();
    }

    public CheckpointStorageWorkerView getCheckpointStorage() {
        return this.checkpointStorage;
    }

    public StreamConfig getConfiguration() {
        return this.configuration;
    }

    public Map<String, Accumulator<?, ?>> getAccumulatorMap() {
        return this.accumulatorMap;
    }

    public StreamStatusMaintainer getStreamStatusMaintainer() {
        return this.operatorChain;
    }

    RecordWriterOutput<?>[] getStreamOutputs() {
        return this.operatorChain.getStreamOutputs();
    }

    public Future<Boolean> triggerCheckpointAsync(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, boolean advanceToEndOfEventTime) {
        return this.mailboxProcessor.getMainMailboxExecutor().submit(() -> this.triggerCheckpoint(checkpointMetaData, checkpointOptions, advanceToEndOfEventTime), "checkpoint %s with %s", checkpointMetaData, checkpointOptions);
    }

    private boolean triggerCheckpoint(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, boolean advanceToEndOfEventTime) throws Exception {
        try {
            CheckpointMetrics checkpointMetrics = new CheckpointMetrics().setBytesBufferedInAlignment(0L).setAlignmentDurationNanos(0L);
            boolean success = this.performCheckpoint(checkpointMetaData, checkpointOptions, checkpointMetrics, advanceToEndOfEventTime);
            if (!success) {
                this.declineCheckpoint(checkpointMetaData.getCheckpointId());
            }
            return success;
        }
        catch (Exception e) {
            if (this.isRunning) {
                Exception exception = new Exception("Could not perform checkpoint " + checkpointMetaData.getCheckpointId() + " for operator " + this.getName() + '.', e);
                this.handleCheckpointException(exception);
                throw exception;
            }
            LOG.debug("Could not perform checkpoint {} for operator {} while the invokable was not in state running.", new Object[]{checkpointMetaData.getCheckpointId(), this.getName(), e});
            return false;
        }
    }

    public void triggerCheckpointOnBarrier(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, CheckpointMetrics checkpointMetrics) throws Exception {
        try {
            if (this.performCheckpoint(checkpointMetaData, checkpointOptions, checkpointMetrics, false) && this.isSynchronousSavepointId(checkpointMetaData.getCheckpointId())) {
                this.runSynchronousSavepointMailboxLoop();
            }
        }
        catch (CancelTaskException e) {
            LOG.info("Operator {} was cancelled while performing checkpoint {}.", (Object)this.getName(), (Object)checkpointMetaData.getCheckpointId());
            throw e;
        }
        catch (Exception e) {
            throw new Exception("Could not perform checkpoint " + checkpointMetaData.getCheckpointId() + " for operator " + this.getName() + '.', e);
        }
    }

    public void abortCheckpointOnBarrier(long checkpointId, Throwable cause) throws Exception {
        LOG.debug("Aborting checkpoint via cancel-barrier {} for task {}", (Object)checkpointId, (Object)this.getName());
        this.getEnvironment().declineCheckpoint(checkpointId, cause);
        this.actionExecutor.runThrowing(() -> this.operatorChain.broadcastCheckpointCancelMarker(checkpointId));
    }

    private boolean performCheckpoint(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, CheckpointMetrics checkpointMetrics, boolean advanceToEndOfTime) throws Exception {
        LOG.debug("Starting checkpoint ({}) {} on task {}", new Object[]{checkpointMetaData.getCheckpointId(), checkpointOptions.getCheckpointType(), this.getName()});
        long checkpointId = checkpointMetaData.getCheckpointId();
        if (this.isRunning) {
            this.actionExecutor.runThrowing(() -> {
                if (checkpointOptions.getCheckpointType().isSynchronous()) {
                    this.setSynchronousSavepointId(checkpointId);
                    if (advanceToEndOfTime) {
                        this.advanceToEndOfEventTime();
                    }
                }
                this.operatorChain.prepareSnapshotPreBarrier(checkpointId);
                this.operatorChain.broadcastCheckpointBarrier(checkpointId, checkpointMetaData.getTimestamp(), checkpointOptions);
                this.checkpointState(checkpointMetaData, checkpointOptions, checkpointMetrics);
            });
            return true;
        }
        this.actionExecutor.runThrowing(() -> {
            CancelCheckpointMarker message = new CancelCheckpointMarker(checkpointMetaData.getCheckpointId());
            this.recordWriter.broadcastEvent((AbstractEvent)message);
        });
        return false;
    }

    protected void declineCheckpoint(long checkpointId) {
        this.getEnvironment().declineCheckpoint(checkpointId, (Throwable)new CheckpointException("Task Name" + this.getName(), CheckpointFailureReason.CHECKPOINT_DECLINED_TASK_NOT_READY));
    }

    protected void handleCheckpointException(Exception exception) {
        this.handleException(exception);
    }

    public ExecutorService getAsyncOperationsThreadPool() {
        return this.asyncOperationsThreadPool;
    }

    public Future<Void> notifyCheckpointCompleteAsync(long checkpointId) {
        return this.mailboxProcessor.getMailboxExecutor(Integer.MAX_VALUE).submit(() -> this.notifyCheckpointComplete(checkpointId), "checkpoint %d complete", checkpointId);
    }

    private void notifyCheckpointComplete(long checkpointId) {
        try {
            boolean success = this.actionExecutor.call(() -> {
                if (this.isRunning) {
                    LOG.debug("Notification of complete checkpoint for task {}", (Object)this.getName());
                    for (StreamOperator<?> operator : this.operatorChain.getAllOperators()) {
                        if (operator == null) continue;
                        operator.notifyCheckpointComplete(checkpointId);
                    }
                    return true;
                }
                LOG.debug("Ignoring notification of complete checkpoint for not-running task {}", (Object)this.getName());
                return true;
            });
            this.getEnvironment().getTaskStateManager().notifyCheckpointComplete(checkpointId);
            if (success && this.isSynchronousSavepointId(checkpointId)) {
                this.finishTask();
                this.resetSynchronousSavepointId();
            }
        }
        catch (Exception e) {
            this.handleException(new RuntimeException("Error while confirming checkpoint", e));
        }
    }

    private void tryShutdownTimerService() {
        if (this.timerService != null && !this.timerService.isTerminated()) {
            try {
                long timeoutMs = this.getEnvironment().getTaskManagerInfo().getConfiguration().getLong(TaskManagerOptions.TASK_CANCELLATION_TIMEOUT_TIMERS);
                if (!this.timerService.shutdownServiceUninterruptible(timeoutMs)) {
                    LOG.warn("Timer service shutdown exceeded time limit of {} ms while waiting for pending timers. Will continue with shutdown procedure.", (Object)timeoutMs);
                }
            }
            catch (Throwable t) {
                LOG.error("Could not shut down timer service", t);
            }
        }
    }

    private void checkpointState(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, CheckpointMetrics checkpointMetrics) throws Exception {
        CheckpointStreamFactory storage = this.checkpointStorage.resolveCheckpointStorageLocation(checkpointMetaData.getCheckpointId(), checkpointOptions.getTargetLocation());
        CheckpointingOperation checkpointingOperation = new CheckpointingOperation(this, checkpointMetaData, checkpointOptions, storage, checkpointMetrics);
        checkpointingOperation.executeCheckpointing();
    }

    private void initializeStateAndOpen() throws Exception {
        StreamOperator<?>[] allOperators;
        for (StreamOperator<?> operator : allOperators = this.operatorChain.getAllOperators()) {
            if (null == operator) continue;
            operator.initializeState();
            operator.open();
        }
    }

    private StateBackend createStateBackend() throws Exception {
        StateBackend fromApplication = this.configuration.getStateBackend(this.getUserCodeClassLoader());
        return StateBackendLoader.fromApplicationOrConfigOrDefault((StateBackend)fromApplication, (Configuration)this.getEnvironment().getTaskManagerInfo().getConfiguration(), (ClassLoader)this.getUserCodeClassLoader(), (Logger)LOG);
    }

    @VisibleForTesting
    TimerService getTimerService() {
        Preconditions.checkState((this.timerService != null ? 1 : 0) != 0, (Object)"The timer service has not been initialized.");
        return this.timerService;
    }

    public ProcessingTimeService getProcessingTimeService(int operatorIndex) {
        Preconditions.checkState((this.timerService != null ? 1 : 0) != 0, (Object)"The timer service has not been initialized.");
        MailboxExecutor mailboxExecutor = this.mailboxProcessor.getMailboxExecutor(operatorIndex);
        return new ProcessingTimeServiceImpl(this.timerService, callback -> this.deferCallbackToMailbox(mailboxExecutor, (ProcessingTimeCallback)callback));
    }

    @Override
    public void handleAsyncException(String message, Throwable exception) {
        if (this.isRunning) {
            this.asyncExceptionHandler.handleAsyncException(message, exception);
        }
    }

    private void handleException(Throwable exception) {
        if (this.isRunning) {
            this.getEnvironment().failExternally(exception);
        }
    }

    public String toString() {
        return this.getName();
    }

    public CloseableRegistry getCancelables() {
        return this.cancelables;
    }

    @VisibleForTesting
    public static <OUT> RecordWriterDelegate<SerializationDelegate<StreamRecord<OUT>>> createRecordWriterDelegate(StreamConfig configuration, Environment environment) {
        List<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>> recordWrites = StreamTask.createRecordWriters(configuration, environment);
        if (recordWrites.size() == 1) {
            return new SingleRecordWriter(recordWrites.get(0));
        }
        if (recordWrites.size() == 0) {
            return new NonRecordWriter();
        }
        return new MultipleRecordWriters(recordWrites);
    }

    private static <OUT> List<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>> createRecordWriters(StreamConfig configuration, Environment environment) {
        ArrayList<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>> recordWriters = new ArrayList<RecordWriter<SerializationDelegate<StreamRecord<OUT>>>>();
        List<StreamEdge> outEdgesInOrder = configuration.getOutEdgesInOrder(environment.getUserClassLoader());
        Map<Integer, StreamConfig> chainedConfigs = configuration.getTransitiveChainedTaskConfigsWithSelf(environment.getUserClassLoader());
        for (int i = 0; i < outEdgesInOrder.size(); ++i) {
            StreamEdge edge = outEdgesInOrder.get(i);
            recordWriters.add(StreamTask.createRecordWriter(edge, i, environment, environment.getTaskInfo().getTaskName(), chainedConfigs.get(edge.getSourceId()).getBufferTimeout()));
        }
        return recordWriters;
    }

    private static <OUT> RecordWriter<SerializationDelegate<StreamRecord<OUT>>> createRecordWriter(StreamEdge edge, int outputIndex, Environment environment, String taskName, long bufferTimeout) {
        int numKeyGroups;
        StreamPartitioner<?> outputPartitioner = edge.getPartitioner();
        LOG.debug("Using partitioner {} for output {} of task {}", new Object[]{outputPartitioner, outputIndex, taskName});
        ResultPartitionWriter bufferWriter = environment.getWriter(outputIndex);
        if (outputPartitioner instanceof ConfigurableStreamPartitioner && 0 < (numKeyGroups = bufferWriter.getNumTargetKeyGroups())) {
            ((ConfigurableStreamPartitioner)((Object)outputPartitioner)).configure(numKeyGroups);
        }
        RecordWriter output = new RecordWriterBuilder().setChannelSelector(outputPartitioner).setTimeout(bufferTimeout).setTaskName(taskName).build(bufferWriter);
        output.setMetricGroup(environment.getMetricGroup().getIOMetricGroup());
        return output;
    }

    private void handleTimerException(Exception ex) {
        this.handleAsyncException("Caught exception while processing timer.", new TimerException(ex));
    }

    private ProcessingTimeCallback deferCallbackToMailbox(MailboxExecutor mailboxExecutor, ProcessingTimeCallback callback) {
        return timestamp -> mailboxExecutor.execute(() -> this.invokeProcessingTimeCallback(callback, timestamp), "Timer callback for %s @ %d", callback, timestamp);
    }

    private void invokeProcessingTimeCallback(ProcessingTimeCallback callback, long timestamp) {
        try {
            callback.onProcessingTime(timestamp);
        }
        catch (Throwable t) {
            this.handleAsyncException("Caught exception while processing timer.", new TimerException(t));
        }
    }

    private static final class CheckpointingOperation {
        private final StreamTask<?, ?> owner;
        private final CheckpointMetaData checkpointMetaData;
        private final CheckpointOptions checkpointOptions;
        private final CheckpointMetrics checkpointMetrics;
        private final CheckpointStreamFactory storageLocation;
        private final StreamOperator<?>[] allOperators;
        private long startSyncPartNano;
        private long startAsyncPartNano;
        private final Map<OperatorID, OperatorSnapshotFutures> operatorSnapshotsInProgress;

        public CheckpointingOperation(StreamTask<?, ?> owner, CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, CheckpointStreamFactory checkpointStorageLocation, CheckpointMetrics checkpointMetrics) {
            this.owner = (StreamTask)Preconditions.checkNotNull(owner);
            this.checkpointMetaData = (CheckpointMetaData)Preconditions.checkNotNull((Object)checkpointMetaData);
            this.checkpointOptions = (CheckpointOptions)Preconditions.checkNotNull((Object)checkpointOptions);
            this.checkpointMetrics = (CheckpointMetrics)Preconditions.checkNotNull((Object)checkpointMetrics);
            this.storageLocation = (CheckpointStreamFactory)Preconditions.checkNotNull((Object)checkpointStorageLocation);
            this.allOperators = owner.operatorChain.getAllOperators();
            this.operatorSnapshotsInProgress = new HashMap<OperatorID, OperatorSnapshotFutures>(this.allOperators.length);
        }

        public void executeCheckpointing() throws Exception {
            this.startSyncPartNano = System.nanoTime();
            try {
                for (StreamOperator<?> op : this.allOperators) {
                    this.checkpointStreamOperator(op);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Finished synchronous checkpoints for checkpoint {} on task {}", (Object)this.checkpointMetaData.getCheckpointId(), (Object)this.owner.getName());
                }
                this.startAsyncPartNano = System.nanoTime();
                this.checkpointMetrics.setSyncDurationMillis((this.startAsyncPartNano - this.startSyncPartNano) / 1000000L);
                AsyncCheckpointRunnable asyncCheckpointRunnable = new AsyncCheckpointRunnable(this.owner, this.operatorSnapshotsInProgress, this.checkpointMetaData, this.checkpointMetrics, this.startAsyncPartNano);
                ((StreamTask)this.owner).cancelables.registerCloseable((Closeable)asyncCheckpointRunnable);
                ((StreamTask)this.owner).asyncOperationsThreadPool.execute(asyncCheckpointRunnable);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} - finished synchronous part of checkpoint {}. Alignment duration: {} ms, snapshot duration {} ms", new Object[]{this.owner.getName(), this.checkpointMetaData.getCheckpointId(), this.checkpointMetrics.getAlignmentDurationNanos() / 1000000L, this.checkpointMetrics.getSyncDurationMillis()});
                }
            }
            catch (Exception ex) {
                for (OperatorSnapshotFutures operatorSnapshotResult : this.operatorSnapshotsInProgress.values()) {
                    if (null == operatorSnapshotResult) continue;
                    try {
                        operatorSnapshotResult.cancel();
                    }
                    catch (Exception e) {
                        LOG.warn("Could not properly cancel an operator snapshot result.", (Throwable)e);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} - did NOT finish synchronous part of checkpoint {}. Alignment duration: {} ms, snapshot duration {} ms", new Object[]{this.owner.getName(), this.checkpointMetaData.getCheckpointId(), this.checkpointMetrics.getAlignmentDurationNanos() / 1000000L, this.checkpointMetrics.getSyncDurationMillis()});
                }
                if (this.checkpointOptions.getCheckpointType().isSynchronous()) {
                    throw ex;
                }
                this.owner.getEnvironment().declineCheckpoint(this.checkpointMetaData.getCheckpointId(), (Throwable)ex);
            }
        }

        private void checkpointStreamOperator(StreamOperator<?> op) throws Exception {
            if (null != op) {
                OperatorSnapshotFutures snapshotInProgress = op.snapshotState(this.checkpointMetaData.getCheckpointId(), this.checkpointMetaData.getTimestamp(), this.checkpointOptions, this.storageLocation);
                this.operatorSnapshotsInProgress.put(op.getOperatorID(), snapshotInProgress);
            }
        }

        private static enum AsyncCheckpointState {
            RUNNING,
            DISCARDED,
            COMPLETED;

        }
    }

    @VisibleForTesting
    protected static final class AsyncCheckpointRunnable
    implements Runnable,
    Closeable {
        private final StreamTask<?, ?> owner;
        private final Map<OperatorID, OperatorSnapshotFutures> operatorSnapshotsInProgress;
        private final CheckpointMetaData checkpointMetaData;
        private final CheckpointMetrics checkpointMetrics;
        private final long asyncStartNanos;
        private final AtomicReference<CheckpointingOperation.AsyncCheckpointState> asyncCheckpointState = new AtomicReference<CheckpointingOperation.AsyncCheckpointState>(CheckpointingOperation.AsyncCheckpointState.RUNNING);

        AsyncCheckpointRunnable(StreamTask<?, ?> owner, Map<OperatorID, OperatorSnapshotFutures> operatorSnapshotsInProgress, CheckpointMetaData checkpointMetaData, CheckpointMetrics checkpointMetrics, long asyncStartNanos) {
            this.owner = (StreamTask)Preconditions.checkNotNull(owner);
            this.operatorSnapshotsInProgress = (Map)Preconditions.checkNotNull(operatorSnapshotsInProgress);
            this.checkpointMetaData = (CheckpointMetaData)Preconditions.checkNotNull((Object)checkpointMetaData);
            this.checkpointMetrics = (CheckpointMetrics)Preconditions.checkNotNull((Object)checkpointMetrics);
            this.asyncStartNanos = asyncStartNanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FileSystemSafetyNet.initializeSafetyNetForThread();
            try {
                TaskStateSnapshot jobManagerTaskOperatorSubtaskStates = new TaskStateSnapshot(this.operatorSnapshotsInProgress.size());
                TaskStateSnapshot localTaskOperatorSubtaskStates = new TaskStateSnapshot(this.operatorSnapshotsInProgress.size());
                for (Map.Entry<OperatorID, OperatorSnapshotFutures> entry : this.operatorSnapshotsInProgress.entrySet()) {
                    OperatorID operatorID = entry.getKey();
                    OperatorSnapshotFutures snapshotInProgress = entry.getValue();
                    OperatorSnapshotFinalizer finalizedSnapshots = new OperatorSnapshotFinalizer(snapshotInProgress);
                    jobManagerTaskOperatorSubtaskStates.putSubtaskStateByOperatorID(operatorID, finalizedSnapshots.getJobManagerOwnedState());
                    localTaskOperatorSubtaskStates.putSubtaskStateByOperatorID(operatorID, finalizedSnapshots.getTaskLocalState());
                }
                long asyncEndNanos = System.nanoTime();
                long asyncDurationMillis = (asyncEndNanos - this.asyncStartNanos) / 1000000L;
                this.checkpointMetrics.setAsyncDurationMillis(asyncDurationMillis);
                if (this.asyncCheckpointState.compareAndSet(CheckpointingOperation.AsyncCheckpointState.RUNNING, CheckpointingOperation.AsyncCheckpointState.COMPLETED)) {
                    this.reportCompletedSnapshotStates(jobManagerTaskOperatorSubtaskStates, localTaskOperatorSubtaskStates, asyncDurationMillis);
                } else {
                    LOG.debug("{} - asynchronous part of checkpoint {} could not be completed because it was closed before.", (Object)this.owner.getName(), (Object)this.checkpointMetaData.getCheckpointId());
                }
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} - asynchronous part of checkpoint {} could not be completed.", new Object[]{this.owner.getName(), this.checkpointMetaData.getCheckpointId(), e});
                }
                this.handleExecutionException(e);
            }
            finally {
                ((StreamTask)this.owner).cancelables.unregisterCloseable((Closeable)this);
                FileSystemSafetyNet.closeSafetyNetAndGuardedResourcesForThread();
            }
        }

        private void reportCompletedSnapshotStates(TaskStateSnapshot acknowledgedTaskStateSnapshot, TaskStateSnapshot localTaskStateSnapshot, long asyncDurationMillis) {
            TaskStateManager taskStateManager = this.owner.getEnvironment().getTaskStateManager();
            boolean hasAckState = acknowledgedTaskStateSnapshot.hasState();
            boolean hasLocalState = localTaskStateSnapshot.hasState();
            Preconditions.checkState((hasAckState || !hasLocalState ? 1 : 0) != 0, (Object)"Found cached state but no corresponding primary state is reported to the job manager. This indicates a problem.");
            taskStateManager.reportTaskStateSnapshots(this.checkpointMetaData, this.checkpointMetrics, (TaskStateSnapshot)(hasAckState ? acknowledgedTaskStateSnapshot : null), (TaskStateSnapshot)(hasLocalState ? localTaskStateSnapshot : null));
            LOG.debug("{} - finished asynchronous part of checkpoint {}. Asynchronous duration: {} ms", new Object[]{this.owner.getName(), this.checkpointMetaData.getCheckpointId(), asyncDurationMillis});
            LOG.trace("{} - reported the following states in snapshot for checkpoint {}: {}.", new Object[]{this.owner.getName(), this.checkpointMetaData.getCheckpointId(), acknowledgedTaskStateSnapshot});
        }

        private void handleExecutionException(Exception e) {
            boolean didCleanup = false;
            CheckpointingOperation.AsyncCheckpointState currentState = this.asyncCheckpointState.get();
            while (CheckpointingOperation.AsyncCheckpointState.DISCARDED != currentState) {
                if (this.asyncCheckpointState.compareAndSet(currentState, CheckpointingOperation.AsyncCheckpointState.DISCARDED)) {
                    didCleanup = true;
                    try {
                        this.cleanup();
                    }
                    catch (Exception cleanupException) {
                        e.addSuppressed(cleanupException);
                    }
                    Exception checkpointException = new Exception("Could not materialize checkpoint " + this.checkpointMetaData.getCheckpointId() + " for operator " + this.owner.getName() + '.', e);
                    try {
                        this.owner.getEnvironment().declineCheckpoint(this.checkpointMetaData.getCheckpointId(), (Throwable)checkpointException);
                    }
                    catch (Exception unhandled) {
                        AsynchronousException asyncException = new AsynchronousException(unhandled);
                        this.owner.handleAsyncException("Failure in asynchronous checkpoint materialization", asyncException);
                    }
                    currentState = CheckpointingOperation.AsyncCheckpointState.DISCARDED;
                    continue;
                }
                currentState = this.asyncCheckpointState.get();
            }
            if (!didCleanup) {
                LOG.trace("Caught followup exception from a failed checkpoint thread. This can be ignored.", (Throwable)e);
            }
        }

        @Override
        public void close() {
            if (this.asyncCheckpointState.compareAndSet(CheckpointingOperation.AsyncCheckpointState.RUNNING, CheckpointingOperation.AsyncCheckpointState.DISCARDED)) {
                try {
                    this.cleanup();
                }
                catch (Exception cleanupException) {
                    LOG.warn("Could not properly clean up the async checkpoint runnable.", (Throwable)cleanupException);
                }
            } else {
                this.logFailedCleanupAttempt();
            }
        }

        private void cleanup() throws Exception {
            LOG.debug("Cleanup AsyncCheckpointRunnable for checkpoint {} of {}.", (Object)this.checkpointMetaData.getCheckpointId(), (Object)this.owner.getName());
            Exception exception = null;
            for (OperatorSnapshotFutures operatorSnapshotResult : this.operatorSnapshotsInProgress.values()) {
                if (operatorSnapshotResult == null) continue;
                try {
                    operatorSnapshotResult.cancel();
                }
                catch (Exception cancelException) {
                    exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)cancelException, exception);
                }
            }
            if (null != exception) {
                throw exception;
            }
        }

        private void logFailedCleanupAttempt() {
            LOG.debug("{} - asynchronous checkpointing operation for checkpoint {} has already been completed. Thus, the state handles are not cleaned up.", (Object)this.owner.getName(), (Object)this.checkpointMetaData.getCheckpointId());
        }
    }

    static class StreamTaskAsyncExceptionHandler {
        private final Environment environment;

        StreamTaskAsyncExceptionHandler(Environment environment) {
            this.environment = environment;
        }

        void handleAsyncException(String message, Throwable exception) {
            this.environment.failExternally((Throwable)new AsynchronousException(message, exception));
        }
    }
}

