/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.io.IOException;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.streaming.api.operators.InputSelectable;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.io.CheckpointedInputGate;
import org.apache.flink.streaming.runtime.io.InputGateUtil;
import org.apache.flink.streaming.runtime.io.InputProcessorUtil;
import org.apache.flink.streaming.runtime.io.StreamTwoInputProcessor;
import org.apache.flink.streaming.runtime.io.TwoInputSelectionHandler;
import org.apache.flink.streaming.runtime.tasks.AbstractTwoInputStreamTask;
import org.apache.flink.util.Preconditions;

@Internal
public class TwoInputStreamTask<IN1, IN2, OUT>
extends AbstractTwoInputStreamTask<IN1, IN2, OUT> {
    public TwoInputStreamTask(Environment env) {
        super(env);
    }

    @Override
    protected void createInputProcessor(Collection<InputGate> inputGates1, Collection<InputGate> inputGates2, TypeSerializer<IN1> inputDeserializer1, TypeSerializer<IN2> inputDeserializer2) throws IOException {
        TwoInputSelectionHandler twoInputSelectionHandler = new TwoInputSelectionHandler(this.headOperator instanceof InputSelectable ? (InputSelectable)((Object)this.headOperator) : null);
        InputGate unionedInputGate1 = InputGateUtil.createInputGate(inputGates1.toArray(new InputGate[0]));
        InputGate unionedInputGate2 = InputGateUtil.createInputGate(inputGates2.toArray(new InputGate[0]));
        CheckpointedInputGate[] checkpointedInputGates = InputProcessorUtil.createCheckpointedInputGatePair(this, this.getConfiguration().getCheckpointMode(), this.getEnvironment().getIOManager(), unionedInputGate1, unionedInputGate2, this.getEnvironment().getTaskManagerInfo().getConfiguration(), this.getEnvironment().getMetricGroup().getIOMetricGroup(), this.getTaskNameWithSubtaskAndId());
        Preconditions.checkState((checkpointedInputGates.length == 2 ? 1 : 0) != 0);
        this.inputProcessor = new StreamTwoInputProcessor<IN1, IN2>(checkpointedInputGates, inputDeserializer1, inputDeserializer2, this.getCheckpointLock(), this.getEnvironment().getIOManager(), this.getStreamStatusMaintainer(), (TwoInputStreamOperator)this.headOperator, twoInputSelectionHandler, this.input1WatermarkGauge, this.input2WatermarkGauge, this.operatorChain, this.setupNumRecordsInCounter(this.headOperator));
    }
}

