/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher.runner;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.dispatcher.Dispatcher;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.dispatcher.runner.AbstractDispatcherLeaderProcess;

class DefaultDispatcherGatewayService
implements AbstractDispatcherLeaderProcess.DispatcherGatewayService {
    private final Dispatcher dispatcher;
    private final DispatcherGateway dispatcherGateway;

    private DefaultDispatcherGatewayService(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.dispatcherGateway = dispatcher.getSelfGateway(DispatcherGateway.class);
    }

    @Override
    public DispatcherGateway getGateway() {
        return this.dispatcherGateway;
    }

    @Override
    public CompletableFuture<Void> onRemovedJobGraph(JobID jobId) {
        return this.dispatcher.onRemovedJobGraph(jobId);
    }

    @Override
    public CompletableFuture<ApplicationStatus> getShutDownFuture() {
        return this.dispatcher.getShutDownFuture();
    }

    public CompletableFuture<Void> closeAsync() {
        return this.dispatcher.closeAsync();
    }

    public static DefaultDispatcherGatewayService from(Dispatcher dispatcher) {
        return new DefaultDispatcherGatewayService(dispatcher);
    }
}

