/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.reader;

import java.io.IOException;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.runtime.io.network.api.reader.AbstractReader;
import org.apache.flink.runtime.io.network.api.reader.ReaderBase;
import org.apache.flink.runtime.io.network.api.serialization.RecordDeserializer;
import org.apache.flink.runtime.io.network.api.serialization.SpillingAdaptiveSpanningRecordDeserializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.partition.consumer.BufferOrEvent;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;

abstract class AbstractRecordReader<T extends IOReadableWritable>
extends AbstractReader
implements ReaderBase {
    private final RecordDeserializer<T>[] recordDeserializers;
    private RecordDeserializer<T> currentRecordDeserializer;
    private boolean isFinished;

    protected AbstractRecordReader(InputGate inputGate, String[] tmpDirectories) {
        super(inputGate);
        this.recordDeserializers = new SpillingAdaptiveSpanningRecordDeserializer[inputGate.getNumberOfInputChannels()];
        for (int i = 0; i < this.recordDeserializers.length; ++i) {
            this.recordDeserializers[i] = new SpillingAdaptiveSpanningRecordDeserializer(tmpDirectories);
        }
    }

    protected boolean getNextRecord(T target) throws IOException, InterruptedException {
        if (this.isFinished) {
            return false;
        }
        while (true) {
            BufferOrEvent bufferOrEvent;
            if (this.currentRecordDeserializer != null) {
                RecordDeserializer.DeserializationResult result = this.currentRecordDeserializer.getNextRecord(target);
                if (result.isBufferConsumed()) {
                    Buffer currentBuffer = this.currentRecordDeserializer.getCurrentBuffer();
                    currentBuffer.recycleBuffer();
                    this.currentRecordDeserializer = null;
                }
                if (result.isFullRecord()) {
                    return true;
                }
            }
            if ((bufferOrEvent = this.inputGate.getNext().orElseThrow(IllegalStateException::new)).isBuffer()) {
                this.currentRecordDeserializer = this.recordDeserializers[bufferOrEvent.getChannelIndex()];
                this.currentRecordDeserializer.setNextBuffer(bufferOrEvent.getBuffer());
                continue;
            }
            if (this.recordDeserializers[bufferOrEvent.getChannelIndex()].hasUnfinishedData()) {
                throw new IOException("Received an event in channel " + bufferOrEvent.getChannelIndex() + " while still having data from a record. This indicates broken serialization logic. If you are using custom serialization code (Writable or Value types), check their serialization routines. In the case of Kryo, check the respective Kryo serializer.");
            }
            if (!this.handleEvent(bufferOrEvent.getEvent())) continue;
            if (this.inputGate.isFinished()) {
                this.isFinished = true;
                return false;
            }
            if (this.hasReachedEndOfSuperstep()) break;
        }
        return false;
    }

    public void clearBuffers() {
        for (RecordDeserializer<T> deserializer : this.recordDeserializers) {
            Buffer buffer = deserializer.getCurrentBuffer();
            if (buffer != null && !buffer.isRecycled()) {
                buffer.recycleBuffer();
            }
            deserializer.clear();
        }
    }
}

