/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.runtime.io.AvailabilityProvider;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferListener;
import org.apache.flink.runtime.io.network.buffer.BufferPool;
import org.apache.flink.runtime.io.network.buffer.BufferPoolOwner;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalBufferPool
implements BufferPool {
    private static final Logger LOG = LoggerFactory.getLogger(LocalBufferPool.class);
    private final NetworkBufferPool networkBufferPool;
    private final int numberOfRequiredMemorySegments;
    private final ArrayDeque<MemorySegment> availableMemorySegments = new ArrayDeque();
    private final ArrayDeque<BufferListener> registeredListeners = new ArrayDeque();
    private final int maxNumberOfMemorySegments;
    private int currentPoolSize;
    private int numberOfRequestedMemorySegments;
    private boolean isDestroyed;
    @Nullable
    private final BufferPoolOwner bufferPoolOwner;
    private final AvailabilityProvider.AvailabilityHelper availabilityHelper = new AvailabilityProvider.AvailabilityHelper();

    LocalBufferPool(NetworkBufferPool networkBufferPool, int numberOfRequiredMemorySegments) {
        this(networkBufferPool, numberOfRequiredMemorySegments, Integer.MAX_VALUE, null);
    }

    LocalBufferPool(NetworkBufferPool networkBufferPool, int numberOfRequiredMemorySegments, int maxNumberOfMemorySegments) {
        this(networkBufferPool, numberOfRequiredMemorySegments, maxNumberOfMemorySegments, null);
    }

    LocalBufferPool(NetworkBufferPool networkBufferPool, int numberOfRequiredMemorySegments, int maxNumberOfMemorySegments, @Nullable BufferPoolOwner bufferPoolOwner) {
        Preconditions.checkArgument((maxNumberOfMemorySegments >= numberOfRequiredMemorySegments ? 1 : 0) != 0, (String)"Maximum number of memory segments (%s) should not be smaller than minimum (%s).", (Object[])new Object[]{maxNumberOfMemorySegments, numberOfRequiredMemorySegments});
        Preconditions.checkArgument((maxNumberOfMemorySegments > 0 ? 1 : 0) != 0, (String)"Maximum number of memory segments (%s) should be larger than 0.", (Object[])new Object[]{maxNumberOfMemorySegments});
        LOG.debug("Using a local buffer pool with {}-{} buffers", (Object)numberOfRequiredMemorySegments, (Object)maxNumberOfMemorySegments);
        this.networkBufferPool = networkBufferPool;
        this.numberOfRequiredMemorySegments = numberOfRequiredMemorySegments;
        this.currentPoolSize = numberOfRequiredMemorySegments;
        this.maxNumberOfMemorySegments = maxNumberOfMemorySegments;
        this.bufferPoolOwner = bufferPoolOwner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDestroyed() {
        ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
        synchronized (arrayDeque) {
            return this.isDestroyed;
        }
    }

    @Override
    public int getNumberOfRequiredMemorySegments() {
        return this.numberOfRequiredMemorySegments;
    }

    @Override
    public int getMaxNumberOfMemorySegments() {
        return this.maxNumberOfMemorySegments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfAvailableMemorySegments() {
        ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
        synchronized (arrayDeque) {
            return this.availableMemorySegments.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumBuffers() {
        ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
        synchronized (arrayDeque) {
            return this.currentPoolSize;
        }
    }

    @Override
    public int bestEffortGetNumOfUsedBuffers() {
        return Math.max(0, this.numberOfRequestedMemorySegments - this.availableMemorySegments.size());
    }

    @Override
    public Buffer requestBuffer() throws IOException {
        return this.toBuffer(this.requestMemorySegment());
    }

    @Override
    public BufferBuilder requestBufferBuilderBlocking() throws IOException, InterruptedException {
        return this.toBufferBuilder(this.requestMemorySegmentBlocking());
    }

    private Buffer toBuffer(MemorySegment memorySegment) {
        if (memorySegment == null) {
            return null;
        }
        return new NetworkBuffer(memorySegment, this);
    }

    private BufferBuilder toBufferBuilder(MemorySegment memorySegment) {
        if (memorySegment == null) {
            return null;
        }
        return new BufferBuilder(memorySegment, this);
    }

    private MemorySegment requestMemorySegmentBlocking() throws InterruptedException, IOException {
        MemorySegment segment;
        while ((segment = this.requestMemorySegment()) == null) {
            try {
                this.getAvailableFuture().get();
            }
            catch (ExecutionException e) {
                LOG.error("The available future is completed exceptionally.", (Throwable)e);
                ExceptionUtils.rethrow((Throwable)e);
            }
        }
        return segment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private MemorySegment requestMemorySegment() throws IOException {
        MemorySegment segment = null;
        ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
        synchronized (arrayDeque) {
            this.returnExcessMemorySegments();
            if (this.availableMemorySegments.isEmpty()) {
                segment = this.requestMemorySegmentFromGlobal();
            }
            if (segment == null) {
                segment = this.availableMemorySegments.poll();
            }
            if (segment == null) {
                this.availabilityHelper.resetUnavailable();
            }
        }
        return segment;
    }

    @Nullable
    private MemorySegment requestMemorySegmentFromGlobal() throws IOException {
        MemorySegment segment;
        assert (Thread.holdsLock(this.availableMemorySegments));
        if (this.isDestroyed) {
            throw new IllegalStateException("Buffer pool is destroyed.");
        }
        if (this.numberOfRequestedMemorySegments < this.currentPoolSize && (segment = this.networkBufferPool.requestMemorySegment()) != null) {
            ++this.numberOfRequestedMemorySegments;
            return segment;
        }
        if (this.bufferPoolOwner != null) {
            this.bufferPoolOwner.releaseMemory(1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle(MemorySegment segment) {
        CompletableFuture<?> toNotify = null;
        BufferListener.NotificationResult notificationResult = BufferListener.NotificationResult.BUFFER_NOT_USED;
        while (!notificationResult.isBufferUsed()) {
            BufferListener listener;
            ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
            synchronized (arrayDeque) {
                if (this.isDestroyed || this.numberOfRequestedMemorySegments > this.currentPoolSize) {
                    this.returnMemorySegment(segment);
                    return;
                }
                listener = this.registeredListeners.poll();
                if (listener == null) {
                    boolean wasUnavailable = this.availableMemorySegments.isEmpty();
                    this.availableMemorySegments.add(segment);
                    if (wasUnavailable) {
                        toNotify = this.availabilityHelper.getUnavailableToResetAvailable();
                    }
                    break;
                }
            }
            notificationResult = this.fireBufferAvailableNotification(listener, segment);
        }
        this.mayNotifyAvailable(toNotify);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferListener.NotificationResult fireBufferAvailableNotification(BufferListener listener, MemorySegment segment) {
        BufferListener.NotificationResult notificationResult = listener.notifyBufferAvailable(new NetworkBuffer(segment, this));
        if (notificationResult.needsMoreBuffers()) {
            ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
            synchronized (arrayDeque) {
                if (this.isDestroyed) {
                    listener.notifyBufferDestroyed();
                } else {
                    this.registeredListeners.add(listener);
                }
            }
        }
        return notificationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lazyDestroy() {
        CompletableFuture<?> toNotify = null;
        ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
        synchronized (arrayDeque) {
            if (!this.isDestroyed) {
                BufferListener listener;
                MemorySegment segment;
                while ((segment = this.availableMemorySegments.poll()) != null) {
                    this.returnMemorySegment(segment);
                }
                while ((listener = this.registeredListeners.poll()) != null) {
                    listener.notifyBufferDestroyed();
                }
                if (!this.isAvailable()) {
                    toNotify = this.availabilityHelper.getAvailableFuture();
                }
                this.isDestroyed = true;
            }
        }
        this.mayNotifyAvailable(toNotify);
        try {
            this.networkBufferPool.destroyBufferPool(this);
        }
        catch (IOException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addBufferListener(BufferListener listener) {
        ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
        synchronized (arrayDeque) {
            if (!this.availableMemorySegments.isEmpty() || this.isDestroyed) {
                return false;
            }
            this.registeredListeners.add(listener);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNumBuffers(int numBuffers) throws IOException {
        int numExcessBuffers;
        CompletableFuture<?> toNotify = null;
        ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
        synchronized (arrayDeque) {
            Preconditions.checkArgument((numBuffers >= this.numberOfRequiredMemorySegments ? 1 : 0) != 0, (String)"Buffer pool needs at least %s buffers, but tried to set to %s", (Object[])new Object[]{this.numberOfRequiredMemorySegments, numBuffers});
            this.currentPoolSize = numBuffers > this.maxNumberOfMemorySegments ? this.maxNumberOfMemorySegments : numBuffers;
            this.returnExcessMemorySegments();
            numExcessBuffers = this.numberOfRequestedMemorySegments - this.currentPoolSize;
            if (numExcessBuffers < 0 && this.availableMemorySegments.isEmpty() && this.networkBufferPool.isAvailable()) {
                toNotify = this.availabilityHelper.getUnavailableToResetUnavailable();
            }
        }
        this.mayNotifyAvailable(toNotify);
        if (this.bufferPoolOwner != null && numExcessBuffers > 0) {
            this.bufferPoolOwner.releaseMemory(numExcessBuffers);
        }
    }

    @Override
    public CompletableFuture<?> getAvailableFuture() {
        if (this.numberOfRequestedMemorySegments >= this.currentPoolSize) {
            return this.availabilityHelper.getAvailableFuture();
        }
        if (this.availabilityHelper.isApproximatelyAvailable() || this.networkBufferPool.isApproximatelyAvailable()) {
            return AVAILABLE;
        }
        return CompletableFuture.anyOf(this.availabilityHelper.getAvailableFuture(), this.networkBufferPool.getAvailableFuture());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ArrayDeque<MemorySegment> arrayDeque = this.availableMemorySegments;
        synchronized (arrayDeque) {
            return String.format("[size: %d, required: %d, requested: %d, available: %d, max: %d, listeners: %d, destroyed: %s]", this.currentPoolSize, this.numberOfRequiredMemorySegments, this.numberOfRequestedMemorySegments, this.availableMemorySegments.size(), this.maxNumberOfMemorySegments, this.registeredListeners.size(), this.isDestroyed);
        }
    }

    private void mayNotifyAvailable(@Nullable CompletableFuture<?> toNotify) {
        if (toNotify != null) {
            toNotify.complete(null);
        }
    }

    private void returnMemorySegment(MemorySegment segment) {
        assert (Thread.holdsLock(this.availableMemorySegments));
        --this.numberOfRequestedMemorySegments;
        this.networkBufferPool.recycle(segment);
    }

    private void returnExcessMemorySegments() {
        assert (Thread.holdsLock(this.availableMemorySegments));
        while (this.numberOfRequestedMemorySegments > this.currentPoolSize) {
            MemorySegment segment = this.availableMemorySegments.poll();
            if (segment == null) {
                return;
            }
            this.returnMemorySegment(segment);
        }
    }
}

