/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobgraph.tasks;

import java.util.concurrent.Future;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointMetrics;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.util.Preconditions;

public abstract class AbstractInvokable {
    private final Environment environment;
    private volatile boolean shouldInterruptOnCancel = true;

    public AbstractInvokable(Environment environment) {
        this.environment = (Environment)Preconditions.checkNotNull((Object)environment);
    }

    public abstract void invoke() throws Exception;

    public void cancel() throws Exception {
    }

    public void setShouldInterruptOnCancel(boolean shouldInterruptOnCancel) {
        this.shouldInterruptOnCancel = shouldInterruptOnCancel;
    }

    public boolean shouldInterruptOnCancel() {
        return this.shouldInterruptOnCancel;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public ClassLoader getUserCodeClassLoader() {
        return this.getEnvironment().getUserClassLoader();
    }

    public int getCurrentNumberOfSubtasks() {
        return this.environment.getTaskInfo().getNumberOfParallelSubtasks();
    }

    public int getIndexInSubtaskGroup() {
        return this.environment.getTaskInfo().getIndexOfThisSubtask();
    }

    public Configuration getTaskConfiguration() {
        return this.environment.getTaskConfiguration();
    }

    public Configuration getJobConfiguration() {
        return this.environment.getJobConfiguration();
    }

    public ExecutionConfig getExecutionConfig() {
        return this.environment.getExecutionConfig();
    }

    public Future<Boolean> triggerCheckpointAsync(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, boolean advanceToEndOfEventTime) {
        throw new UnsupportedOperationException(String.format("triggerCheckpointAsync not supported by %s", this.getClass().getName()));
    }

    public void triggerCheckpointOnBarrier(CheckpointMetaData checkpointMetaData, CheckpointOptions checkpointOptions, CheckpointMetrics checkpointMetrics) throws Exception {
        throw new UnsupportedOperationException(String.format("triggerCheckpointOnBarrier not supported by %s", this.getClass().getName()));
    }

    public void abortCheckpointOnBarrier(long checkpointId, Throwable cause) throws Exception {
        throw new UnsupportedOperationException(String.format("abortCheckpointOnBarrier not supported by %s", this.getClass().getName()));
    }

    public Future<Void> notifyCheckpointCompleteAsync(long checkpointId) {
        throw new UnsupportedOperationException(String.format("notifyCheckpointCompleteAsync not supported by %s", this.getClass().getName()));
    }
}

