/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.util.MathUtils;

public class ConfigurationParserUtils {
    public static int getSlot(Configuration configuration) {
        int slots = configuration.getInteger(TaskManagerOptions.NUM_TASK_SLOTS, 1);
        if (slots == -1) {
            slots = 1;
        }
        ConfigurationParserUtils.checkConfigParameter(slots >= 1, slots, TaskManagerOptions.NUM_TASK_SLOTS.key(), "Number of task slots must be at least one.");
        return slots;
    }

    public static void checkConfigParameter(boolean condition, Object parameter, String name, String errorMessage) throws IllegalConfigurationException {
        if (!condition) {
            throw new IllegalConfigurationException("Invalid configuration value for " + name + " : " + parameter + " - " + errorMessage);
        }
    }

    public static int getPageSize(Configuration configuration) {
        int pageSize = MathUtils.checkedDownCast((long)((MemorySize)configuration.get(TaskManagerOptions.MEMORY_SEGMENT_SIZE)).getBytes());
        ConfigurationParserUtils.checkConfigParameter(pageSize >= 4096, pageSize, TaskManagerOptions.MEMORY_SEGMENT_SIZE.key(), "Minimum memory segment size is 4096");
        ConfigurationParserUtils.checkConfigParameter(MathUtils.isPowerOf2((long)pageSize), pageSize, TaskManagerOptions.MEMORY_SEGMENT_SIZE.key(), "Memory segment size must be a power of 2.");
        return pageSize;
    }
}

