/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.fs.local;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.fs.RecoverableFsDataOutputStream;
import org.apache.flink.core.fs.RecoverableWriter;
import org.apache.flink.core.fs.local.LocalFileSystem;
import org.apache.flink.core.fs.local.LocalRecoverable;
import org.apache.flink.core.fs.local.LocalRecoverableFsDataOutputStream;
import org.apache.flink.core.fs.local.LocalRecoverableSerializer;
import org.apache.flink.core.io.SimpleVersionedSerializer;
import org.apache.flink.util.Preconditions;

@Internal
public class LocalRecoverableWriter
implements RecoverableWriter {
    private final LocalFileSystem fs;

    public LocalRecoverableWriter(LocalFileSystem fs) {
        this.fs = Preconditions.checkNotNull(fs);
    }

    @Override
    public RecoverableFsDataOutputStream open(Path filePath) throws IOException {
        File targetFile = this.fs.pathToFile(filePath);
        File tempFile = LocalRecoverableWriter.generateStagingTempFilePath(targetFile);
        File parent = tempFile.getParentFile();
        if (parent != null && !parent.mkdirs() && !parent.exists()) {
            throw new IOException("Failed to create the parent directory: " + parent);
        }
        return new LocalRecoverableFsDataOutputStream(targetFile, tempFile);
    }

    @Override
    public RecoverableFsDataOutputStream recover(RecoverableWriter.ResumeRecoverable recoverable) throws IOException {
        if (recoverable instanceof LocalRecoverable) {
            return new LocalRecoverableFsDataOutputStream((LocalRecoverable)recoverable);
        }
        throw new IllegalArgumentException("LocalFileSystem cannot recover recoverable for other file system: " + recoverable);
    }

    @Override
    public boolean requiresCleanupOfRecoverableState() {
        return false;
    }

    @Override
    public boolean cleanupRecoverableState(RecoverableWriter.ResumeRecoverable resumable) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RecoverableFsDataOutputStream.Committer recoverForCommit(RecoverableWriter.CommitRecoverable recoverable) throws IOException {
        if (recoverable instanceof LocalRecoverable) {
            return new LocalRecoverableFsDataOutputStream.LocalCommitter((LocalRecoverable)recoverable);
        }
        throw new IllegalArgumentException("LocalFileSystem cannot recover recoverable for other file system: " + recoverable);
    }

    @Override
    public SimpleVersionedSerializer<RecoverableWriter.CommitRecoverable> getCommitRecoverableSerializer() {
        LocalRecoverableSerializer typedSerializer = LocalRecoverableSerializer.INSTANCE;
        return typedSerializer;
    }

    @Override
    public SimpleVersionedSerializer<RecoverableWriter.ResumeRecoverable> getResumeRecoverableSerializer() {
        LocalRecoverableSerializer typedSerializer = LocalRecoverableSerializer.INSTANCE;
        return typedSerializer;
    }

    @Override
    public boolean supportsResume() {
        return true;
    }

    @VisibleForTesting
    static File generateStagingTempFilePath(File targetFile) {
        File candidate;
        Preconditions.checkArgument(targetFile.isAbsolute(), "targetFile must be absolute");
        Preconditions.checkArgument(!targetFile.isDirectory(), "targetFile must not be a directory");
        File parent = targetFile.getParentFile();
        String name = targetFile.getName();
        Preconditions.checkArgument(parent != null, "targetFile must not be the root directory");
        while ((candidate = new File(parent, "." + name + ".inprogress." + UUID.randomUUID().toString())).exists()) {
        }
        return candidate;
    }
}

