/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.core.memory;

import java.nio.ByteBuffer;
import org.apache.flink.annotation.Internal;
import org.apache.flink.core.memory.HybridMemorySegment;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemoryUtils;

@Internal
public final class MemorySegmentFactory {
    public static MemorySegment wrap(byte[] buffer) {
        return new HybridMemorySegment(buffer, null);
    }

    public static MemorySegment allocateUnpooledSegment(int size) {
        return MemorySegmentFactory.allocateUnpooledSegment(size, null);
    }

    public static MemorySegment allocateUnpooledSegment(int size, Object owner) {
        return new HybridMemorySegment(new byte[size], owner);
    }

    public static MemorySegment allocateUnpooledOffHeapMemory(int size) {
        return MemorySegmentFactory.allocateUnpooledOffHeapMemory(size, null);
    }

    public static MemorySegment allocateUnpooledOffHeapMemory(int size, Object owner) {
        ByteBuffer memory = ByteBuffer.allocateDirect(size);
        return new HybridMemorySegment(memory, owner, null);
    }

    public static MemorySegment allocateOffHeapUnsafeMemory(int size, Object owner) {
        long address = MemoryUtils.allocateUnsafe(size);
        ByteBuffer offHeapBuffer = MemoryUtils.wrapUnsafeMemoryWithByteBuffer(address, size);
        return new HybridMemorySegment(offHeapBuffer, owner, MemoryUtils.createMemoryGcCleaner(offHeapBuffer, address));
    }

    public static MemorySegment wrapOffHeapMemory(ByteBuffer memory) {
        return new HybridMemorySegment(memory, null, null);
    }
}

