/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum JavaGcCleanerWrapper {

    private static final Logger LOG = LoggerFactory.getLogger(JavaGcCleanerWrapper.class);
    private static final Collection<CleanerProvider> CLEANER_PROVIDERS = Arrays.asList(LegacyCleanerProvider.INSTANCE, Java9CleanerProvider.INSTANCE);
    private static final CleanerFactory CLEANER_FACTORY = JavaGcCleanerWrapper.findGcCleaner();

    private static CleanerFactory findGcCleaner() {
        CleanerFactory foundCleanerFactory = null;
        Throwable t = null;
        for (CleanerProvider cleanerProvider : CLEANER_PROVIDERS) {
            try {
                foundCleanerFactory = cleanerProvider.createCleanerFactory();
                break;
            }
            catch (Throwable e) {
                t = ExceptionUtils.firstOrSuppressed(e, t);
            }
        }
        if (foundCleanerFactory == null) {
            String errorMessage = String.format("Failed to find GC Cleaner among available providers: %s", CLEANER_PROVIDERS);
            throw new Error(errorMessage, t);
        }
        return foundCleanerFactory;
    }

    public static Runnable create(Object owner, Runnable cleanOperation) {
        return CLEANER_FACTORY.create(owner, cleanOperation);
    }

    private static final class Java9CleanerFactory
    implements CleanerFactory {
        private final Object cleaner;
        private final Method cleanerRegisterMethod;
        private final Method cleanMethod;

        private Java9CleanerFactory(Object cleaner, Method cleanerRegisterMethod, Method cleanMethod) {
            this.cleaner = cleaner;
            this.cleanerRegisterMethod = cleanerRegisterMethod;
            this.cleanMethod = cleanMethod;
        }

        @Override
        public Runnable create(Object owner, Runnable cleanupOperation) {
            Object cleanable;
            try {
                cleanable = this.cleanerRegisterMethod.invoke(this.cleaner, owner, cleanupOperation);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new Error("Failed to create a Java 9 Cleaner", e);
            }
            String ownerString = owner.toString();
            return () -> {
                try {
                    this.cleanMethod.invoke(cleanable, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    String message = String.format("FATAL UNEXPECTED - Failed to invoke a Java 9 Cleaner$Cleanable for %s", ownerString);
                    LOG.error(message, (Throwable)e);
                    throw new Error(message, e);
                }
            };
        }
    }

    private static enum Java9CleanerProvider implements CleanerProvider
    {
        INSTANCE;

        private static final String JAVA9_CLEANER_CLASS_NAME = "java.lang.ref.Cleaner";

        @Override
        public CleanerFactory createCleanerFactory() {
            Class<?> cleanerClass = Java9CleanerProvider.findCleanerClass();
            Method cleanerCreateMethod = Java9CleanerProvider.getCleanerCreateMethod(cleanerClass);
            Object cleaner = Java9CleanerProvider.createCleaner(cleanerCreateMethod);
            Method cleanerRegisterMethod = Java9CleanerProvider.getCleanerRegisterMethod(cleanerClass);
            Class<?> cleanableClass = Java9CleanerProvider.findCleanableClass();
            Method cleanMethod = Java9CleanerProvider.getCleanMethod(cleanableClass);
            return new Java9CleanerFactory(cleaner, cleanerRegisterMethod, cleanMethod);
        }

        private static Class<?> findCleanerClass() {
            try {
                return Class.forName(JAVA9_CLEANER_CLASS_NAME);
            }
            catch (ClassNotFoundException e) {
                throw new FlinkRuntimeException("Failed to find Java 9 Cleaner class", e);
            }
        }

        private static Method getCleanerCreateMethod(Class<?> cleanerClass) {
            try {
                return cleanerClass.getMethod("create", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new FlinkRuntimeException("Failed to find Java 9 Cleaner#create method", e);
            }
        }

        private static Object createCleaner(Method cleanerCreateMethod) {
            try {
                return cleanerCreateMethod.invoke(null, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new FlinkRuntimeException("Failed to create a Java 9 Cleaner", e);
            }
        }

        private static Method getCleanerRegisterMethod(Class<?> cleanerClass) {
            try {
                return cleanerClass.getMethod("register", Object.class, Runnable.class);
            }
            catch (NoSuchMethodException e) {
                throw new FlinkRuntimeException("Failed to find Java 9 Cleaner#create method", e);
            }
        }

        private static Class<?> findCleanableClass() {
            try {
                return Class.forName("java.lang.ref.Cleaner$Cleanable");
            }
            catch (ClassNotFoundException e) {
                throw new FlinkRuntimeException("Failed to find Java 9 Cleaner#Cleanable class", e);
            }
        }

        private static Method getCleanMethod(Class<?> cleanableClass) {
            try {
                return cleanableClass.getMethod("clean", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new FlinkRuntimeException("Failed to find Java 9 Cleaner$Cleanable#clean method", e);
            }
        }

        public String toString() {
            return "New cleaner provider for Java 9+java.lang.ref.Cleaner";
        }
    }

    private static final class LegacyCleanerFactory
    implements CleanerFactory {
        private final Method cleanerCreateMethod;
        private final Method cleanerCleanMethod;

        private LegacyCleanerFactory(Method cleanerCreateMethod, Method cleanerCleanMethod) {
            this.cleanerCreateMethod = cleanerCreateMethod;
            this.cleanerCleanMethod = cleanerCleanMethod;
        }

        @Override
        public Runnable create(Object owner, Runnable cleanupOperation) {
            Object cleaner;
            try {
                cleaner = this.cleanerCreateMethod.invoke(null, owner, cleanupOperation);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new Error("Failed to create a Java legacy Cleaner", e);
            }
            String ownerString = owner.toString();
            return () -> {
                try {
                    this.cleanerCleanMethod.invoke(cleaner, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    String message = String.format("FATAL UNEXPECTED - Failed to invoke a Java legacy Cleaner for %s", ownerString);
                    LOG.error(message, (Throwable)e);
                    throw new Error(message, e);
                }
            };
        }
    }

    private static enum LegacyCleanerProvider implements CleanerProvider
    {
        INSTANCE;

        private static final String LEGACY_CLEANER_CLASS_NAME = "sun.misc.Cleaner";

        @Override
        public CleanerFactory createCleanerFactory() {
            Class<?> cleanerClass = LegacyCleanerProvider.findCleanerClass();
            Method cleanerCreateMethod = LegacyCleanerProvider.getCleanerCreateMethod(cleanerClass);
            Method cleanerCleanMethod = LegacyCleanerProvider.getCleanerCleanMethod(cleanerClass);
            return new LegacyCleanerFactory(cleanerCreateMethod, cleanerCleanMethod);
        }

        private static Class<?> findCleanerClass() {
            try {
                return Class.forName(LEGACY_CLEANER_CLASS_NAME);
            }
            catch (ClassNotFoundException e) {
                throw new FlinkRuntimeException("Failed to find Java legacy Cleaner class", e);
            }
        }

        private static Method getCleanerCreateMethod(Class<?> cleanerClass) {
            try {
                return cleanerClass.getMethod("create", Object.class, Runnable.class);
            }
            catch (NoSuchMethodException e) {
                throw new FlinkRuntimeException("Failed to find Java legacy Cleaner#create method", e);
            }
        }

        private static Method getCleanerCleanMethod(Class<?> cleanerClass) {
            try {
                return cleanerClass.getMethod("clean", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new FlinkRuntimeException("Failed to find Java legacy Cleaner#clean method", e);
            }
        }

        public String toString() {
            return "Legacy cleaner provider before Java 9 using sun.misc.Cleaner";
        }
    }

    @FunctionalInterface
    private static interface CleanerFactory {
        public Runnable create(Object var1, Runnable var2);
    }

    @FunctionalInterface
    private static interface CleanerProvider {
        public CleanerFactory createCleanerFactory() throws ClassNotFoundException;
    }
}

