/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.runtime.executiongraph.failover.flip1.partitionrelease.PipelinedRegion;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.SchedulingExecutionVertex;
import org.apache.flink.runtime.topology.Result;
import org.apache.flink.runtime.topology.Topology;
import org.apache.flink.runtime.topology.Vertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelinedRegionComputeUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PipelinedRegionComputeUtil.class);

    public static Set<PipelinedRegion> toPipelinedRegionsSet(Set<? extends Set<? extends SchedulingExecutionVertex<?, ?>>> distinctRegions) {
        return distinctRegions.stream().map(PipelinedRegionComputeUtil.toExecutionVertexIdSet()).map(PipelinedRegion::from).collect(Collectors.toSet());
    }

    private static Function<Set<? extends SchedulingExecutionVertex<?, ?>>, Set<ExecutionVertexID>> toExecutionVertexIdSet() {
        return failoverVertices -> failoverVertices.stream().map(Vertex::getId).collect(Collectors.toSet());
    }

    public static <V extends Vertex<?, ?, V, R>, R extends Result<?, ?, V, R>> Set<Set<V>> computePipelinedRegions(Topology<?, ?, V, R> topology) {
        if (topology.containsCoLocationConstraints()) {
            return PipelinedRegionComputeUtil.uniqueRegions(PipelinedRegionComputeUtil.buildOneRegionForAllVertices(topology));
        }
        IdentityHashMap vertexToRegion = new IdentityHashMap();
        for (Vertex vertex : topology.getVertices()) {
            HashSet currentRegion = new HashSet(1);
            currentRegion.add(vertex);
            vertexToRegion.put(vertex, currentRegion);
            for (Result consumedResult : vertex.getConsumedResults()) {
                HashSet largerSet;
                HashSet smallerSet;
                if (!consumedResult.getResultType().isPipelined()) continue;
                Object producerVertex = consumedResult.getProducer();
                HashSet producerRegion = (HashSet)vertexToRegion.get(producerVertex);
                if (producerRegion == null) {
                    throw new IllegalStateException("Producer task " + producerVertex.getId() + " failover region is null while calculating failover region for the consumer task " + vertex.getId() + ". This should be a failover region building bug.");
                }
                if (currentRegion == producerRegion) continue;
                if (currentRegion.size() < producerRegion.size()) {
                    smallerSet = currentRegion;
                    largerSet = producerRegion;
                } else {
                    smallerSet = producerRegion;
                    largerSet = currentRegion;
                }
                for (Vertex v : smallerSet) {
                    vertexToRegion.put(v, largerSet);
                }
                largerSet.addAll(smallerSet);
                currentRegion = largerSet;
            }
        }
        return PipelinedRegionComputeUtil.uniqueRegions(vertexToRegion);
    }

    private static <V extends Vertex<?, ?, V, ?>> Map<V, Set<V>> buildOneRegionForAllVertices(Topology<?, ?, V, ?> topology) {
        LOG.warn("Cannot decompose the topology into individual failover regions due to use of Co-Location constraints (iterations). Job will fail over as one holistic unit.");
        IdentityHashMap vertexToRegion = new IdentityHashMap();
        HashSet<Vertex> allVertices = new HashSet<Vertex>();
        for (Vertex vertex : topology.getVertices()) {
            allVertices.add(vertex);
            vertexToRegion.put(vertex, allVertices);
        }
        return vertexToRegion;
    }

    private static <V extends Vertex<?, ?, V, ?>> Set<Set<V>> uniqueRegions(Map<V, Set<V>> vertexToRegion) {
        Set<Set<V>> distinctRegions = Collections.newSetFromMap(new IdentityHashMap());
        distinctRegions.addAll(vertexToRegion.values());
        return distinctRegions;
    }

    private PipelinedRegionComputeUtil() {
    }
}

