/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.annotation.Internal;

@Internal
public interface AvailabilityProvider {
    public static final CompletableFuture<?> AVAILABLE = CompletableFuture.completedFuture(null);

    public CompletableFuture<?> getAvailableFuture();

    default public boolean isAvailable() {
        CompletableFuture<?> future = this.getAvailableFuture();
        return future == AVAILABLE || future.isDone();
    }

    default public boolean isApproximatelyAvailable() {
        return this.getAvailableFuture() == AVAILABLE;
    }

    public static final class AvailabilityHelper
    implements AvailabilityProvider {
        private CompletableFuture<?> availableFuture = new CompletableFuture();

        public void resetUnavailable() {
            if (this.isAvailable()) {
                this.availableFuture = new CompletableFuture();
            }
        }

        public void resetAvailable() {
            this.availableFuture = AVAILABLE;
        }

        public CompletableFuture<?> getUnavailableToResetAvailable() {
            CompletableFuture<?> toNotify = this.availableFuture;
            this.availableFuture = AVAILABLE;
            return toNotify;
        }

        public CompletableFuture<?> getUnavailableToResetUnavailable() {
            CompletableFuture<?> toNotify = this.availableFuture;
            this.availableFuture = new CompletableFuture();
            return toNotify;
        }

        @Override
        public CompletableFuture<?> getAvailableFuture() {
            return this.availableFuture;
        }
    }
}

