/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import javax.annotation.Nonnull;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.akka.AkkaUtils;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolFactory;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolImpl;
import org.apache.flink.runtime.util.clock.Clock;
import org.apache.flink.runtime.util.clock.SystemClock;

public class DefaultSlotPoolFactory
implements SlotPoolFactory {
    @Nonnull
    private final Clock clock;
    @Nonnull
    private final Time rpcTimeout;
    @Nonnull
    private final Time slotIdleTimeout;
    @Nonnull
    private final Time batchSlotTimeout;

    public DefaultSlotPoolFactory(@Nonnull Clock clock, @Nonnull Time rpcTimeout, @Nonnull Time slotIdleTimeout, @Nonnull Time batchSlotTimeout) {
        this.clock = clock;
        this.rpcTimeout = rpcTimeout;
        this.slotIdleTimeout = slotIdleTimeout;
        this.batchSlotTimeout = batchSlotTimeout;
    }

    @Override
    @Nonnull
    public SlotPool createSlotPool(@Nonnull JobID jobId) {
        return new SlotPoolImpl(jobId, this.clock, this.rpcTimeout, this.slotIdleTimeout, this.batchSlotTimeout);
    }

    public static DefaultSlotPoolFactory fromConfiguration(@Nonnull Configuration configuration) {
        Time rpcTimeout = AkkaUtils.getTimeoutAsTime(configuration);
        Time slotIdleTimeout = Time.milliseconds((long)configuration.getLong(JobManagerOptions.SLOT_IDLE_TIMEOUT));
        Time batchSlotTimeout = Time.milliseconds((long)configuration.getLong(JobManagerOptions.SLOT_REQUEST_TIMEOUT));
        return new DefaultSlotPoolFactory(SystemClock.getInstance(), rpcTimeout, slotIdleTimeout, batchSlotTimeout);
    }
}

