/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.groups;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.apache.flink.runtime.metrics.groups.ComponentMetricGroup;
import org.apache.flink.runtime.metrics.groups.OperatorMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskIOMetricGroup;
import org.apache.flink.runtime.metrics.groups.TaskManagerJobMetricGroup;
import org.apache.flink.runtime.metrics.scope.ScopeFormat;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

@Internal
public class TaskMetricGroup
extends ComponentMetricGroup<TaskManagerJobMetricGroup> {
    private final Map<String, OperatorMetricGroup> operators = new HashMap<String, OperatorMetricGroup>();
    static final int METRICS_OPERATOR_NAME_MAX_LENGTH = 80;
    private final TaskIOMetricGroup ioMetrics;
    private final AbstractID executionId;
    @Nullable
    protected final JobVertexID vertexId;
    @Nullable
    private final String taskName;
    protected final int subtaskIndex;
    private final int attemptNumber;

    public TaskMetricGroup(MetricRegistry registry, TaskManagerJobMetricGroup parent, @Nullable JobVertexID vertexId, AbstractID executionId, @Nullable String taskName, int subtaskIndex, int attemptNumber) {
        super(registry, registry.getScopeFormats().getTaskFormat().formatScope((TaskManagerJobMetricGroup)Preconditions.checkNotNull((Object)parent), vertexId, (AbstractID)Preconditions.checkNotNull((Object)executionId), taskName, subtaskIndex, attemptNumber), parent);
        this.executionId = (AbstractID)Preconditions.checkNotNull((Object)executionId);
        this.vertexId = vertexId;
        this.taskName = taskName;
        this.subtaskIndex = subtaskIndex;
        this.attemptNumber = attemptNumber;
        this.ioMetrics = new TaskIOMetricGroup(this);
    }

    public final TaskManagerJobMetricGroup parent() {
        return (TaskManagerJobMetricGroup)this.parent;
    }

    public AbstractID executionId() {
        return this.executionId;
    }

    @Nullable
    public AbstractID vertexId() {
        return this.vertexId;
    }

    @Nullable
    public String taskName() {
        return this.taskName;
    }

    public int subtaskIndex() {
        return this.subtaskIndex;
    }

    public int attemptNumber() {
        return this.attemptNumber;
    }

    public TaskIOMetricGroup getIOMetricGroup() {
        return this.ioMetrics;
    }

    @Override
    protected QueryScopeInfo.TaskQueryScopeInfo createQueryServiceMetricInfo(CharacterFilter filter) {
        return new QueryScopeInfo.TaskQueryScopeInfo(((TaskManagerJobMetricGroup)this.parent).jobId.toString(), String.valueOf(this.vertexId), this.subtaskIndex);
    }

    public OperatorMetricGroup getOrAddOperator(String name) {
        return this.getOrAddOperator(OperatorID.fromJobVertexID(this.vertexId), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperatorMetricGroup getOrAddOperator(OperatorID operatorID, String name) {
        String metricName;
        if (name != null && name.length() > 80) {
            LOG.warn("The operator name {} exceeded the {} characters length limit and was truncated.", (Object)name, (Object)80);
            metricName = name.substring(0, 80);
        } else {
            metricName = name;
        }
        String key = (Object)((Object)operatorID) + metricName;
        TaskMetricGroup taskMetricGroup = this;
        synchronized (taskMetricGroup) {
            return this.operators.computeIfAbsent(key, operator -> new OperatorMetricGroup(this.registry, this, operatorID, metricName));
        }
    }

    @Override
    public void close() {
        super.close();
        ((TaskManagerJobMetricGroup)this.parent).removeTaskMetricGroup(this.executionId);
    }

    @Override
    protected void putVariables(Map<String, String> variables) {
        variables.put(ScopeFormat.SCOPE_TASK_VERTEX_ID, this.vertexId.toString());
        variables.put(ScopeFormat.SCOPE_TASK_NAME, this.taskName);
        variables.put(ScopeFormat.SCOPE_TASK_ATTEMPT_ID, this.executionId.toString());
        variables.put(ScopeFormat.SCOPE_TASK_ATTEMPT_NUM, String.valueOf(this.attemptNumber));
        variables.put(ScopeFormat.SCOPE_TASK_SUBTASK_INDEX, String.valueOf(this.subtaskIndex));
    }

    @Override
    protected Iterable<? extends ComponentMetricGroup> subComponents() {
        return this.operators.values();
    }

    @Override
    protected String getGroupName(CharacterFilter filter) {
        return "task";
    }
}

