/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.shuffle;

import java.net.InetAddress;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.io.network.TaskEventPublisher;
import org.apache.flink.util.Preconditions;

public class ShuffleEnvironmentContext {
    private final Configuration configuration;
    private final ResourceID taskExecutorResourceId;
    private final MemorySize networkMemorySize;
    private final boolean localCommunicationOnly;
    private final InetAddress hostAddress;
    private final TaskEventPublisher eventPublisher;
    private final MetricGroup parentMetricGroup;

    public ShuffleEnvironmentContext(Configuration configuration, ResourceID taskExecutorResourceId, MemorySize networkMemorySize, boolean localCommunicationOnly, InetAddress hostAddress, TaskEventPublisher eventPublisher, MetricGroup parentMetricGroup) {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.taskExecutorResourceId = (ResourceID)Preconditions.checkNotNull((Object)taskExecutorResourceId);
        this.networkMemorySize = networkMemorySize;
        this.localCommunicationOnly = localCommunicationOnly;
        this.hostAddress = (InetAddress)Preconditions.checkNotNull((Object)hostAddress);
        this.eventPublisher = (TaskEventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.parentMetricGroup = (MetricGroup)Preconditions.checkNotNull((Object)parentMetricGroup);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public ResourceID getTaskExecutorResourceId() {
        return this.taskExecutorResourceId;
    }

    public MemorySize getNetworkMemorySize() {
        return this.networkMemorySize;
    }

    public boolean isLocalCommunicationOnly() {
        return this.localCommunicationOnly;
    }

    public InetAddress getHostAddress() {
        return this.hostAddress;
    }

    public TaskEventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    public MetricGroup getParentMetricGroup() {
        return this.parentMetricGroup;
    }
}

