/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import javax.annotation.Nonnull;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.runtime.state.SnapshotStrategy;
import org.apache.flink.runtime.state.StateObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSnapshotStrategy<T extends StateObject>
implements SnapshotStrategy<SnapshotResult<T>> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSnapshotStrategy.class);
    private static final String LOG_SYNC_COMPLETED_TEMPLATE = "{} ({}, synchronous part) in thread {} took {} ms.";
    private static final String LOG_ASYNC_COMPLETED_TEMPLATE = "{} ({}, asynchronous part) in thread {} took {} ms.";
    @Nonnull
    protected final String description;

    protected AbstractSnapshotStrategy(@Nonnull String description) {
        this.description = description;
    }

    public void logSyncCompleted(@Nonnull Object checkpointOutDescription, long startTime) {
        this.logCompletedInternal(LOG_SYNC_COMPLETED_TEMPLATE, checkpointOutDescription, startTime);
    }

    public void logAsyncCompleted(@Nonnull Object checkpointOutDescription, long startTime) {
        this.logCompletedInternal(LOG_ASYNC_COMPLETED_TEMPLATE, checkpointOutDescription, startTime);
    }

    private void logCompletedInternal(@Nonnull String template, @Nonnull Object checkpointOutDescription, long startTime) {
        long duration = System.currentTimeMillis() - startTime;
        LOG.debug(template, new Object[]{this.description, checkpointOutDescription, Thread.currentThread(), duration});
    }

    public String toString() {
        return "SnapshotStrategy {" + this.description + "}";
    }
}

