/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.query.TaskKvStateRegistry;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateBackend;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.SnappyStreamCompressionDecorator;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.runtime.state.StreamCompressionDecorator;
import org.apache.flink.runtime.state.UncompressedStreamCompressionDecorator;
import org.apache.flink.runtime.state.ttl.TtlTimeProvider;

@PublicEvolving
public abstract class AbstractStateBackend
implements StateBackend,
Serializable {
    private static final long serialVersionUID = 4620415814639230247L;

    public static StreamCompressionDecorator getCompressionDecorator(ExecutionConfig executionConfig) {
        if (executionConfig != null && executionConfig.isUseSnapshotCompression()) {
            return SnappyStreamCompressionDecorator.INSTANCE;
        }
        return UncompressedStreamCompressionDecorator.INSTANCE;
    }

    @Override
    public abstract <K> AbstractKeyedStateBackend<K> createKeyedStateBackend(Environment var1, JobID var2, String var3, TypeSerializer<K> var4, int var5, KeyGroupRange var6, TaskKvStateRegistry var7, TtlTimeProvider var8, MetricGroup var9, @Nonnull Collection<KeyedStateHandle> var10, CloseableRegistry var11) throws IOException;

    @Override
    public abstract OperatorStateBackend createOperatorStateBackend(Environment var1, String var2, @Nonnull Collection<OperatorStateHandle> var3, CloseableRegistry var4) throws Exception;
}

