/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

public class NullableSerializer<T>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 3335569358214720033L;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    @Nonnull
    private final TypeSerializer<T> originalSerializer;
    private final byte[] padding;

    private NullableSerializer(@Nonnull TypeSerializer<T> originalSerializer, boolean padNullValueIfFixedLen) {
        this(originalSerializer, NullableSerializer.createPadding(originalSerializer.getLength(), padNullValueIfFixedLen));
    }

    private NullableSerializer(@Nonnull TypeSerializer<T> originalSerializer, byte[] padding) {
        this.originalSerializer = originalSerializer;
        this.padding = padding;
    }

    private static byte[] createPadding(int originalSerializerLength, boolean padNullValueIfFixedLen) {
        boolean padNullValue = originalSerializerLength > 0 && padNullValueIfFixedLen;
        return padNullValue ? new byte[originalSerializerLength] : EMPTY_BYTE_ARRAY;
    }

    public static <T> TypeSerializer<T> wrapIfNullIsNotSupported(@Nonnull TypeSerializer<T> originalSerializer, boolean padNullValueIfFixedLen) {
        return NullableSerializer.checkIfNullSupported(originalSerializer) ? originalSerializer : NullableSerializer.wrap(originalSerializer, padNullValueIfFixedLen);
    }

    public static <T> boolean checkIfNullSupported(@Nonnull TypeSerializer<T> serializer) {
        int length = serializer.getLength() > 0 ? serializer.getLength() : 1;
        DataOutputSerializer dos = new DataOutputSerializer(length);
        try {
            serializer.serialize(null, dos);
        }
        catch (IOException | RuntimeException e) {
            return false;
        }
        Preconditions.checkArgument(serializer.getLength() < 0 || serializer.getLength() == dos.getCopyOfBuffer().length, "The serialized form of the null value should have the same length as any other if the length is fixed in the serializer");
        DataInputDeserializer dis = new DataInputDeserializer(dos.getSharedBuffer());
        try {
            Preconditions.checkArgument(serializer.deserialize(dis) == null);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Unexpected failure to deserialize just serialized null value with %s", serializer.getClass().getName()), e);
        }
        Preconditions.checkArgument(serializer.copy(null) == null, "Serializer %s has to be able properly copy null value if it can serialize it", serializer.getClass().getName());
        return true;
    }

    private boolean padNullValue() {
        return this.padding.length > 0;
    }

    private int nullPaddingLength() {
        return this.padding.length;
    }

    private TypeSerializer<T> originalSerializer() {
        return this.originalSerializer;
    }

    public static <T> TypeSerializer<T> wrap(@Nonnull TypeSerializer<T> originalSerializer, boolean padNullValueIfFixedLen) {
        return originalSerializer instanceof NullableSerializer ? originalSerializer : new NullableSerializer<T>(originalSerializer, padNullValueIfFixedLen);
    }

    @Override
    public boolean isImmutableType() {
        return this.originalSerializer.isImmutableType();
    }

    @Override
    public TypeSerializer<T> duplicate() {
        TypeSerializer<T> duplicateOriginalSerializer = this.originalSerializer.duplicate();
        return duplicateOriginalSerializer == this.originalSerializer ? this : new NullableSerializer<T>(this.originalSerializer.duplicate(), this.padNullValue());
    }

    @Override
    public T createInstance() {
        return this.originalSerializer.createInstance();
    }

    @Override
    public T copy(T from) {
        return from == null ? null : (T)this.originalSerializer.copy(from);
    }

    @Override
    public T copy(T from, T reuse) {
        return from == null ? null : (reuse == null ? (T)this.originalSerializer.copy(from) : (T)this.originalSerializer.copy(from, reuse));
    }

    @Override
    public int getLength() {
        return this.padNullValue() ? 1 + this.padding.length : -1;
    }

    @Override
    public void serialize(T record, DataOutputView target) throws IOException {
        if (record == null) {
            target.writeBoolean(true);
            target.write(this.padding);
        } else {
            target.writeBoolean(false);
            this.originalSerializer.serialize(record, target);
        }
    }

    @Override
    public T deserialize(DataInputView source) throws IOException {
        boolean isNull = this.deserializeNull(source);
        return isNull ? null : (T)this.originalSerializer.deserialize(source);
    }

    @Override
    public T deserialize(T reuse, DataInputView source) throws IOException {
        boolean isNull = this.deserializeNull(source);
        return isNull ? null : (reuse == null ? (T)this.originalSerializer.deserialize(source) : (T)this.originalSerializer.deserialize(reuse, source));
    }

    private boolean deserializeNull(DataInputView source) throws IOException {
        boolean isNull = source.readBoolean();
        if (isNull) {
            source.skipBytesToRead(this.padding.length);
        }
        return isNull;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        boolean isNull = this.deserializeNull(source);
        target.writeBoolean(isNull);
        if (isNull) {
            target.write(this.padding);
        } else {
            this.originalSerializer.copy(source, target);
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass() == this.getClass() && this.originalSerializer.equals(((NullableSerializer)obj).originalSerializer);
    }

    @Override
    public int hashCode() {
        return this.originalSerializer.hashCode();
    }

    @Override
    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        return new NullableSerializerSnapshot(this);
    }

    public static class NullableSerializerSnapshot<T>
    extends CompositeTypeSerializerSnapshot<T, NullableSerializer<T>> {
        private static final int VERSION = 2;
        private int nullPaddingLength;

        public NullableSerializerSnapshot() {
            super(NullableSerializer.class);
        }

        public NullableSerializerSnapshot(NullableSerializer<T> serializerInstance) {
            super(serializerInstance);
            this.nullPaddingLength = ((NullableSerializer)serializerInstance).nullPaddingLength();
        }

        private NullableSerializerSnapshot(int nullPaddingLength) {
            super(NullableSerializer.class);
            Preconditions.checkArgument(nullPaddingLength >= 0, "Computed NULL padding can not be negative. %s", nullPaddingLength);
            this.nullPaddingLength = nullPaddingLength;
        }

        @Override
        protected int getCurrentOuterSnapshotVersion() {
            return 2;
        }

        @Override
        protected TypeSerializer<?>[] getNestedSerializers(NullableSerializer<T> outerSerializer) {
            return new TypeSerializer[]{((NullableSerializer)outerSerializer).originalSerializer()};
        }

        @Override
        protected NullableSerializer<T> createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            Preconditions.checkState(this.nullPaddingLength >= 0, "Negative padding size after serializer construction: %s", this.nullPaddingLength);
            byte[] padding = this.nullPaddingLength == 0 ? EMPTY_BYTE_ARRAY : new byte[this.nullPaddingLength];
            TypeSerializer<?> nestedSerializer = nestedSerializers[0];
            return new NullableSerializer(nestedSerializer, padding);
        }

        @Override
        protected void writeOuterSnapshot(DataOutputView out) throws IOException {
            out.writeInt(this.nullPaddingLength);
        }

        @Override
        protected void readOuterSnapshot(int readOuterSnapshotVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            this.nullPaddingLength = in.readInt();
        }

        @Override
        protected boolean isOuterSnapshotCompatible(NullableSerializer<T> newSerializer) {
            return this.nullPaddingLength == ((NullableSerializer)newSerializer).nullPaddingLength();
        }
    }

    @Deprecated
    @Internal
    public static class NullableSerializerConfigSnapshot<T>
    extends CompositeTypeSerializerConfigSnapshot<T> {
        private static final int VERSION = 1;

        public NullableSerializerConfigSnapshot() {
        }

        NullableSerializerConfigSnapshot(TypeSerializer<T> originalSerializer) {
            super(originalSerializer);
        }

        @Override
        public int getVersion() {
            return 1;
        }

        @Override
        public TypeSerializerSchemaCompatibility<T> resolveSchemaCompatibility(TypeSerializer<T> newSerializer) {
            NullableSerializer previousSerializer = (NullableSerializer)this.restoreSerializer();
            NullableSerializerSnapshot newCompositeSnapshot = new NullableSerializerSnapshot(previousSerializer.nullPaddingLength());
            return CompositeTypeSerializerUtil.delegateCompatibilityCheckToNewSnapshot(newSerializer, newCompositeSnapshot, (TypeSerializerSnapshot)this.getSingleNestedSerializerAndConfig().f1);
        }
    }
}

