/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.java.typeutils.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Arrays;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerConfigSnapshot;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.CompositeTypeSerializerUtil;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.NullMaskUtils;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;

@Internal
public final class RowSerializer
extends TypeSerializer<Row> {
    private static final long serialVersionUID = 1L;
    private final TypeSerializer<Object>[] fieldSerializers;
    private final int arity;
    private transient boolean[] nullMask;

    public RowSerializer(TypeSerializer<?>[] fieldSerializers) {
        this.fieldSerializers = Preconditions.checkNotNull(fieldSerializers);
        this.arity = fieldSerializers.length;
        this.nullMask = new boolean[fieldSerializers.length];
    }

    @Override
    public boolean isImmutableType() {
        return false;
    }

    @Override
    public TypeSerializer<Row> duplicate() {
        TypeSerializer[] duplicateFieldSerializers = new TypeSerializer[this.fieldSerializers.length];
        for (int i = 0; i < this.fieldSerializers.length; ++i) {
            duplicateFieldSerializers[i] = this.fieldSerializers[i].duplicate();
        }
        return new RowSerializer(duplicateFieldSerializers);
    }

    @Override
    public Row createInstance() {
        return new Row(this.fieldSerializers.length);
    }

    @Override
    public Row copy(Row from) {
        int len = this.fieldSerializers.length;
        if (from.getArity() != len) {
            throw new RuntimeException("Row arity of from does not match serializers.");
        }
        Row result = new Row(len);
        for (int i = 0; i < len; ++i) {
            Object fromField = from.getField(i);
            if (fromField != null) {
                Object copy = this.fieldSerializers[i].copy(fromField);
                result.setField(i, copy);
                continue;
            }
            result.setField(i, null);
        }
        return result;
    }

    @Override
    public Row copy(Row from, Row reuse) {
        int len = this.fieldSerializers.length;
        if (reuse == null) {
            return this.copy(from);
        }
        if (from.getArity() != len || reuse.getArity() != len) {
            throw new RuntimeException("Row arity of reuse or from is incompatible with this RowSerializer.");
        }
        for (int i = 0; i < len; ++i) {
            Object fromField = from.getField(i);
            if (fromField != null) {
                Object copy;
                Object reuseField = reuse.getField(i);
                if (reuseField != null) {
                    copy = this.fieldSerializers[i].copy(fromField, reuseField);
                    reuse.setField(i, copy);
                    continue;
                }
                copy = this.fieldSerializers[i].copy(fromField);
                reuse.setField(i, copy);
                continue;
            }
            reuse.setField(i, null);
        }
        return reuse;
    }

    @Override
    public int getLength() {
        return -1;
    }

    public int getArity() {
        return this.arity;
    }

    @Override
    public void serialize(Row record, DataOutputView target) throws IOException {
        int len = this.fieldSerializers.length;
        if (record.getArity() != len) {
            throw new RuntimeException("Row arity of from does not match serializers.");
        }
        NullMaskUtils.writeNullMask(len, record, target);
        for (int i = 0; i < len; ++i) {
            Object o = record.getField(i);
            if (o == null) continue;
            this.fieldSerializers[i].serialize(o, target);
        }
    }

    @Override
    public Row deserialize(DataInputView source) throws IOException {
        int len = this.fieldSerializers.length;
        Row result = new Row(len);
        NullMaskUtils.readIntoNullMask(len, source, this.nullMask);
        for (int i = 0; i < len; ++i) {
            if (this.nullMask[i]) {
                result.setField(i, null);
                continue;
            }
            result.setField(i, this.fieldSerializers[i].deserialize(source));
        }
        return result;
    }

    @Override
    public Row deserialize(Row reuse, DataInputView source) throws IOException {
        int len = this.fieldSerializers.length;
        if (reuse.getArity() != len) {
            throw new RuntimeException("Row arity of from does not match serializers.");
        }
        NullMaskUtils.readIntoNullMask(len, source, this.nullMask);
        for (int i = 0; i < len; ++i) {
            if (this.nullMask[i]) {
                reuse.setField(i, null);
                continue;
            }
            Object reuseField = reuse.getField(i);
            if (reuseField != null) {
                reuse.setField(i, this.fieldSerializers[i].deserialize(reuseField, source));
                continue;
            }
            reuse.setField(i, this.fieldSerializers[i].deserialize(source));
        }
        return reuse;
    }

    @Override
    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int len = this.fieldSerializers.length;
        NullMaskUtils.readIntoAndCopyNullMask(len, source, target, this.nullMask);
        for (int i = 0; i < len; ++i) {
            if (this.nullMask[i]) continue;
            this.fieldSerializers[i].copy(source, target);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof RowSerializer) {
            RowSerializer other = (RowSerializer)obj;
            if (this.fieldSerializers.length == other.fieldSerializers.length) {
                for (int i = 0; i < this.fieldSerializers.length; ++i) {
                    if (this.fieldSerializers[i].equals(other.fieldSerializers[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.fieldSerializers);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.nullMask = new boolean[this.fieldSerializers.length];
    }

    @Override
    public TypeSerializerSnapshot<Row> snapshotConfiguration() {
        return new RowSerializerSnapshot(this);
    }

    public static final class RowSerializerSnapshot
    extends CompositeTypeSerializerSnapshot<Row, RowSerializer> {
        private static final int VERSION = 2;

        public RowSerializerSnapshot() {
            super(RowSerializer.class);
        }

        RowSerializerSnapshot(RowSerializer serializerInstance) {
            super(serializerInstance);
        }

        @Override
        protected int getCurrentOuterSnapshotVersion() {
            return 2;
        }

        @Override
        protected TypeSerializer<?>[] getNestedSerializers(RowSerializer outerSerializer) {
            return outerSerializer.fieldSerializers;
        }

        @Override
        protected RowSerializer createOuterSerializerWithNestedSerializers(TypeSerializer<?>[] nestedSerializers) {
            return new RowSerializer(nestedSerializers);
        }
    }

    @Deprecated
    public static final class RowSerializerConfigSnapshot
    extends CompositeTypeSerializerConfigSnapshot<Row> {
        private static final int VERSION = 1;

        public RowSerializerConfigSnapshot() {
        }

        public RowSerializerConfigSnapshot(TypeSerializer[] fieldSerializers) {
            super(fieldSerializers);
        }

        @Override
        public int getVersion() {
            return 1;
        }

        @Override
        public TypeSerializerSchemaCompatibility<Row> resolveSchemaCompatibility(TypeSerializer<Row> newSerializer) {
            TypeSerializerSnapshot[] nestedSnapshots = (TypeSerializerSnapshot[])this.getNestedSerializersAndConfigs().stream().map(t -> (TypeSerializerSnapshot)t.f1).toArray(TypeSerializerSnapshot[]::new);
            return CompositeTypeSerializerUtil.delegateCompatibilityCheckToNewSnapshot(newSerializer, new RowSerializerSnapshot(), nestedSnapshots);
        }
    }
}

