/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.IOException;
import java.io.Serializable;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.FallbackKey;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.StructuredOptionsSplitter;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public class Configuration
extends ExecutionConfig.GlobalJobParameters
implements IOReadableWritable,
Serializable,
Cloneable,
ReadableConfig,
WritableConfig {
    private static final long serialVersionUID = 1L;
    private static final byte TYPE_STRING = 0;
    private static final byte TYPE_INT = 1;
    private static final byte TYPE_LONG = 2;
    private static final byte TYPE_BOOLEAN = 3;
    private static final byte TYPE_FLOAT = 4;
    private static final byte TYPE_DOUBLE = 5;
    private static final byte TYPE_BYTES = 6;
    private static final Logger LOG = LoggerFactory.getLogger(Configuration.class);
    protected final HashMap<String, Object> confData;

    public Configuration() {
        this.confData = new HashMap();
    }

    public Configuration(Configuration other) {
        this.confData = new HashMap<String, Object>(other.confData);
    }

    public <T> Class<T> getClass(String key, Class<? extends T> defaultValue, ClassLoader classLoader) throws ClassNotFoundException {
        Optional<Object> o = this.getRawValue(key);
        if (!o.isPresent()) {
            return defaultValue;
        }
        if (o.get().getClass() == String.class) {
            return Class.forName((String)o.get(), true, classLoader);
        }
        throw new IllegalArgumentException("Configuration cannot evaluate object of class " + o.get().getClass() + " as a class name");
    }

    public void setClass(String key, Class<?> klazz) {
        this.setValueInternal(key, klazz.getName());
    }

    @Deprecated
    public String getString(String key, String defaultValue) {
        return this.getRawValue(key).map(this::convertToString).orElse(defaultValue);
    }

    @PublicEvolving
    public String getString(ConfigOption<String> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    @PublicEvolving
    public String getString(ConfigOption<String> configOption, String overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    public void setString(String key, String value) {
        this.setValueInternal(key, value);
    }

    @PublicEvolving
    public void setString(ConfigOption<String> key, String value) {
        this.setValueInternal(key.key(), value);
    }

    @Deprecated
    public int getInteger(String key, int defaultValue) {
        return this.getRawValue(key).map(this::convertToInt).orElse(defaultValue);
    }

    @PublicEvolving
    public int getInteger(ConfigOption<Integer> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    @PublicEvolving
    public int getInteger(ConfigOption<Integer> configOption, int overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    public void setInteger(String key, int value) {
        this.setValueInternal(key, value);
    }

    @PublicEvolving
    public void setInteger(ConfigOption<Integer> key, int value) {
        this.setValueInternal(key.key(), value);
    }

    @Deprecated
    public long getLong(String key, long defaultValue) {
        return this.getRawValue(key).map(this::convertToLong).orElse(defaultValue);
    }

    @PublicEvolving
    public long getLong(ConfigOption<Long> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    @PublicEvolving
    public long getLong(ConfigOption<Long> configOption, long overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    public void setLong(String key, long value) {
        this.setValueInternal(key, value);
    }

    @PublicEvolving
    public void setLong(ConfigOption<Long> key, long value) {
        this.setValueInternal(key.key(), value);
    }

    @Deprecated
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getRawValue(key).map(this::convertToBoolean).orElse(defaultValue);
    }

    @PublicEvolving
    public boolean getBoolean(ConfigOption<Boolean> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    @PublicEvolving
    public boolean getBoolean(ConfigOption<Boolean> configOption, boolean overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    public void setBoolean(String key, boolean value) {
        this.setValueInternal(key, value);
    }

    @PublicEvolving
    public void setBoolean(ConfigOption<Boolean> key, boolean value) {
        this.setValueInternal(key.key(), value);
    }

    @Deprecated
    public float getFloat(String key, float defaultValue) {
        return this.getRawValue(key).map(this::convertToFloat).orElse(Float.valueOf(defaultValue)).floatValue();
    }

    @PublicEvolving
    public float getFloat(ConfigOption<Float> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue).floatValue();
    }

    @PublicEvolving
    public float getFloat(ConfigOption<Float> configOption, float overrideDefault) {
        return this.getOptional(configOption).orElse(Float.valueOf(overrideDefault)).floatValue();
    }

    public void setFloat(String key, float value) {
        this.setValueInternal(key, Float.valueOf(value));
    }

    @PublicEvolving
    public void setFloat(ConfigOption<Float> key, float value) {
        this.setValueInternal(key.key(), Float.valueOf(value));
    }

    @Deprecated
    public double getDouble(String key, double defaultValue) {
        return this.getRawValue(key).map(this::convertToDouble).orElse(defaultValue);
    }

    @PublicEvolving
    public double getDouble(ConfigOption<Double> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    @PublicEvolving
    public double getDouble(ConfigOption<Double> configOption, double overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    public void setDouble(String key, double value) {
        this.setValueInternal(key, value);
    }

    @PublicEvolving
    public void setDouble(ConfigOption<Double> key, double value) {
        this.setValueInternal(key.key(), value);
    }

    public byte[] getBytes(String key, byte[] defaultValue) {
        return this.getRawValue(key).map(o -> {
            if (o.getClass().equals(byte[].class)) {
                return (byte[])o;
            }
            throw new IllegalArgumentException(String.format("Configuration cannot evaluate value %s as a byte[] value", o));
        }).orElse(defaultValue);
    }

    public void setBytes(String key, byte[] bytes) {
        this.setValueInternal(key, bytes);
    }

    @PublicEvolving
    public String getValue(ConfigOption<?> configOption) {
        return Optional.ofNullable(this.getRawValueFromOption(configOption).orElseGet(configOption::defaultValue)).map(String::valueOf).orElse(null);
    }

    @PublicEvolving
    public <T extends Enum<T>> T getEnum(Class<T> enumClass, ConfigOption<String> configOption) {
        Preconditions.checkNotNull(enumClass, "enumClass must not be null");
        Preconditions.checkNotNull(configOption, "configOption must not be null");
        Object rawValue = this.getRawValueFromOption(configOption).orElseGet(configOption::defaultValue);
        try {
            return this.convertToEnum(rawValue, enumClass);
        }
        catch (IllegalArgumentException ex) {
            String errorMessage = String.format("Value for config option %s must be one of %s (was %s)", configOption.key(), Arrays.toString(enumClass.getEnumConstants()), rawValue);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            return new HashSet<String>(this.confData.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllToProperties(Properties props) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            for (Map.Entry<String, Object> entry : this.confData.entrySet()) {
                props.put(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Configuration other) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            HashMap<String, Object> hashMap2 = other.confData;
            synchronized (hashMap2) {
                this.confData.putAll(other.confData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Configuration other, String prefix) {
        StringBuilder bld = new StringBuilder();
        bld.append(prefix);
        int pl = bld.length();
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            HashMap<String, Object> hashMap2 = other.confData;
            synchronized (hashMap2) {
                for (Map.Entry<String, Object> entry : other.confData.entrySet()) {
                    bld.setLength(pl);
                    bld.append(entry.getKey());
                    this.confData.put(bld.toString(), entry.getValue());
                }
            }
        }
    }

    public Configuration clone() {
        Configuration config = new Configuration();
        config.addAll(this);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            return this.confData.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublicEvolving
    public boolean contains(ConfigOption<?> configOption) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            if (this.confData.containsKey(configOption.key())) {
                return true;
            }
            if (configOption.hasFallbackKeys()) {
                for (FallbackKey fallbackKey : configOption.fallbackKeys()) {
                    if (!this.confData.containsKey(fallbackKey.getKey())) continue;
                    this.loggingFallback(fallbackKey, configOption);
                    return true;
                }
            }
            return false;
        }
    }

    @Override
    public <T> T get(ConfigOption<T> option) {
        return (T)this.getOptional(option).orElseGet(option::defaultValue);
    }

    @Override
    public <T> Optional<T> getOptional(ConfigOption<T> option) {
        Optional<Object> rawValue = this.getRawValueFromOption(option);
        Class clazz = option.getClazz();
        try {
            if (option.isList()) {
                return rawValue.map(v -> this.convertToList(v, clazz));
            }
            return rawValue.map(v -> this.convertValue(v, clazz));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not parse value '%s' for key '%s'.", rawValue.map(Object::toString).orElse(""), option.key()), e);
        }
    }

    @Override
    public <T> Configuration set(ConfigOption<T> option, T value) {
        this.setValueInternal(option.key(), value);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> toMap() {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            HashMap<String, String> ret = new HashMap<String, String>(this.confData.size());
            for (Map.Entry<String, Object> entry : this.confData.entrySet()) {
                ret.put(entry.getKey(), this.convertToString(entry.getValue()));
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean removeConfig(ConfigOption<T> configOption) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            Object oldValue = this.confData.remove(configOption.key());
            if (oldValue == null) {
                for (FallbackKey fallbackKey : configOption.fallbackKeys()) {
                    oldValue = this.confData.remove(fallbackKey.getKey());
                    if (oldValue == null) continue;
                    this.loggingFallback(fallbackKey, configOption);
                    return true;
                }
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void setValueInternal(String key, T value) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        if (value == null) {
            throw new NullPointerException("Value must not be null.");
        }
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            this.confData.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Object> getRawValue(String key) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            return Optional.ofNullable(this.confData.get(key));
        }
    }

    private Optional<Object> getRawValueFromOption(ConfigOption<?> configOption) {
        Optional<Object> o = this.getRawValue(configOption.key());
        if (o.isPresent()) {
            return o;
        }
        if (configOption.hasFallbackKeys()) {
            for (FallbackKey fallbackKey : configOption.fallbackKeys()) {
                Optional<Object> oo = this.getRawValue(fallbackKey.getKey());
                if (!oo.isPresent()) continue;
                this.loggingFallback(fallbackKey, configOption);
                return oo;
            }
        }
        return Optional.empty();
    }

    private void loggingFallback(FallbackKey fallbackKey, ConfigOption<?> configOption) {
        if (fallbackKey.isDeprecated()) {
            LOG.warn("Config uses deprecated configuration key '{}' instead of proper key '{}'", (Object)fallbackKey.getKey(), (Object)configOption.key());
        } else {
            LOG.info("Config uses fallback configuration key '{}' instead of key '{}'", (Object)fallbackKey.getKey(), (Object)configOption.key());
        }
    }

    private <T> T convertValue(Object rawValue, Class clazz) {
        if (Integer.class.equals((Object)clazz)) {
            return (T)this.convertToInt(rawValue);
        }
        if (Long.class.equals((Object)clazz)) {
            return (T)this.convertToLong(rawValue);
        }
        if (Boolean.class.equals((Object)clazz)) {
            return (T)this.convertToBoolean(rawValue);
        }
        if (Float.class.equals((Object)clazz)) {
            return (T)this.convertToFloat(rawValue);
        }
        if (Double.class.equals((Object)clazz)) {
            return (T)this.convertToDouble(rawValue);
        }
        if (String.class.equals((Object)clazz)) {
            return (T)this.convertToString(rawValue);
        }
        if (clazz.isEnum()) {
            return (T)this.convertToEnum(rawValue, clazz);
        }
        if (clazz == Duration.class) {
            return (T)this.convertToDuration(rawValue);
        }
        if (clazz == MemorySize.class) {
            return (T)this.convertToMemorySize(rawValue);
        }
        if (clazz == Map.class) {
            return (T)this.convertToProperties(rawValue);
        }
        throw new IllegalArgumentException("Unsupported type: " + clazz);
    }

    private <T> T convertToList(Object rawValue, Class atomicClass) {
        if (rawValue instanceof List) {
            return (T)rawValue;
        }
        return (T)StructuredOptionsSplitter.splitEscaped(rawValue.toString(), ';').stream().map(s -> this.convertValue(s, atomicClass)).collect(Collectors.toList());
    }

    private Map<String, String> convertToProperties(Object o) {
        if (o instanceof Map) {
            return (Map)o;
        }
        List<String> listOfRawProperties = StructuredOptionsSplitter.splitEscaped(o.toString(), ',');
        return listOfRawProperties.stream().map(s -> StructuredOptionsSplitter.splitEscaped(s, ':')).map(pair -> {
            if (pair.size() != 2) {
                throw new IllegalArgumentException("Could not parse pair in the map " + pair);
            }
            return pair;
        }).collect(Collectors.toMap(a -> (String)a.get(0), a -> (String)a.get(1)));
    }

    private <E extends Enum<E>> E convertToEnum(Object o, Class<E> clazz) {
        if (o.getClass().equals(clazz)) {
            return (E)((Enum)o);
        }
        return (E)Arrays.stream(clazz.getEnumConstants()).filter(e -> e.toString().toUpperCase(Locale.ROOT).equals(o.toString().toUpperCase(Locale.ROOT))).findAny().orElseThrow(() -> new IllegalArgumentException(String.format("Could not parse value for enum %s. Expected one of: [%s]", clazz, Arrays.toString(clazz.getEnumConstants()))));
    }

    private Duration convertToDuration(Object o) {
        if (o.getClass() == Duration.class) {
            return (Duration)o;
        }
        return TimeUtils.parseDuration(o.toString());
    }

    private MemorySize convertToMemorySize(Object o) {
        if (o.getClass() == MemorySize.class) {
            return (MemorySize)o;
        }
        return MemorySize.parse(o.toString());
    }

    private String convertToString(Object o) {
        if (o.getClass() == String.class) {
            return (String)o;
        }
        if (o.getClass() == Duration.class) {
            Duration duration = (Duration)o;
            return String.format("%d ns", duration.toNanos());
        }
        if (o instanceof List) {
            return ((List)o).stream().map(e -> StructuredOptionsSplitter.escapeWithSingleQuote(this.convertToString(e), ";")).collect(Collectors.joining(";"));
        }
        if (o instanceof Map) {
            return ((Map)o).entrySet().stream().map(e -> {
                String escapedKey = StructuredOptionsSplitter.escapeWithSingleQuote(e.getKey().toString(), ":");
                String escapedValue = StructuredOptionsSplitter.escapeWithSingleQuote(e.getValue().toString(), ":");
                return StructuredOptionsSplitter.escapeWithSingleQuote(escapedKey + ":" + escapedValue, ",");
            }).collect(Collectors.joining(","));
        }
        return o.toString();
    }

    private Integer convertToInt(Object o) {
        if (o.getClass() == Integer.class) {
            return (Integer)o;
        }
        if (o.getClass() == Long.class) {
            long value = (Long)o;
            if (value <= Integer.MAX_VALUE && value >= Integer.MIN_VALUE) {
                return (int)value;
            }
            throw new IllegalArgumentException(String.format("Configuration value %s overflows/underflows the integer type.", value));
        }
        return Integer.parseInt(o.toString());
    }

    private Long convertToLong(Object o) {
        if (o.getClass() == Long.class) {
            return (Long)o;
        }
        if (o.getClass() == Integer.class) {
            return ((Integer)o).longValue();
        }
        return Long.parseLong(o.toString());
    }

    private Boolean convertToBoolean(Object o) {
        if (o.getClass() == Boolean.class) {
            return (Boolean)o;
        }
        switch (o.toString().toUpperCase()) {
            case "TRUE": {
                return true;
            }
            case "FALSE": {
                return false;
            }
        }
        throw new IllegalArgumentException(String.format("Unrecognized option for boolean: %s. Expected either true or false(case insensitive)", o));
    }

    private Float convertToFloat(Object o) {
        if (o.getClass() == Float.class) {
            return (Float)o;
        }
        if (o.getClass() == Double.class) {
            double value = (Double)o;
            if (value == 0.0 || value >= (double)1.4E-45f && value <= 3.4028234663852886E38 || value >= -3.4028234663852886E38 && value <= (double)-1.4E-45f) {
                return Float.valueOf((float)value);
            }
            throw new IllegalArgumentException(String.format("Configuration value %s overflows/underflows the float type.", value));
        }
        return Float.valueOf(Float.parseFloat(o.toString()));
    }

    private Double convertToDouble(Object o) {
        if (o.getClass() == Double.class) {
            return (Double)o;
        }
        if (o.getClass() == Float.class) {
            return ((Float)o).doubleValue();
        }
        return Double.parseDouble(o.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(DataInputView in) throws IOException {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            int numberOfProperties = in.readInt();
            for (int i = 0; i < numberOfProperties; ++i) {
                Object value;
                String key = StringValue.readString(in);
                byte type = in.readByte();
                switch (type) {
                    case 0: {
                        value = StringValue.readString(in);
                        break;
                    }
                    case 1: {
                        value = in.readInt();
                        break;
                    }
                    case 2: {
                        value = in.readLong();
                        break;
                    }
                    case 4: {
                        value = Float.valueOf(in.readFloat());
                        break;
                    }
                    case 5: {
                        value = in.readDouble();
                        break;
                    }
                    case 3: {
                        value = in.readBoolean();
                        break;
                    }
                    case 6: {
                        byte[] bytes = new byte[in.readInt()];
                        in.readFully(bytes);
                        value = bytes;
                        break;
                    }
                    default: {
                        throw new IOException(String.format("Unrecognized type: %s. This method is deprecated and might not work for all supported types.", type));
                    }
                }
                this.confData.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutputView out) throws IOException {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            out.writeInt(this.confData.size());
            for (Map.Entry<String, Object> entry : this.confData.entrySet()) {
                String key = entry.getKey();
                Object val = entry.getValue();
                StringValue.writeString(key, out);
                Class<?> clazz = val.getClass();
                if (clazz == String.class) {
                    out.write(0);
                    StringValue.writeString((String)val, out);
                    continue;
                }
                if (clazz == Integer.class) {
                    out.write(1);
                    out.writeInt((Integer)val);
                    continue;
                }
                if (clazz == Long.class) {
                    out.write(2);
                    out.writeLong((Long)val);
                    continue;
                }
                if (clazz == Float.class) {
                    out.write(4);
                    out.writeFloat(((Float)val).floatValue());
                    continue;
                }
                if (clazz == Double.class) {
                    out.write(5);
                    out.writeDouble((Double)val);
                    continue;
                }
                if (clazz == byte[].class) {
                    out.write(6);
                    byte[] bytes = (byte[])val;
                    out.writeInt(bytes.length);
                    out.write(bytes);
                    continue;
                }
                if (clazz == Boolean.class) {
                    out.write(3);
                    out.writeBoolean((Boolean)val);
                    continue;
                }
                throw new IllegalArgumentException("Unrecognized type. This method is deprecated and might not work for all supported types.");
            }
        }
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (String s : this.confData.keySet()) {
            hash ^= s.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Configuration) {
            HashMap<String, Object> otherConf = ((Configuration)obj).confData;
            for (Map.Entry<String, Object> e : this.confData.entrySet()) {
                Object thisVal = e.getValue();
                Object otherVal = otherConf.get(e.getKey());
                if (!thisVal.getClass().equals(byte[].class)) {
                    if (thisVal.equals(otherVal)) continue;
                    return false;
                }
                if (otherVal.getClass().equals(byte[].class)) {
                    if (Arrays.equals((byte[])thisVal, (byte[])otherVal)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.confData.toString();
    }
}

