/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.FallbackKey;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.Preconditions;

@Internal
public class ReadableConfigToConfigurationAdapter
extends Configuration {
    private final ReadableConfig backingConfig;

    public ReadableConfigToConfigurationAdapter(ReadableConfig backingConfig) {
        this.backingConfig = Preconditions.checkNotNull(backingConfig);
    }

    @Override
    public String getString(ConfigOption<String> configOption) {
        return this.backingConfig.get(configOption);
    }

    @Override
    public String getString(ConfigOption<String> configOption, String overrideDefault) {
        return this.backingConfig.getOptional(configOption).orElse(overrideDefault);
    }

    @Override
    public int getInteger(ConfigOption<Integer> configOption) {
        return this.backingConfig.get(configOption);
    }

    @Override
    public int getInteger(ConfigOption<Integer> configOption, int overrideDefault) {
        return this.backingConfig.getOptional(configOption).orElse(overrideDefault);
    }

    @Override
    public long getLong(ConfigOption<Long> configOption) {
        return this.backingConfig.get(configOption);
    }

    @Override
    public long getLong(ConfigOption<Long> configOption, long overrideDefault) {
        return this.backingConfig.getOptional(configOption).orElse(overrideDefault);
    }

    @Override
    public boolean getBoolean(ConfigOption<Boolean> configOption) {
        return this.backingConfig.get(configOption);
    }

    @Override
    public boolean getBoolean(ConfigOption<Boolean> configOption, boolean overrideDefault) {
        return this.backingConfig.getOptional(configOption).orElse(overrideDefault);
    }

    @Override
    public float getFloat(ConfigOption<Float> configOption) {
        return this.backingConfig.get(configOption).floatValue();
    }

    @Override
    public float getFloat(ConfigOption<Float> configOption, float overrideDefault) {
        return this.backingConfig.getOptional(configOption).orElse(Float.valueOf(overrideDefault)).floatValue();
    }

    @Override
    public double getDouble(ConfigOption<Double> configOption) {
        return this.backingConfig.get(configOption);
    }

    @Override
    public double getDouble(ConfigOption<Double> configOption, double overrideDefault) {
        return this.backingConfig.getOptional(configOption).orElse(overrideDefault);
    }

    @Override
    public <T extends Enum<T>> T getEnum(Class<T> enumClass, ConfigOption<String> configOption) {
        ArrayList<String> deprecatedKeys = new ArrayList<String>();
        ArrayList<String> fallbackKeys = new ArrayList<String>();
        for (FallbackKey fallbackKey : configOption.fallbackKeys()) {
            if (fallbackKey.isDeprecated()) {
                deprecatedKeys.add(fallbackKey.getKey());
                continue;
            }
            fallbackKeys.add(fallbackKey.getKey());
        }
        ConfigOption<T> key = ConfigOptions.key(configOption.key()).enumType(enumClass).noDefaultValue().withFallbackKeys(fallbackKeys.toArray(new String[0])).withDeprecatedKeys(deprecatedKeys.toArray(new String[0]));
        return (T)((Enum)this.get(key));
    }

    @Override
    public String getString(String key, String defaultValue) {
        return this.get(ConfigOptions.key(key).stringType().defaultValue(defaultValue));
    }

    @Override
    public int getInteger(String key, int defaultValue) {
        return this.get(ConfigOptions.key(key).intType().defaultValue(defaultValue));
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return this.get(ConfigOptions.key(key).longType().defaultValue(defaultValue));
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.get(ConfigOptions.key(key).booleanType().defaultValue(defaultValue));
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        return this.get(ConfigOptions.key(key).floatType().defaultValue(Float.valueOf(defaultValue))).floatValue();
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return this.get(ConfigOptions.key(key).doubleType().defaultValue(defaultValue));
    }

    @Override
    public <T> Class<T> getClass(String key, Class<? extends T> defaultValue, ClassLoader classLoader) throws ClassNotFoundException {
        Optional<String> option = this.getOptional(ConfigOptions.key(key).stringType().noDefaultValue());
        if (option.isPresent()) {
            return Class.forName(option.get(), true, classLoader);
        }
        return defaultValue;
    }

    @Override
    public <T> T get(ConfigOption<T> option) {
        return this.backingConfig.get(option);
    }

    @Override
    public <T> Optional<T> getOptional(ConfigOption<T> option) {
        return this.backingConfig.getOptional(option);
    }

    @Override
    public boolean contains(ConfigOption<?> configOption) {
        return this.backingConfig.getOptional(configOption).isPresent();
    }

    @Override
    public int hashCode() {
        return this.backingConfig.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.backingConfig.equals(obj);
    }

    @Override
    public String toString() {
        return this.backingConfig.toString();
    }

    @Override
    public void setClass(String key, Class<?> klazz) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public void setString(String key, String value) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public void setString(ConfigOption<String> key, String value) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public void setInteger(String key, int value) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public void setInteger(ConfigOption<Integer> key, int value) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public void setLong(String key, long value) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public void setLong(ConfigOption<Long> key, long value) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public void setBoolean(String key, boolean value) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public void setBoolean(ConfigOption<Boolean> key, boolean value) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public void setFloat(String key, float value) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public void setFloat(ConfigOption<Float> key, float value) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public void setDouble(String key, double value) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public void setDouble(ConfigOption<Double> key, double value) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public void setBytes(String key, byte[] bytes) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public void addAllToProperties(Properties props) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public void addAll(Configuration other) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public void addAll(Configuration other, String prefix) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public <T> Configuration set(ConfigOption<T> option, T value) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    <T> void setValueInternal(String key, T value) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public <T> boolean removeConfig(ConfigOption<T> configOption) {
        throw new UnsupportedOperationException("The configuration is read only");
    }

    @Override
    public byte[] getBytes(String key, byte[] defaultValue) {
        throw new UnsupportedOperationException("The adapter does not support this method");
    }

    @Override
    public String getValue(ConfigOption<?> configOption) {
        throw new UnsupportedOperationException("The adapter does not support this method");
    }

    @Override
    public Configuration clone() {
        throw new UnsupportedOperationException("The adapter does not support this method");
    }

    @Override
    public boolean containsKey(String key) {
        throw new UnsupportedOperationException("The adapter does not support this method");
    }

    @Override
    public Set<String> keySet() {
        throw new UnsupportedOperationException("The adapter does not support this method");
    }

    @Override
    public Map<String, String> toMap() {
        throw new UnsupportedOperationException("The adapter does not support this method");
    }

    @Override
    public void read(DataInputView in) throws IOException {
        throw new UnsupportedOperationException("The adapter does not support this method");
    }

    @Override
    public void write(DataOutputView out) throws IOException {
        throw new UnsupportedOperationException("The adapter does not support this method");
    }
}

