/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.function.RunnableWithException;

@Internal
public final class ExceptionUtils {
    public static final String STRINGIFIED_NULL_EXCEPTION = "(null)";
    private static final String TM_DIRECT_OOM_ERROR_MESSAGE = String.format("Direct buffer memory. The direct out-of-memory error has occurred. This can mean two things: either job(s) require(s) a larger size of JVM direct memory or there is a direct memory leak. The direct memory can be allocated by user code or some of its dependencies. In this case '%s' configuration option should be increased. Flink framework and its dependencies also consume the direct memory, mostly for network communication. The most of network memory is managed by Flink and should not result in out-of-memory error. In certain special cases, in particular for jobs with high parallelism, the framework may require more direct memory which is not managed by Flink. In this case '%s' configuration option should be increased. If the error persists then there is probably a direct memory leak which has to be investigated and fixed. The task executor has to be shutdown...", TaskManagerOptions.TASK_OFF_HEAP_MEMORY.key(), TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY.key());
    private static final String TM_METASPACE_OOM_ERROR_MESSAGE = String.format("Metaspace. The metaspace out-of-memory error has occurred. This can mean two things: either the job requires a larger size of JVM metaspace to load classes or there is a class loading leak. In the first case '%s' configuration option should be increased. If the error persists (usually in cluster after several job (re-)submissions) then there is probably a class loading leak which has to be investigated and fixed. The task executor has to be shutdown...", TaskManagerOptions.JVM_METASPACE.key());

    public static String stringifyException(Throwable e) {
        if (e == null) {
            return STRINGIFIED_NULL_EXCEPTION;
        }
        try {
            StringWriter stm = new StringWriter();
            PrintWriter wrt = new PrintWriter(stm);
            e.printStackTrace(wrt);
            wrt.close();
            return stm.toString();
        }
        catch (Throwable t) {
            return e.getClass().getName() + " (error while printing stack trace)";
        }
    }

    public static boolean isJvmFatalError(Throwable t) {
        return t instanceof InternalError || t instanceof UnknownError || t instanceof ThreadDeath;
    }

    public static boolean isJvmFatalOrOutOfMemoryError(Throwable t) {
        return ExceptionUtils.isJvmFatalError(t) || t instanceof OutOfMemoryError;
    }

    @Nullable
    public static Throwable tryEnrichTaskManagerError(@Nullable Throwable exception) {
        if (exception instanceof OutOfMemoryError) {
            return ExceptionUtils.tryEnrichTaskManagerOutOfMemoryError((OutOfMemoryError)exception);
        }
        return exception;
    }

    private static Throwable tryEnrichTaskManagerOutOfMemoryError(OutOfMemoryError oom) {
        if (ExceptionUtils.isMetaspaceOutOfMemoryError(oom)) {
            return ExceptionUtils.changeOutOfMemoryErrorMessage(oom, TM_METASPACE_OOM_ERROR_MESSAGE);
        }
        if (ExceptionUtils.isDirectOutOfMemoryError(oom)) {
            return ExceptionUtils.changeOutOfMemoryErrorMessage(oom, TM_DIRECT_OOM_ERROR_MESSAGE);
        }
        return oom;
    }

    private static OutOfMemoryError changeOutOfMemoryErrorMessage(OutOfMemoryError oom, String newMessage) {
        if (oom.getMessage().equals(newMessage)) {
            return oom;
        }
        OutOfMemoryError newError = new OutOfMemoryError(newMessage);
        newError.initCause(oom.getCause());
        newError.setStackTrace(oom.getStackTrace());
        return newError;
    }

    public static boolean isMetaspaceOutOfMemoryError(@Nullable Throwable t) {
        return ExceptionUtils.isOutOfMemoryErrorWithMessageStartingWith(t, "Metaspace");
    }

    public static boolean isDirectOutOfMemoryError(@Nullable Throwable t) {
        return ExceptionUtils.isOutOfMemoryErrorWithMessageStartingWith(t, "Direct buffer memory");
    }

    private static boolean isOutOfMemoryErrorWithMessageStartingWith(@Nullable Throwable t, String prefix) {
        return ExceptionUtils.isOutOfMemoryError(t) && t.getMessage() != null && t.getMessage().startsWith(prefix);
    }

    private static boolean isOutOfMemoryError(@Nullable Throwable t) {
        return t != null && t.getClass() == OutOfMemoryError.class;
    }

    public static void rethrowIfFatalError(Throwable t) {
        if (ExceptionUtils.isJvmFatalError(t)) {
            throw (Error)t;
        }
    }

    public static void rethrowIfFatalErrorOrOOM(Throwable t) {
        if (ExceptionUtils.isJvmFatalError(t) || t instanceof OutOfMemoryError) {
            throw (Error)t;
        }
    }

    public static <T extends Throwable> T firstOrSuppressed(T newException, @Nullable T previous) {
        Preconditions.checkNotNull(newException, "newException");
        if (previous == null) {
            return newException;
        }
        previous.addSuppressed(newException);
        return previous;
    }

    public static void rethrow(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    public static void rethrow(Throwable t, String parentMessage) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(parentMessage, t);
    }

    public static void rethrowException(Throwable t, String parentMessage) throws Exception {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        throw new Exception(parentMessage, t);
    }

    public static void rethrowException(Throwable t) throws Exception {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        throw new Exception(t.getMessage(), t);
    }

    public static void tryRethrowException(@Nullable Exception e) throws Exception {
        if (e != null) {
            throw e;
        }
    }

    public static void tryRethrowIOException(Throwable t) throws IOException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
    }

    public static void rethrowIOException(Throwable t) throws IOException {
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new IOException(t.getMessage(), t);
    }

    public static <T extends Throwable> Optional<T> findSerializedThrowable(Throwable throwable, Class<T> searchType, ClassLoader classLoader) {
        if (throwable == null || searchType == null) {
            return Optional.empty();
        }
        Throwable t = throwable;
        while (t != null) {
            if (searchType.isAssignableFrom(t.getClass())) {
                return Optional.of(searchType.cast(t));
            }
            if (t.getClass().isAssignableFrom(SerializedThrowable.class)) {
                Throwable next = ((SerializedThrowable)t).deserializeError(classLoader);
                t = next == t ? null : next;
                continue;
            }
            t = t.getCause();
        }
        return Optional.empty();
    }

    public static <T extends Throwable> Optional<T> findThrowable(Throwable throwable, Class<T> searchType) {
        if (throwable == null || searchType == null) {
            return Optional.empty();
        }
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (!searchType.isAssignableFrom(t.getClass())) continue;
            return Optional.of(searchType.cast(t));
        }
        return Optional.empty();
    }

    public static Optional<Throwable> findThrowable(Throwable throwable, Predicate<Throwable> predicate) {
        if (throwable == null || predicate == null) {
            return Optional.empty();
        }
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (!predicate.test(t)) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public static Optional<Throwable> findThrowableWithMessage(Throwable throwable, String searchMessage) {
        if (throwable == null || searchMessage == null) {
            return Optional.empty();
        }
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (t.getMessage() == null || !t.getMessage().contains(searchMessage)) continue;
            return Optional.of(t);
        }
        return Optional.empty();
    }

    public static Throwable stripExecutionException(Throwable throwable) {
        return ExceptionUtils.stripException(throwable, ExecutionException.class);
    }

    public static Throwable stripCompletionException(Throwable throwable) {
        return ExceptionUtils.stripException(throwable, CompletionException.class);
    }

    public static Throwable stripException(Throwable throwableToStrip, Class<? extends Throwable> typeToStrip) {
        while (typeToStrip.isAssignableFrom(throwableToStrip.getClass()) && throwableToStrip.getCause() != null) {
            throwableToStrip = throwableToStrip.getCause();
        }
        return throwableToStrip;
    }

    public static void tryDeserializeAndThrow(Throwable throwable, ClassLoader classLoader) throws Throwable {
        Throwable current = throwable;
        while (!(current instanceof SerializedThrowable) && current.getCause() != null) {
            current = current.getCause();
        }
        if (current instanceof SerializedThrowable) {
            throw ((SerializedThrowable)current).deserializeError(classLoader);
        }
        throw throwable;
    }

    public static void checkInterrupted(Throwable e) {
        if (e instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static void suppressExceptions(RunnableWithException action) {
        block3: {
            try {
                action.run();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable t) {
                if (!ExceptionUtils.isJvmFatalError(t)) break block3;
                ExceptionUtils.rethrow(t);
            }
        }
    }

    private ExceptionUtils() {
    }
}

