/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.api.common.restartstrategy;

import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.RestartStrategyOptions;

@PublicEvolving
public class RestartStrategies {
    public static RestartStrategyConfiguration noRestart() {
        return new NoRestartStrategyConfiguration();
    }

    public static RestartStrategyConfiguration fallBackRestart() {
        return new FallbackRestartStrategyConfiguration();
    }

    public static RestartStrategyConfiguration fixedDelayRestart(int restartAttempts, long delayBetweenAttempts) {
        return RestartStrategies.fixedDelayRestart(restartAttempts, Time.of(delayBetweenAttempts, TimeUnit.MILLISECONDS));
    }

    public static RestartStrategyConfiguration fixedDelayRestart(int restartAttempts, Time delayInterval) {
        return new FixedDelayRestartStrategyConfiguration(restartAttempts, delayInterval);
    }

    public static FailureRateRestartStrategyConfiguration failureRateRestart(int failureRate, Time failureInterval, Time delayInterval) {
        return new FailureRateRestartStrategyConfiguration(failureRate, failureInterval, delayInterval);
    }

    public static Optional<RestartStrategyConfiguration> fromConfiguration(ReadableConfig configuration) {
        return configuration.getOptional(RestartStrategyOptions.RESTART_STRATEGY).map(confName -> RestartStrategies.parseConfiguration(confName, configuration));
    }

    private static RestartStrategyConfiguration parseConfiguration(String restartstrategyKind, ReadableConfig configuration) {
        switch (restartstrategyKind.toLowerCase()) {
            case "none": 
            case "off": 
            case "disable": {
                return RestartStrategies.noRestart();
            }
            case "fixeddelay": 
            case "fixed-delay": {
                int attempts = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS);
                Duration delay = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY);
                return RestartStrategies.fixedDelayRestart(attempts, delay.toMillis());
            }
            case "failurerate": 
            case "failure-rate": {
                int maxFailures = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_MAX_FAILURES_PER_INTERVAL);
                Duration failureRateInterval = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_FAILURE_RATE_INTERVAL);
                Duration failureRateDelay = configuration.get(RestartStrategyOptions.RESTART_STRATEGY_FAILURE_RATE_DELAY);
                return RestartStrategies.failureRateRestart(maxFailures, Time.milliseconds(failureRateInterval.toMillis()), Time.milliseconds(failureRateDelay.toMillis()));
            }
        }
        throw new IllegalArgumentException("Unknown restart strategy " + restartstrategyKind + ".");
    }

    public static final class FallbackRestartStrategyConfiguration
    extends RestartStrategyConfiguration {
        private static final long serialVersionUID = -4441787204284085544L;

        @Override
        public String getDescription() {
            return "Cluster level default restart strategy";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof FallbackRestartStrategyConfiguration;
        }

        public int hashCode() {
            return Objects.hash(new Object[0]);
        }
    }

    public static final class FailureRateRestartStrategyConfiguration
    extends RestartStrategyConfiguration {
        private static final long serialVersionUID = 1195028697539661739L;
        private final int maxFailureRate;
        private final Time failureInterval;
        private final Time delayBetweenAttemptsInterval;

        public FailureRateRestartStrategyConfiguration(int maxFailureRate, Time failureInterval, Time delayBetweenAttemptsInterval) {
            this.maxFailureRate = maxFailureRate;
            this.failureInterval = failureInterval;
            this.delayBetweenAttemptsInterval = delayBetweenAttemptsInterval;
        }

        public int getMaxFailureRate() {
            return this.maxFailureRate;
        }

        public Time getFailureInterval() {
            return this.failureInterval;
        }

        public Time getDelayBetweenAttemptsInterval() {
            return this.delayBetweenAttemptsInterval;
        }

        @Override
        public String getDescription() {
            return String.format("Failure rate restart with maximum of %d failures within interval %s and fixed delay %s.", this.maxFailureRate, this.failureInterval.toString(), this.delayBetweenAttemptsInterval.toString());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FailureRateRestartStrategyConfiguration that = (FailureRateRestartStrategyConfiguration)o;
            return this.maxFailureRate == that.maxFailureRate && Objects.equals(this.failureInterval, that.failureInterval) && Objects.equals(this.delayBetweenAttemptsInterval, that.delayBetweenAttemptsInterval);
        }

        public int hashCode() {
            return Objects.hash(this.maxFailureRate, this.failureInterval, this.delayBetweenAttemptsInterval);
        }
    }

    public static final class FixedDelayRestartStrategyConfiguration
    extends RestartStrategyConfiguration {
        private static final long serialVersionUID = 4149870149673363190L;
        private final int restartAttempts;
        private final Time delayBetweenAttemptsInterval;

        FixedDelayRestartStrategyConfiguration(int restartAttempts, Time delayBetweenAttemptsInterval) {
            this.restartAttempts = restartAttempts;
            this.delayBetweenAttemptsInterval = delayBetweenAttemptsInterval;
        }

        public int getRestartAttempts() {
            return this.restartAttempts;
        }

        public Time getDelayBetweenAttemptsInterval() {
            return this.delayBetweenAttemptsInterval;
        }

        public int hashCode() {
            int result = this.restartAttempts;
            result = 31 * result + (this.delayBetweenAttemptsInterval != null ? this.delayBetweenAttemptsInterval.hashCode() : 0);
            return result;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FixedDelayRestartStrategyConfiguration) {
                FixedDelayRestartStrategyConfiguration other = (FixedDelayRestartStrategyConfiguration)obj;
                return this.restartAttempts == other.restartAttempts && this.delayBetweenAttemptsInterval.equals(other.delayBetweenAttemptsInterval);
            }
            return false;
        }

        @Override
        public String getDescription() {
            return String.format("Restart with fixed delay (%s). #%d restart attempts.", this.delayBetweenAttemptsInterval, this.restartAttempts);
        }
    }

    public static final class NoRestartStrategyConfiguration
    extends RestartStrategyConfiguration {
        private static final long serialVersionUID = -5894362702943349962L;

        @Override
        public String getDescription() {
            return "Restart deactivated.";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof NoRestartStrategyConfiguration;
        }

        public int hashCode() {
            return Objects.hash(new Object[0]);
        }
    }

    public static abstract class RestartStrategyConfiguration
    implements Serializable {
        private static final long serialVersionUID = 6285853591578313960L;

        private RestartStrategyConfiguration() {
        }

        public abstract String getDescription();

        public String toString() {
            return this.getDescription();
        }
    }
}

