/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.client.deployment.application.ApplicationDispatcherBootstrap;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.dispatcher.Dispatcher;
import org.apache.flink.runtime.dispatcher.DispatcherBootstrap;
import org.apache.flink.runtime.dispatcher.DispatcherFactory;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.dispatcher.PartialDispatcherServices;
import org.apache.flink.runtime.dispatcher.PartialDispatcherServicesWithJobGraphStore;
import org.apache.flink.runtime.dispatcher.runner.AbstractDispatcherLeaderProcess;
import org.apache.flink.runtime.dispatcher.runner.DefaultDispatcherGatewayService;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.JobGraphWriter;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;

@Internal
public class ApplicationDispatcherGatewayServiceFactory
implements AbstractDispatcherLeaderProcess.DispatcherGatewayServiceFactory {
    private final Configuration configuration;
    private final DispatcherFactory dispatcherFactory;
    private final PackagedProgram application;
    private final RpcService rpcService;
    private final PartialDispatcherServices partialDispatcherServices;

    public ApplicationDispatcherGatewayServiceFactory(Configuration configuration, DispatcherFactory dispatcherFactory, PackagedProgram application, RpcService rpcService, PartialDispatcherServices partialDispatcherServices) {
        this.configuration = configuration;
        this.dispatcherFactory = dispatcherFactory;
        this.application = (PackagedProgram)Preconditions.checkNotNull((Object)application);
        this.rpcService = rpcService;
        this.partialDispatcherServices = partialDispatcherServices;
    }

    public AbstractDispatcherLeaderProcess.DispatcherGatewayService create(DispatcherId fencingToken, Collection<JobGraph> recoveredJobs, JobGraphWriter jobGraphWriter) {
        Dispatcher dispatcher;
        ApplicationDispatcherBootstrap bootstrap = new ApplicationDispatcherBootstrap(this.application, recoveredJobs, this.configuration);
        try {
            dispatcher = this.dispatcherFactory.createDispatcher(this.rpcService, fencingToken, (DispatcherBootstrap)bootstrap, PartialDispatcherServicesWithJobGraphStore.from((PartialDispatcherServices)this.partialDispatcherServices, (JobGraphWriter)jobGraphWriter));
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Could not create the Dispatcher rpc endpoint.", (Throwable)e);
        }
        dispatcher.start();
        return DefaultDispatcherGatewayService.from((Dispatcher)dispatcher);
    }
}

