/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Comparator;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.clock.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CheckpointRequestDecider {
    private static final Logger LOG = LoggerFactory.getLogger(CheckpointRequestDecider.class);
    private static final int LOG_TIME_IN_QUEUE_THRESHOLD_MS = 100;
    private static final int DEFAULT_MAX_QUEUED_REQUESTS = 1000;
    private final int maxConcurrentCheckpointAttempts;
    private final Consumer<Long> rescheduleTrigger;
    private final Clock clock;
    private final long minPauseBetweenCheckpoints;
    private final Supplier<Integer> pendingCheckpointsSizeSupplier;
    private final Object lock;
    @GuardedBy(value="lock")
    private final NavigableSet<CheckpointCoordinator.CheckpointTriggerRequest> queuedRequests = new TreeSet<CheckpointCoordinator.CheckpointTriggerRequest>(CheckpointRequestDecider.checkpointTriggerRequestsComparator());
    private final int maxQueuedRequests;

    CheckpointRequestDecider(int maxConcurrentCheckpointAttempts, Consumer<Long> rescheduleTrigger, Clock clock, long minPauseBetweenCheckpoints, Supplier<Integer> pendingCheckpointsSizeSupplier, Object lock) {
        this(maxConcurrentCheckpointAttempts, rescheduleTrigger, clock, minPauseBetweenCheckpoints, pendingCheckpointsSizeSupplier, lock, 1000);
    }

    CheckpointRequestDecider(int maxConcurrentCheckpointAttempts, Consumer<Long> rescheduleTrigger, Clock clock, long minPauseBetweenCheckpoints, Supplier<Integer> pendingCheckpointsSizeSupplier, Object lock, int maxQueuedRequests) {
        Preconditions.checkArgument((maxConcurrentCheckpointAttempts > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxQueuedRequests > 0 ? 1 : 0) != 0);
        this.maxConcurrentCheckpointAttempts = maxConcurrentCheckpointAttempts;
        this.rescheduleTrigger = rescheduleTrigger;
        this.clock = clock;
        this.minPauseBetweenCheckpoints = minPauseBetweenCheckpoints;
        this.pendingCheckpointsSizeSupplier = pendingCheckpointsSizeSupplier;
        this.lock = lock;
        this.maxQueuedRequests = maxQueuedRequests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<CheckpointCoordinator.CheckpointTriggerRequest> chooseRequestToExecute(CheckpointCoordinator.CheckpointTriggerRequest newRequest, boolean isTriggering, long lastCompletionMs) {
        Object object = this.lock;
        synchronized (object) {
            if (this.queuedRequests.size() >= this.maxQueuedRequests && !((CheckpointCoordinator.CheckpointTriggerRequest)this.queuedRequests.last()).isPeriodic) {
                newRequest.completeExceptionally(new CheckpointException(CheckpointFailureReason.TOO_MANY_CHECKPOINT_REQUESTS));
                return Optional.empty();
            }
            this.queuedRequests.add(newRequest);
            if (this.queuedRequests.size() > this.maxQueuedRequests) {
                this.queuedRequests.pollLast().completeExceptionally(new CheckpointException(CheckpointFailureReason.TOO_MANY_CHECKPOINT_REQUESTS));
            }
            Optional<CheckpointCoordinator.CheckpointTriggerRequest> request = this.chooseRequestToExecute(isTriggering, lastCompletionMs);
            request.ifPresent(CheckpointRequestDecider::logInQueueTime);
            return request;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<CheckpointCoordinator.CheckpointTriggerRequest> chooseQueuedRequestToExecute(boolean isTriggering, long lastCompletionMs) {
        Object object = this.lock;
        synchronized (object) {
            Optional<CheckpointCoordinator.CheckpointTriggerRequest> request = this.chooseRequestToExecute(isTriggering, lastCompletionMs);
            request.ifPresent(CheckpointRequestDecider::logInQueueTime);
            return request;
        }
    }

    private Optional<CheckpointCoordinator.CheckpointTriggerRequest> chooseRequestToExecute(boolean isTriggering, long lastCompletionMs) {
        Preconditions.checkState((boolean)Thread.holdsLock(this.lock));
        if (isTriggering || this.queuedRequests.isEmpty()) {
            return Optional.empty();
        }
        if (this.pendingCheckpointsSizeSupplier.get() >= this.maxConcurrentCheckpointAttempts) {
            return Optional.of(this.queuedRequests.first()).filter(CheckpointCoordinator.CheckpointTriggerRequest::isForce).map(unused -> this.queuedRequests.pollFirst());
        }
        long nextTriggerDelayMillis = this.nextTriggerDelayMillis(lastCompletionMs);
        if (nextTriggerDelayMillis > 0L) {
            return this.onTooEarly(nextTriggerDelayMillis);
        }
        return Optional.of(this.queuedRequests.pollFirst());
    }

    private Optional<CheckpointCoordinator.CheckpointTriggerRequest> onTooEarly(long nextTriggerDelayMillis) {
        CheckpointCoordinator.CheckpointTriggerRequest first = (CheckpointCoordinator.CheckpointTriggerRequest)this.queuedRequests.first();
        if (first.isForce()) {
            return Optional.of(this.queuedRequests.pollFirst());
        }
        if (first.isPeriodic) {
            this.queuedRequests.pollFirst().completeExceptionally(new CheckpointException(CheckpointFailureReason.MINIMUM_TIME_BETWEEN_CHECKPOINTS));
            this.rescheduleTrigger.accept(nextTriggerDelayMillis);
            return Optional.empty();
        }
        return Optional.empty();
    }

    private long nextTriggerDelayMillis(long lastCheckpointCompletionRelativeTime) {
        return lastCheckpointCompletionRelativeTime - this.clock.relativeTimeMillis() + this.minPauseBetweenCheckpoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @VisibleForTesting
    PriorityQueue<CheckpointCoordinator.CheckpointTriggerRequest> getTriggerRequestQueue() {
        Object object = this.lock;
        synchronized (object) {
            return new PriorityQueue<CheckpointCoordinator.CheckpointTriggerRequest>((SortedSet<CheckpointCoordinator.CheckpointTriggerRequest>)this.queuedRequests);
        }
    }

    void abortAll(CheckpointException exception) {
        Preconditions.checkState((boolean)Thread.holdsLock(this.lock));
        while (!this.queuedRequests.isEmpty()) {
            this.queuedRequests.pollFirst().completeExceptionally(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumQueuedRequests() {
        Object object = this.lock;
        synchronized (object) {
            return this.queuedRequests.size();
        }
    }

    private static Comparator<CheckpointCoordinator.CheckpointTriggerRequest> checkpointTriggerRequestsComparator() {
        return (r1, r2) -> {
            if (r1.props.isSavepoint() != r2.props.isSavepoint()) {
                return r1.props.isSavepoint() ? -1 : 1;
            }
            if (r1.isForce() != r2.isForce()) {
                return r1.isForce() ? -1 : 1;
            }
            if (r1.isPeriodic != r2.isPeriodic) {
                return r1.isPeriodic ? 1 : -1;
            }
            if (r1.timestamp != r2.timestamp) {
                return Long.compare(r1.timestamp, r2.timestamp);
            }
            return Integer.compare(System.identityHashCode(r1), System.identityHashCode(r2));
        };
    }

    private static void logInQueueTime(CheckpointCoordinator.CheckpointTriggerRequest request) {
        long timeInQueue;
        if (LOG.isInfoEnabled() && (timeInQueue = request.timestamp - System.currentTimeMillis()) > 100L) {
            LOG.info("checkpoint request time in queue: {}", (Object)timeInQueue);
        }
    }
}

