/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher.runner;

import java.util.Collection;
import org.apache.flink.runtime.dispatcher.DefaultDispatcherBootstrap;
import org.apache.flink.runtime.dispatcher.Dispatcher;
import org.apache.flink.runtime.dispatcher.DispatcherFactory;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.dispatcher.PartialDispatcherServices;
import org.apache.flink.runtime.dispatcher.PartialDispatcherServicesWithJobGraphStore;
import org.apache.flink.runtime.dispatcher.runner.AbstractDispatcherLeaderProcess;
import org.apache.flink.runtime.dispatcher.runner.DefaultDispatcherGatewayService;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.JobGraphWriter;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.util.FlinkRuntimeException;

class DefaultDispatcherGatewayServiceFactory
implements AbstractDispatcherLeaderProcess.DispatcherGatewayServiceFactory {
    private final DispatcherFactory dispatcherFactory;
    private final RpcService rpcService;
    private final PartialDispatcherServices partialDispatcherServices;

    DefaultDispatcherGatewayServiceFactory(DispatcherFactory dispatcherFactory, RpcService rpcService, PartialDispatcherServices partialDispatcherServices) {
        this.dispatcherFactory = dispatcherFactory;
        this.rpcService = rpcService;
        this.partialDispatcherServices = partialDispatcherServices;
    }

    @Override
    public AbstractDispatcherLeaderProcess.DispatcherGatewayService create(DispatcherId fencingToken, Collection<JobGraph> recoveredJobs, JobGraphWriter jobGraphWriter) {
        Dispatcher dispatcher;
        DefaultDispatcherBootstrap bootstrap = new DefaultDispatcherBootstrap(recoveredJobs);
        try {
            dispatcher = this.dispatcherFactory.createDispatcher(this.rpcService, fencingToken, bootstrap, PartialDispatcherServicesWithJobGraphStore.from(this.partialDispatcherServices, jobGraphWriter));
        }
        catch (Exception e) {
            throw new FlinkRuntimeException("Could not create the Dispatcher rpc endpoint.", (Throwable)e);
        }
        dispatcher.start();
        return DefaultDispatcherGatewayService.from(dispatcher);
    }
}

