/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.api.serialization;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import java.util.Random;
import org.apache.flink.core.fs.RefCountedFile;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataInputViewStreamWrapper;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.disk.FileBasedBufferIterator;
import org.apache.flink.runtime.io.network.api.serialization.NonSpanningWrapper;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.util.CloseableIterator;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.IOUtils;
import org.apache.flink.util.StringUtils;

final class SpanningWrapper {
    private static final int DEFAULT_THRESHOLD_FOR_SPILLING = 0x500000;
    private static final int DEFAULT_FILE_BUFFER_SIZE = 0x200000;
    private final byte[] initialBuffer = new byte[1024];
    private final String[] tempDirs;
    private final Random rnd = new Random();
    private final DataInputDeserializer serializationReadBuffer;
    final ByteBuffer lengthBuffer;
    private final int fileBufferSize;
    private FileChannel spillingChannel;
    private byte[] buffer;
    private int recordLength;
    private int accumulatedRecordBytes;
    private MemorySegment leftOverData;
    private int leftOverStart;
    private int leftOverLimit;
    private RefCountedFile spillFile;
    private DataInputViewStreamWrapper spillFileReader;
    private int thresholdForSpilling;

    SpanningWrapper(String[] tempDirs) {
        this(tempDirs, 0x500000, 0x200000);
    }

    SpanningWrapper(String[] tempDirectories, int threshold, int fileBufferSize) {
        this.tempDirs = tempDirectories;
        this.lengthBuffer = ByteBuffer.allocate(4);
        this.lengthBuffer.order(ByteOrder.BIG_ENDIAN);
        this.recordLength = -1;
        this.serializationReadBuffer = new DataInputDeserializer();
        this.buffer = this.initialBuffer;
        this.thresholdForSpilling = threshold;
        this.fileBufferSize = fileBufferSize;
    }

    void transferFrom(NonSpanningWrapper partial, int nextRecordLength) throws IOException {
        this.updateLength(nextRecordLength);
        this.accumulatedRecordBytes = this.isAboveSpillingThreshold() ? this.spill(partial) : partial.copyContentTo(this.buffer);
        partial.clear();
    }

    private boolean isAboveSpillingThreshold() {
        return this.recordLength > this.thresholdForSpilling;
    }

    void addNextChunkFromMemorySegment(MemorySegment segment, int offset, int numBytes) throws IOException {
        int limit = offset + numBytes;
        int numBytesRead = this.isReadingLength() ? this.readLength(segment, offset, numBytes) : 0;
        offset += numBytesRead;
        if ((numBytes -= numBytesRead) == 0) {
            return;
        }
        int toCopy = Math.min(this.recordLength - this.accumulatedRecordBytes, numBytes);
        if (toCopy > 0) {
            this.copyFromSegment(segment, offset, toCopy);
        }
        if (numBytes > toCopy) {
            this.leftOverData = segment;
            this.leftOverStart = offset + toCopy;
            this.leftOverLimit = limit;
        }
    }

    private void copyFromSegment(MemorySegment segment, int offset, int length) throws IOException {
        if (this.spillingChannel == null) {
            this.copyIntoBuffer(segment, offset, length);
        } else {
            this.copyIntoFile(segment, offset, length);
        }
    }

    private void copyIntoFile(MemorySegment segment, int offset, int length) throws IOException {
        FileUtils.writeCompletely((WritableByteChannel)this.spillingChannel, (ByteBuffer)segment.wrap(offset, length));
        this.accumulatedRecordBytes += length;
        if (this.hasFullRecord()) {
            this.spillingChannel.close();
            this.spillFileReader = new DataInputViewStreamWrapper((InputStream)new BufferedInputStream(new FileInputStream(this.spillFile.getFile()), this.fileBufferSize));
        }
    }

    private void copyIntoBuffer(MemorySegment segment, int offset, int length) {
        segment.get(offset, this.buffer, this.accumulatedRecordBytes, length);
        this.accumulatedRecordBytes += length;
        if (this.hasFullRecord()) {
            this.serializationReadBuffer.setBuffer(this.buffer, 0, this.recordLength);
        }
    }

    private int readLength(MemorySegment segment, int segmentPosition, int segmentRemaining) throws IOException {
        int bytesToRead = Math.min(this.lengthBuffer.remaining(), segmentRemaining);
        segment.get(segmentPosition, this.lengthBuffer, bytesToRead);
        if (!this.lengthBuffer.hasRemaining()) {
            this.updateLength(this.lengthBuffer.getInt(0));
        }
        return bytesToRead;
    }

    private void updateLength(int length) throws IOException {
        this.lengthBuffer.clear();
        this.recordLength = length;
        if (this.isAboveSpillingThreshold()) {
            this.spillingChannel = this.createSpillingChannel();
        } else {
            this.ensureBufferCapacity(length);
        }
    }

    CloseableIterator<Buffer> getUnconsumedSegment() throws IOException {
        if (this.isReadingLength()) {
            return NonSpanningWrapper.singleBufferIterator(MemorySegmentFactory.wrapCopy((byte[])this.lengthBuffer.array(), (int)0, (int)this.lengthBuffer.position()));
        }
        if (this.isAboveSpillingThreshold()) {
            return this.createSpilledDataIterator();
        }
        if (this.recordLength == -1) {
            return CloseableIterator.empty();
        }
        return NonSpanningWrapper.singleBufferIterator(this.copyDataBuffer());
    }

    private CloseableIterator<Buffer> createSpilledDataIterator() throws IOException {
        if (this.spillingChannel != null && this.spillingChannel.isOpen()) {
            this.spillingChannel.force(false);
        }
        return CloseableIterator.flatten((CloseableIterator[])new CloseableIterator[]{SpanningWrapper.toSingleBufferIterator(MemorySegmentFactory.wrapInt((int)this.recordLength)), new FileBasedBufferIterator(this.spillFile, Math.min(this.accumulatedRecordBytes, this.recordLength), this.fileBufferSize), this.leftOverData == null ? CloseableIterator.empty() : SpanningWrapper.toSingleBufferIterator(MemorySegmentFactory.wrapCopy((byte[])this.leftOverData.getArray(), (int)this.leftOverStart, (int)this.leftOverLimit))});
    }

    private MemorySegment copyDataBuffer() throws IOException {
        int leftOverSize = this.leftOverLimit - this.leftOverStart;
        int unconsumedSize = 4 + this.accumulatedRecordBytes + leftOverSize;
        DataOutputSerializer serializer = new DataOutputSerializer(unconsumedSize);
        serializer.writeInt(this.recordLength);
        serializer.write(this.buffer, 0, this.accumulatedRecordBytes);
        if (this.leftOverData != null) {
            serializer.write(this.leftOverData, this.leftOverStart, leftOverSize);
        }
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)unconsumedSize);
        segment.put(0, serializer.getSharedBuffer(), 0, segment.size());
        return segment;
    }

    void transferLeftOverTo(NonSpanningWrapper nonSpanningWrapper) {
        nonSpanningWrapper.clear();
        if (this.leftOverData != null) {
            nonSpanningWrapper.initializeFromMemorySegment(this.leftOverData, this.leftOverStart, this.leftOverLimit);
        }
        this.clear();
    }

    boolean hasFullRecord() {
        return this.recordLength >= 0 && this.accumulatedRecordBytes >= this.recordLength;
    }

    int getNumGatheredBytes() {
        return this.accumulatedRecordBytes + (this.recordLength >= 0 ? 4 : this.lengthBuffer.position());
    }

    public void clear() {
        this.buffer = this.initialBuffer;
        this.serializationReadBuffer.releaseArrays();
        this.recordLength = -1;
        this.lengthBuffer.clear();
        this.leftOverData = null;
        this.leftOverStart = 0;
        this.leftOverLimit = 0;
        this.accumulatedRecordBytes = 0;
        if (this.spillingChannel != null) {
            IOUtils.closeQuietly((AutoCloseable)this.spillingChannel);
        }
        if (this.spillFileReader != null) {
            IOUtils.closeQuietly((AutoCloseable)this.spillFileReader);
        }
        if (this.spillFile != null) {
            IOUtils.closeQuietly(() -> this.spillFile.release());
        }
        this.spillingChannel = null;
        this.spillFileReader = null;
        this.spillFile = null;
    }

    public DataInputView getInputView() {
        return this.spillFileReader == null ? this.serializationReadBuffer : this.spillFileReader;
    }

    private void ensureBufferCapacity(int minLength) {
        if (this.buffer.length < minLength) {
            byte[] newBuffer = new byte[Math.max(minLength, this.buffer.length * 2)];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.accumulatedRecordBytes);
            this.buffer = newBuffer;
        }
    }

    private FileChannel createSpillingChannel() throws IOException {
        if (this.spillFile != null) {
            throw new IllegalStateException("Spilling file already exists.");
        }
        int maxAttempts = 10;
        for (int attempt = 0; attempt < maxAttempts; ++attempt) {
            String directory = this.tempDirs[this.rnd.nextInt(this.tempDirs.length)];
            File file = new File(directory, SpanningWrapper.randomString(this.rnd) + ".inputchannel");
            if (!file.createNewFile()) continue;
            this.spillFile = new RefCountedFile(file);
            return new RandomAccessFile(file, "rw").getChannel();
        }
        throw new IOException("Could not find a unique file channel name in '" + Arrays.toString(this.tempDirs) + "' for spilling large records during deserialization.");
    }

    private static String randomString(Random random) {
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        return StringUtils.byteToHexString((byte[])bytes);
    }

    private int spill(NonSpanningWrapper partial) throws IOException {
        ByteBuffer buffer = partial.wrapIntoByteBuffer();
        int length = buffer.remaining();
        FileUtils.writeCompletely((WritableByteChannel)this.spillingChannel, (ByteBuffer)buffer);
        return length;
    }

    private boolean isReadingLength() {
        return this.lengthBuffer.position() > 0;
    }

    private static CloseableIterator<Buffer> toSingleBufferIterator(MemorySegment segment) {
        NetworkBuffer buffer = new NetworkBuffer(segment, FreeingBufferRecycler.INSTANCE, Buffer.DataType.DATA_BUFFER, segment.size());
        return CloseableIterator.ofElement((Object)buffer, Buffer::recycleBuffer);
    }
}

