/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.functions.sink.filesystem;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.state.ListState;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.io.SimpleVersionedSerialization;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.api.functions.sink.filesystem.Bucket;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketAssigner;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketFactory;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketLifeCycleListener;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketState;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketStateSerializer;
import org.apache.flink.streaming.api.functions.sink.filesystem.BucketWriter;
import org.apache.flink.streaming.api.functions.sink.filesystem.OutputFileConfig;
import org.apache.flink.streaming.api.functions.sink.filesystem.RollingPolicy;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class Buckets<IN, BucketID> {
    private static final Logger LOG = LoggerFactory.getLogger(Buckets.class);
    private final Path basePath;
    private final BucketFactory<IN, BucketID> bucketFactory;
    private final BucketAssigner<IN, BucketID> bucketAssigner;
    private final BucketWriter<IN, BucketID> bucketWriter;
    private final RollingPolicy<IN, BucketID> rollingPolicy;
    private final int subtaskIndex;
    private final BucketerContext bucketerContext;
    private final Map<BucketID, Bucket<IN, BucketID>> activeBuckets;
    private long maxPartCounter;
    private final OutputFileConfig outputFileConfig;
    @Nullable
    private BucketLifeCycleListener<IN, BucketID> bucketLifeCycleListener;
    private final BucketStateSerializer<BucketID> bucketStateSerializer;

    Buckets(Path basePath, BucketAssigner<IN, BucketID> bucketAssigner, BucketFactory<IN, BucketID> bucketFactory, BucketWriter<IN, BucketID> bucketWriter, RollingPolicy<IN, BucketID> rollingPolicy, int subtaskIndex, OutputFileConfig outputFileConfig) {
        this.basePath = (Path)Preconditions.checkNotNull((Object)basePath);
        this.bucketAssigner = (BucketAssigner)Preconditions.checkNotNull(bucketAssigner);
        this.bucketFactory = (BucketFactory)Preconditions.checkNotNull(bucketFactory);
        this.bucketWriter = (BucketWriter)Preconditions.checkNotNull(bucketWriter);
        this.rollingPolicy = (RollingPolicy)Preconditions.checkNotNull(rollingPolicy);
        this.subtaskIndex = subtaskIndex;
        this.outputFileConfig = (OutputFileConfig)Preconditions.checkNotNull((Object)outputFileConfig);
        this.activeBuckets = new HashMap<BucketID, Bucket<IN, BucketID>>();
        this.bucketerContext = new BucketerContext();
        this.bucketStateSerializer = new BucketStateSerializer<BucketID>(bucketWriter.getProperties().getInProgressFileRecoverableSerializer(), bucketWriter.getProperties().getPendingFileRecoverableSerializer(), bucketAssigner.getSerializer());
        this.maxPartCounter = 0L;
    }

    public void setBucketLifeCycleListener(BucketLifeCycleListener<IN, BucketID> bucketLifeCycleListener) {
        this.bucketLifeCycleListener = (BucketLifeCycleListener)Preconditions.checkNotNull(bucketLifeCycleListener);
    }

    public void initializeState(ListState<byte[]> bucketStates, ListState<Long> partCounterState) throws Exception {
        this.initializePartCounter(partCounterState);
        LOG.info("Subtask {} initializing its state (max part counter={}).", (Object)this.subtaskIndex, (Object)this.maxPartCounter);
        this.initializeActiveBuckets(bucketStates);
    }

    private void initializePartCounter(ListState<Long> partCounterState) throws Exception {
        long maxCounter = 0L;
        Iterator iterator = ((Iterable)partCounterState.get()).iterator();
        while (iterator.hasNext()) {
            long partCounter = (Long)iterator.next();
            maxCounter = Math.max(partCounter, maxCounter);
        }
        this.maxPartCounter = maxCounter;
    }

    private void initializeActiveBuckets(ListState<byte[]> bucketStates) throws Exception {
        for (byte[] serializedRecoveredState : (Iterable)bucketStates.get()) {
            BucketState recoveredState = (BucketState)SimpleVersionedSerialization.readVersionAndDeSerialize(this.bucketStateSerializer, (byte[])serializedRecoveredState);
            this.handleRestoredBucketState(recoveredState);
        }
    }

    private void handleRestoredBucketState(BucketState<BucketID> recoveredState) throws Exception {
        BucketID bucketId = recoveredState.getBucketId();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Subtask {} restoring: {}", (Object)this.subtaskIndex, recoveredState);
        }
        Bucket<IN, BucketID> restoredBucket = this.bucketFactory.restoreBucket(this.subtaskIndex, this.maxPartCounter, this.bucketWriter, this.rollingPolicy, recoveredState, this.outputFileConfig);
        this.updateActiveBucketId(bucketId, restoredBucket);
    }

    private void updateActiveBucketId(BucketID bucketId, Bucket<IN, BucketID> restoredBucket) throws IOException {
        if (!restoredBucket.isActive()) {
            this.notifyBucketInactive(restoredBucket);
            return;
        }
        Bucket<IN, BucketID> bucket = this.activeBuckets.get(bucketId);
        if (bucket != null) {
            bucket.merge(restoredBucket);
        } else {
            this.activeBuckets.put(bucketId, restoredBucket);
        }
    }

    public void commitUpToCheckpoint(long checkpointId) throws IOException {
        Iterator<Map.Entry<BucketID, Bucket<IN, BucketID>>> activeBucketIt = this.activeBuckets.entrySet().iterator();
        LOG.info("Subtask {} received completion notification for checkpoint with id={}.", (Object)this.subtaskIndex, (Object)checkpointId);
        while (activeBucketIt.hasNext()) {
            Bucket<IN, BucketID> bucket = activeBucketIt.next().getValue();
            bucket.onSuccessfulCompletionOfCheckpoint(checkpointId);
            if (bucket.isActive()) continue;
            activeBucketIt.remove();
            this.notifyBucketInactive(bucket);
        }
    }

    public void snapshotState(long checkpointId, ListState<byte[]> bucketStatesContainer, ListState<Long> partCounterStateContainer) throws Exception {
        Preconditions.checkState((this.bucketWriter != null && this.bucketStateSerializer != null ? 1 : 0) != 0, (Object)"sink has not been initialized");
        LOG.info("Subtask {} checkpointing for checkpoint with id={} (max part counter={}).", new Object[]{this.subtaskIndex, checkpointId, this.maxPartCounter});
        bucketStatesContainer.clear();
        partCounterStateContainer.clear();
        this.snapshotActiveBuckets(checkpointId, bucketStatesContainer);
        partCounterStateContainer.add((Object)this.maxPartCounter);
    }

    private void snapshotActiveBuckets(long checkpointId, ListState<byte[]> bucketStatesContainer) throws Exception {
        for (Bucket<IN, BucketID> bucket : this.activeBuckets.values()) {
            BucketState<BucketID> bucketState = bucket.onReceptionOfCheckpoint(checkpointId);
            byte[] serializedBucketState = SimpleVersionedSerialization.writeVersionAndSerialize(this.bucketStateSerializer, bucketState);
            bucketStatesContainer.add((Object)serializedBucketState);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Subtask {} checkpointing: {}", (Object)this.subtaskIndex, bucketState);
        }
    }

    @VisibleForTesting
    public Bucket<IN, BucketID> onElement(IN value, SinkFunction.Context context) throws Exception {
        return this.onElement(value, context.currentProcessingTime(), context.timestamp(), context.currentWatermark());
    }

    public Bucket<IN, BucketID> onElement(IN value, long currentProcessingTime, @Nullable Long elementTimestamp, long currentWatermark) throws Exception {
        this.bucketerContext.update(elementTimestamp, currentWatermark, currentProcessingTime);
        BucketID bucketId = this.bucketAssigner.getBucketId(value, this.bucketerContext);
        Bucket<IN, BucketID> bucket = this.getOrCreateBucketForBucketId(bucketId);
        bucket.write(value, currentProcessingTime);
        this.maxPartCounter = Math.max(this.maxPartCounter, bucket.getPartCounter());
        return bucket;
    }

    private Bucket<IN, BucketID> getOrCreateBucketForBucketId(BucketID bucketId) throws IOException {
        Bucket<IN, BucketID> bucket = this.activeBuckets.get(bucketId);
        if (bucket == null) {
            Path bucketPath = this.assembleBucketPath(bucketId);
            bucket = this.bucketFactory.getNewBucket(this.subtaskIndex, bucketId, bucketPath, this.maxPartCounter, this.bucketWriter, this.rollingPolicy, this.outputFileConfig);
            this.activeBuckets.put(bucketId, bucket);
            this.notifyBucketCreate(bucket);
        }
        return bucket;
    }

    public void onProcessingTime(long timestamp) throws Exception {
        for (Bucket<IN, BucketID> bucket : this.activeBuckets.values()) {
            bucket.onProcessingTime(timestamp);
        }
    }

    public void close() {
        if (this.activeBuckets != null) {
            this.activeBuckets.values().forEach(Bucket::disposePartFile);
        }
    }

    private Path assembleBucketPath(BucketID bucketId) {
        String child = bucketId.toString();
        if ("".equals(child)) {
            return this.basePath;
        }
        return new Path(this.basePath, child);
    }

    private void notifyBucketCreate(Bucket<IN, BucketID> bucket) {
        if (this.bucketLifeCycleListener != null) {
            this.bucketLifeCycleListener.bucketCreated(bucket);
        }
    }

    private void notifyBucketInactive(Bucket<IN, BucketID> bucket) {
        if (this.bucketLifeCycleListener != null) {
            this.bucketLifeCycleListener.bucketInactive(bucket);
        }
    }

    @VisibleForTesting
    public long getMaxPartCounter() {
        return this.maxPartCounter;
    }

    @VisibleForTesting
    Map<BucketID, Bucket<IN, BucketID>> getActiveBuckets() {
        return this.activeBuckets;
    }

    private static final class BucketerContext
    implements BucketAssigner.Context {
        @Nullable
        private Long elementTimestamp = null;
        private long currentWatermark = Long.MIN_VALUE;
        private long currentProcessingTime = Long.MIN_VALUE;

        private BucketerContext() {
        }

        void update(@Nullable Long elementTimestamp, long watermark, long processingTime) {
            this.elementTimestamp = elementTimestamp;
            this.currentWatermark = watermark;
            this.currentProcessingTime = processingTime;
        }

        @Override
        public long currentProcessingTime() {
            return this.currentProcessingTime;
        }

        @Override
        public long currentWatermark() {
            return this.currentWatermark;
        }

        @Override
        @Nullable
        public Long timestamp() {
            return this.elementTimestamp;
        }
    }
}

