/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.graph.StreamNode;
import org.apache.flink.streaming.api.transformations.ShuffleMode;
import org.apache.flink.streaming.runtime.partitioner.StreamPartitioner;
import org.apache.flink.util.OutputTag;
import org.apache.flink.util.Preconditions;

@Internal
public class StreamEdge
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long ALWAYS_FLUSH_BUFFER_TIMEOUT = 0L;
    private final String edgeId;
    private final int sourceId;
    private final int targetId;
    private final int typeNumber;
    private final List<String> selectedNames;
    private final OutputTag outputTag;
    private StreamPartitioner<?> outputPartitioner;
    private final String sourceOperatorName;
    private final String targetOperatorName;
    private final ShuffleMode shuffleMode;
    private long bufferTimeout;

    public StreamEdge(StreamNode sourceVertex, StreamNode targetVertex, int typeNumber, List<String> selectedNames, StreamPartitioner<?> outputPartitioner, OutputTag outputTag) {
        this(sourceVertex, targetVertex, typeNumber, 0L, selectedNames, outputPartitioner, outputTag, ShuffleMode.UNDEFINED);
    }

    public StreamEdge(StreamNode sourceVertex, StreamNode targetVertex, int typeNumber, List<String> selectedNames, StreamPartitioner<?> outputPartitioner, OutputTag outputTag, ShuffleMode shuffleMode) {
        this(sourceVertex, targetVertex, typeNumber, sourceVertex.getBufferTimeout(), selectedNames, outputPartitioner, outputTag, shuffleMode);
    }

    public StreamEdge(StreamNode sourceVertex, StreamNode targetVertex, int typeNumber, long bufferTimeout, List<String> selectedNames, StreamPartitioner<?> outputPartitioner, OutputTag outputTag, ShuffleMode shuffleMode) {
        this.sourceId = sourceVertex.getId();
        this.targetId = targetVertex.getId();
        this.typeNumber = typeNumber;
        this.bufferTimeout = bufferTimeout;
        this.selectedNames = selectedNames;
        this.outputPartitioner = outputPartitioner;
        this.outputTag = outputTag;
        this.sourceOperatorName = sourceVertex.getOperatorName();
        this.targetOperatorName = targetVertex.getOperatorName();
        this.shuffleMode = (ShuffleMode)((Object)Preconditions.checkNotNull((Object)((Object)shuffleMode)));
        this.edgeId = sourceVertex + "_" + targetVertex + "_" + typeNumber + "_" + selectedNames + "_" + outputPartitioner;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public int getTypeNumber() {
        return this.typeNumber;
    }

    public List<String> getSelectedNames() {
        return this.selectedNames;
    }

    public OutputTag getOutputTag() {
        return this.outputTag;
    }

    public StreamPartitioner<?> getPartitioner() {
        return this.outputPartitioner;
    }

    public ShuffleMode getShuffleMode() {
        return this.shuffleMode;
    }

    public void setPartitioner(StreamPartitioner<?> partitioner) {
        this.outputPartitioner = partitioner;
    }

    public void setBufferTimeout(long bufferTimeout) {
        Preconditions.checkArgument((bufferTimeout >= -1L ? 1 : 0) != 0);
        this.bufferTimeout = bufferTimeout;
    }

    public long getBufferTimeout() {
        return this.bufferTimeout;
    }

    public int hashCode() {
        return Objects.hash(this.edgeId, this.outputTag);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamEdge that = (StreamEdge)o;
        return Objects.equals(this.edgeId, that.edgeId) && Objects.equals(this.outputTag, that.outputTag);
    }

    public String toString() {
        return "(" + this.sourceOperatorName + "-" + this.sourceId + " -> " + this.targetOperatorName + "-" + this.targetId + ", typeNumber=" + this.typeNumber + ", selectedNames=" + this.selectedNames + ", outputPartitioner=" + this.outputPartitioner + ", bufferTimeout=" + this.bufferTimeout + ", outputTag=" + this.outputTag + ')';
    }
}

