/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.application;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.client.ClientUtils;
import org.apache.flink.client.cli.ClientOptions;
import org.apache.flink.client.deployment.application.ApplicationExecutionException;
import org.apache.flink.client.deployment.application.JobStatusPollingUtils;
import org.apache.flink.client.deployment.application.executors.EmbeddedExecutorServiceLoader;
import org.apache.flink.client.program.PackagedProgram;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.PipelineOptionsInternal;
import org.apache.flink.runtime.client.JobCancellationException;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.concurrent.ScheduledExecutor;
import org.apache.flink.runtime.dispatcher.AbstractDispatcherBootstrap;
import org.apache.flink.runtime.dispatcher.Dispatcher;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobmanager.HighAvailabilityMode;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedThrowable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class ApplicationDispatcherBootstrap
extends AbstractDispatcherBootstrap {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationDispatcherBootstrap.class);
    public static final JobID ZERO_JOB_ID = new JobID(0L, 0L);
    private final PackagedProgram application;
    private final Collection<JobGraph> recoveredJobs;
    private final Configuration configuration;
    private CompletableFuture<Void> applicationCompletionFuture;
    private ScheduledFuture<?> applicationExecutionTask;

    public ApplicationDispatcherBootstrap(PackagedProgram application, Collection<JobGraph> recoveredJobs, Configuration configuration) {
        this.configuration = (Configuration)Preconditions.checkNotNull((Object)configuration);
        this.recoveredJobs = (Collection)Preconditions.checkNotNull(recoveredJobs);
        this.application = (PackagedProgram)Preconditions.checkNotNull((Object)application);
    }

    public void initialize(Dispatcher dispatcher, ScheduledExecutor scheduledExecutor) {
        Preconditions.checkNotNull((Object)dispatcher);
        this.launchRecoveredJobGraphs(dispatcher, this.recoveredJobs);
        this.runApplicationAndShutdownClusterAsync((DispatcherGateway)dispatcher, scheduledExecutor);
    }

    public void stop() {
        if (this.applicationExecutionTask != null) {
            this.applicationExecutionTask.cancel(true);
        }
        if (this.applicationCompletionFuture != null) {
            this.applicationCompletionFuture.cancel(true);
        }
    }

    @VisibleForTesting
    ScheduledFuture<?> getApplicationExecutionFuture() {
        return this.applicationExecutionTask;
    }

    @VisibleForTesting
    CompletableFuture<Acknowledge> runApplicationAndShutdownClusterAsync(DispatcherGateway dispatcher, ScheduledExecutor scheduledExecutor) {
        this.applicationCompletionFuture = this.fixJobIdAndRunApplicationAsync(dispatcher, scheduledExecutor);
        return ((CompletableFuture)this.applicationCompletionFuture.handle((r, t) -> {
            ApplicationStatus applicationStatus;
            if (t != null) {
                Optional cancellationException = ExceptionUtils.findThrowable((Throwable)t, JobCancellationException.class);
                applicationStatus = cancellationException.isPresent() ? ApplicationStatus.CANCELED : (t instanceof CancellationException ? ApplicationStatus.UNKNOWN : ApplicationStatus.FAILED);
                LOG.warn("Application {}: ", (Object)applicationStatus, t);
            } else {
                applicationStatus = ApplicationStatus.SUCCEEDED;
                LOG.info("Application completed SUCCESSFULLY");
            }
            return dispatcher.shutDownCluster(applicationStatus);
        })).thenCompose(Function.identity());
    }

    @VisibleForTesting
    CompletableFuture<Void> fixJobIdAndRunApplicationAsync(DispatcherGateway dispatcher, ScheduledExecutor scheduledExecutor) {
        Optional configuredJobId = this.configuration.getOptional(PipelineOptionsInternal.PIPELINE_FIXED_JOB_ID);
        if (!HighAvailabilityMode.isHighAvailabilityModeActivated((Configuration)this.configuration) && !configuredJobId.isPresent()) {
            return this.runApplicationAsync(dispatcher, scheduledExecutor, false);
        }
        if (!configuredJobId.isPresent()) {
            this.configuration.set(PipelineOptionsInternal.PIPELINE_FIXED_JOB_ID, (Object)ZERO_JOB_ID.toHexString());
        }
        return this.runApplicationAsync(dispatcher, scheduledExecutor, true);
    }

    private CompletableFuture<Void> runApplicationAsync(DispatcherGateway dispatcher, ScheduledExecutor scheduledExecutor, boolean enforceSingleJobExecution) {
        CompletableFuture applicationExecutionFuture = new CompletableFuture();
        this.applicationExecutionTask = scheduledExecutor.schedule(() -> this.runApplicationEntryPoint(applicationExecutionFuture, dispatcher, scheduledExecutor, enforceSingleJobExecution), 0L, TimeUnit.MILLISECONDS);
        return applicationExecutionFuture.thenCompose(jobIds -> this.getApplicationResult(dispatcher, (Collection<JobID>)jobIds, scheduledExecutor));
    }

    private void runApplicationEntryPoint(CompletableFuture<List<JobID>> jobIdsFuture, DispatcherGateway dispatcher, ScheduledExecutor scheduledExecutor, boolean enforceSingleJobExecution) {
        try {
            ArrayList<JobID> applicationJobIds = new ArrayList<JobID>(this.getRecoveredJobIds(this.recoveredJobs));
            EmbeddedExecutorServiceLoader executorServiceLoader = new EmbeddedExecutorServiceLoader(applicationJobIds, dispatcher, scheduledExecutor);
            ClientUtils.executeProgram(executorServiceLoader, this.configuration, this.application, enforceSingleJobExecution, true);
            if (applicationJobIds.isEmpty()) {
                jobIdsFuture.completeExceptionally((Throwable)((Object)new ApplicationExecutionException("The application contains no execute() calls.")));
            } else {
                jobIdsFuture.complete(applicationJobIds);
            }
        }
        catch (Throwable t) {
            jobIdsFuture.completeExceptionally((Throwable)((Object)new ApplicationExecutionException("Could not execute application.", t)));
        }
    }

    private CompletableFuture<Void> getApplicationResult(DispatcherGateway dispatcherGateway, Collection<JobID> applicationJobIds, ScheduledExecutor executor) {
        List jobResultFutures = applicationJobIds.stream().map(jobId -> this.unwrapJobResultException(this.getJobResult(dispatcherGateway, (JobID)jobId, executor))).collect(Collectors.toList());
        return FutureUtils.waitForAll(jobResultFutures);
    }

    private CompletableFuture<JobResult> getJobResult(DispatcherGateway dispatcherGateway, JobID jobId, ScheduledExecutor scheduledExecutor) {
        Time timeout = Time.milliseconds((long)((Duration)this.configuration.get(ClientOptions.CLIENT_TIMEOUT)).toMillis());
        Time retryPeriod = Time.milliseconds((long)((Duration)this.configuration.get(ClientOptions.CLIENT_RETRY_PERIOD)).toMillis());
        return JobStatusPollingUtils.getJobResult(dispatcherGateway, jobId, scheduledExecutor, timeout, retryPeriod);
    }

    private CompletableFuture<JobResult> unwrapJobResultException(CompletableFuture<JobResult> jobResult) {
        return jobResult.thenApply(result -> {
            if (result.isSuccess()) {
                return result;
            }
            Optional serializedThrowable = result.getSerializedThrowable();
            if (result.getApplicationStatus() == ApplicationStatus.CANCELED) {
                throw new CompletionException((Throwable)new JobCancellationException(result.getJobId(), "Job was cancelled.", (Throwable)serializedThrowable.orElse(null)));
            }
            if (serializedThrowable.isPresent()) {
                Throwable throwable = ((SerializedThrowable)serializedThrowable.get()).deserializeError(this.application.getUserCodeClassLoader());
                throw new CompletionException(throwable);
            }
            throw new RuntimeException("Job execution failed for unknown reason.");
        });
    }

    private List<JobID> getRecoveredJobIds(Collection<JobGraph> recoveredJobs) {
        return recoveredJobs.stream().map(JobGraph::getJobID).collect(Collectors.toList());
    }
}

