/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.client.deployment.executors;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.client.cli.ExecutionConfigAccessor;
import org.apache.flink.client.deployment.ClusterClientFactory;
import org.apache.flink.client.deployment.ClusterClientJobClientAdapter;
import org.apache.flink.client.deployment.ClusterDescriptor;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.deployment.executors.PipelineExecutorUtils;
import org.apache.flink.client.program.ClusterClientProvider;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.PipelineExecutor;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class AbstractJobClusterExecutor<ClusterID, ClientFactory extends ClusterClientFactory<ClusterID>>
implements PipelineExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJobClusterExecutor.class);
    private final ClientFactory clusterClientFactory;

    public AbstractJobClusterExecutor(@Nonnull ClientFactory clusterClientFactory) {
        this.clusterClientFactory = (ClusterClientFactory)Preconditions.checkNotNull(clusterClientFactory);
    }

    public CompletableFuture<JobClient> execute(@Nonnull Pipeline pipeline, @Nonnull Configuration configuration) throws Exception {
        JobGraph jobGraph = PipelineExecutorUtils.getJobGraph(pipeline, configuration);
        try (ClusterDescriptor clusterDescriptor = this.clusterClientFactory.createClusterDescriptor(configuration);){
            ExecutionConfigAccessor configAccessor = ExecutionConfigAccessor.fromConfiguration(configuration);
            ClusterSpecification clusterSpecification = this.clusterClientFactory.getClusterSpecification(configuration);
            ClusterClientProvider clusterClientProvider = clusterDescriptor.deployJobCluster(clusterSpecification, jobGraph, configAccessor.getDetachedMode());
            LOG.info("Job has been submitted with JobID " + jobGraph.getJobID());
            CompletableFuture<JobClient> completableFuture = CompletableFuture.completedFuture(new ClusterClientJobClientAdapter(clusterClientProvider, jobGraph.getJobID()));
            return completableFuture;
        }
    }
}

