/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import java.util.Collections;
import java.util.Set;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.util.Preconditions;

public class FailureHandlingResult {
    private final Set<ExecutionVertexID> verticesToRestart;
    private final long restartDelayMS;
    private final Throwable error;
    private final boolean globalFailure;

    private FailureHandlingResult(Set<ExecutionVertexID> verticesToRestart, long restartDelayMS, boolean globalFailure) {
        Preconditions.checkState((restartDelayMS >= 0L ? 1 : 0) != 0);
        this.verticesToRestart = Collections.unmodifiableSet((Set)Preconditions.checkNotNull(verticesToRestart));
        this.restartDelayMS = restartDelayMS;
        this.error = null;
        this.globalFailure = globalFailure;
    }

    private FailureHandlingResult(Throwable error, boolean globalFailure) {
        this.verticesToRestart = null;
        this.restartDelayMS = -1L;
        this.error = (Throwable)Preconditions.checkNotNull((Object)error);
        this.globalFailure = globalFailure;
    }

    public Set<ExecutionVertexID> getVerticesToRestart() {
        if (this.canRestart()) {
            return this.verticesToRestart;
        }
        throw new IllegalStateException("Cannot get vertices to restart when the restarting is suppressed.");
    }

    public long getRestartDelayMS() {
        if (this.canRestart()) {
            return this.restartDelayMS;
        }
        throw new IllegalStateException("Cannot get restart delay when the restarting is suppressed.");
    }

    public Throwable getError() {
        if (this.canRestart()) {
            throw new IllegalStateException("Cannot get error when the restarting is accepted.");
        }
        return this.error;
    }

    public boolean canRestart() {
        return this.error == null;
    }

    public boolean isGlobalFailure() {
        return this.globalFailure;
    }

    public static FailureHandlingResult restartable(Set<ExecutionVertexID> verticesToRestart, long restartDelayMS, boolean globalFailure) {
        return new FailureHandlingResult(verticesToRestart, restartDelayMS, globalFailure);
    }

    public static FailureHandlingResult unrecoverable(Throwable error, boolean globalFailure) {
        return new FailureHandlingResult(error, globalFailure);
    }
}

