/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmanager.scheduler;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.apache.flink.api.common.operators.ResourceSpec;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.util.Preconditions;

public class SlotSharingGroup
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Set<JobVertexID> ids = new TreeSet<JobVertexID>();
    private final SlotSharingGroupId slotSharingGroupId = new SlotSharingGroupId();
    private ResourceSpec resourceSpec = ResourceSpec.ZERO;

    public void addVertexToGroup(JobVertexID id, ResourceSpec resource) {
        this.ids.add((JobVertexID)Preconditions.checkNotNull((Object)id));
        this.resourceSpec = this.resourceSpec.merge((ResourceSpec)Preconditions.checkNotNull((Object)resource));
    }

    public void removeVertexFromGroup(JobVertexID id, ResourceSpec resource) {
        this.ids.remove(Preconditions.checkNotNull((Object)id));
        this.resourceSpec = this.resourceSpec.subtract((ResourceSpec)Preconditions.checkNotNull((Object)resource));
    }

    public Set<JobVertexID> getJobVertexIds() {
        return Collections.unmodifiableSet(this.ids);
    }

    public SlotSharingGroupId getSlotSharingGroupId() {
        return this.slotSharingGroupId;
    }

    public ResourceSpec getResourceSpec() {
        return this.resourceSpec;
    }

    public String toString() {
        return "SlotSharingGroup " + this.ids.toString();
    }
}

