/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics;

import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.HistogramStatistics;
import org.apache.flink.runtime.metrics.DescriptiveStatisticsHistogramStatistics;

public class DescriptiveStatisticsHistogram
implements Histogram {
    private final CircularDoubleArray descriptiveStatistics;

    public DescriptiveStatisticsHistogram(int windowSize) {
        this.descriptiveStatistics = new CircularDoubleArray(windowSize);
    }

    public void update(long value) {
        this.descriptiveStatistics.addValue(value);
    }

    public long getCount() {
        return this.descriptiveStatistics.getElementsSeen();
    }

    public HistogramStatistics getStatistics() {
        return new DescriptiveStatisticsHistogramStatistics(this.descriptiveStatistics);
    }

    static class CircularDoubleArray {
        private final double[] backingArray;
        private int nextPos = 0;
        private boolean fullSize = false;
        private long elementsSeen = 0L;

        CircularDoubleArray(int windowSize) {
            this.backingArray = new double[windowSize];
        }

        synchronized void addValue(double value) {
            this.backingArray[this.nextPos] = value;
            ++this.elementsSeen;
            ++this.nextPos;
            if (this.nextPos == this.backingArray.length) {
                this.nextPos = 0;
                this.fullSize = true;
            }
        }

        synchronized double[] toUnsortedArray() {
            int size = this.getSize();
            double[] result = new double[size];
            System.arraycopy(this.backingArray, 0, result, 0, result.length);
            return result;
        }

        private synchronized int getSize() {
            return this.fullSize ? this.backingArray.length : this.nextPos;
        }

        private synchronized long getElementsSeen() {
            return this.elementsSeen;
        }
    }
}

