/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.MetricOptions;
import org.apache.flink.configuration.ResourceManagerOptions;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.util.Preconditions;

public class ConfigurationUtils {
    private static final String[] EMPTY = new String[0];

    public static Optional<Time> getSystemResourceMetricsProbingInterval(Configuration configuration) {
        if (!configuration.getBoolean(MetricOptions.SYSTEM_RESOURCE_METRICS)) {
            return Optional.empty();
        }
        return Optional.of(Time.milliseconds(configuration.getLong(MetricOptions.SYSTEM_RESOURCE_METRICS_PROBING_INTERVAL)));
    }

    @Nonnull
    public static String[] parseTempDirectories(Configuration configuration) {
        return ConfigurationUtils.splitPaths(configuration.getString(CoreOptions.TMP_DIRS));
    }

    @Nonnull
    public static String[] parseLocalStateDirectories(Configuration configuration) {
        String configValue = configuration.getString(CheckpointingOptions.LOCAL_RECOVERY_TASK_MANAGER_STATE_ROOT_DIRS, "");
        return ConfigurationUtils.splitPaths(configValue);
    }

    public static Time getStandaloneClusterStartupPeriodTime(Configuration configuration) {
        long standaloneClusterStartupPeriodTime = configuration.getLong(ResourceManagerOptions.STANDALONE_CLUSTER_STARTUP_PERIOD_TIME);
        Time timeout = standaloneClusterStartupPeriodTime >= 0L ? Time.milliseconds(standaloneClusterStartupPeriodTime) : Time.milliseconds(configuration.getLong(JobManagerOptions.SLOT_REQUEST_TIMEOUT));
        return timeout;
    }

    @Nonnull
    public static Configuration createConfiguration(Properties properties) {
        Configuration configuration = new Configuration();
        Set<String> propertyNames = properties.stringPropertyNames();
        for (String propertyName : propertyNames) {
            configuration.setString(propertyName, properties.getProperty(propertyName));
        }
        return configuration;
    }

    @Nonnull
    public static Map<String, String> hideSensitiveValues(Map<String, String> keyValuePairs) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> keyValuePair : keyValuePairs.entrySet()) {
            if (GlobalConfiguration.isSensitive(keyValuePair.getKey())) {
                result.put(keyValuePair.getKey(), "******");
                continue;
            }
            result.put(keyValuePair.getKey(), keyValuePair.getValue());
        }
        return result;
    }

    @Nonnull
    public static String[] splitPaths(@Nonnull String separatedPaths) {
        return separatedPaths.length() > 0 ? separatedPaths.split(",|" + File.pathSeparator) : EMPTY;
    }

    @VisibleForTesting
    public static Map<String, String> parseTmResourceDynamicConfigs(String dynamicConfigsStr) {
        HashMap<String, String> configs = new HashMap<String, String>();
        String[] configStrs = dynamicConfigsStr.split(" ");
        Preconditions.checkArgument(configStrs.length % 2 == 0, "Dynamic option string contained odd number of arguments: #arguments=%s, (%s)", configStrs.length, dynamicConfigsStr);
        for (int i = 0; i < configStrs.length; ++i) {
            String configStr = configStrs[i];
            if (i % 2 == 0) {
                Preconditions.checkArgument(configStr.equals("-D"));
                continue;
            }
            String[] configKV = configStr.split("=");
            Preconditions.checkArgument(configKV.length == 2);
            configs.put(configKV[0], configKV[1]);
        }
        ConfigurationUtils.checkConfigContains(configs, TaskManagerOptions.FRAMEWORK_HEAP_MEMORY.key());
        ConfigurationUtils.checkConfigContains(configs, TaskManagerOptions.FRAMEWORK_OFF_HEAP_MEMORY.key());
        ConfigurationUtils.checkConfigContains(configs, TaskManagerOptions.TASK_HEAP_MEMORY.key());
        ConfigurationUtils.checkConfigContains(configs, TaskManagerOptions.TASK_OFF_HEAP_MEMORY.key());
        ConfigurationUtils.checkConfigContains(configs, TaskManagerOptions.NETWORK_MEMORY_MAX.key());
        ConfigurationUtils.checkConfigContains(configs, TaskManagerOptions.NETWORK_MEMORY_MIN.key());
        ConfigurationUtils.checkConfigContains(configs, TaskManagerOptions.MANAGED_MEMORY_SIZE.key());
        return configs;
    }

    private static void checkConfigContains(Map<String, String> configs, String key) {
        Preconditions.checkArgument(configs.containsKey(key), "Key %s is missing present from dynamic configs.", key);
    }

    @VisibleForTesting
    public static Map<String, String> parseJvmArgString(String jvmParamsStr) {
        String xmx = "-Xmx";
        String xms = "-Xms";
        String maxDirect = "-XX:MaxDirectMemorySize=";
        String maxMetadata = "-XX:MaxMetaspaceSize=";
        HashMap<String, String> configs = new HashMap<String, String>();
        for (String paramStr : jvmParamsStr.split(" ")) {
            if (paramStr.startsWith("-Xmx")) {
                configs.put("-Xmx", paramStr.substring("-Xmx".length()));
                continue;
            }
            if (paramStr.startsWith("-Xms")) {
                configs.put("-Xms", paramStr.substring("-Xms".length()));
                continue;
            }
            if (paramStr.startsWith("-XX:MaxDirectMemorySize=")) {
                configs.put("-XX:MaxDirectMemorySize=", paramStr.substring("-XX:MaxDirectMemorySize=".length()));
                continue;
            }
            if (!paramStr.startsWith("-XX:MaxMetaspaceSize=")) continue;
            configs.put("-XX:MaxMetaspaceSize=", paramStr.substring("-XX:MaxMetaspaceSize=".length()));
        }
        Preconditions.checkArgument(configs.containsKey("-Xmx"));
        Preconditions.checkArgument(configs.containsKey("-Xms"));
        Preconditions.checkArgument(configs.containsKey("-XX:MaxMetaspaceSize="));
        return configs;
    }

    public static Map<String, String> getPrefixedKeyValuePairs(String prefix, Configuration configuration) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : configuration.toMap().entrySet()) {
            if (!entry.getKey().startsWith(prefix) || entry.getKey().length() <= prefix.length()) continue;
            String key = entry.getKey().substring(prefix.length());
            result.put(key, entry.getValue());
        }
        return result;
    }

    private ConfigurationUtils() {
    }
}

