/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.Archiveable;
import org.apache.flink.api.common.InputDependencyConstraint;
import org.apache.flink.api.common.accumulators.Accumulator;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.accumulators.StringifiedAccumulatorResult;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.checkpoint.CheckpointType;
import org.apache.flink.runtime.checkpoint.JobManagerTaskRestore;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptorFactory;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.ArchivedExecution;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionEdge;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IOMetrics;
import org.apache.flink.runtime.executiongraph.IllegalExecutionStateException;
import org.apache.flink.runtime.executiongraph.IntermediateResultPartition;
import org.apache.flink.runtime.executiongraph.PartitionInfo;
import org.apache.flink.runtime.executiongraph.SlotProviderStrategy;
import org.apache.flink.runtime.instance.SlotSharingGroupId;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmanager.scheduler.CoLocationConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.LocationPreferenceConstraint;
import org.apache.flink.runtime.jobmanager.scheduler.NoResourceAvailableException;
import org.apache.flink.runtime.jobmanager.scheduler.ScheduledUnit;
import org.apache.flink.runtime.jobmanager.scheduler.SlotSharingGroup;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.TaskBackPressureResponse;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.operators.coordination.TaskNotRunningException;
import org.apache.flink.runtime.scheduler.ExecutionVertexSchedulingRequirementsMapper;
import org.apache.flink.runtime.shuffle.PartitionDescriptor;
import org.apache.flink.runtime.shuffle.ProducerDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleDescriptor;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.OptionalFailure;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.function.ThrowingRunnable;
import org.slf4j.Logger;

public class Execution
implements AccessExecution,
Archiveable<ArchivedExecution>,
LogicalSlot.Payload {
    private static final Logger LOG = ExecutionGraph.LOG;
    private static final int NUM_CANCEL_CALL_TRIES = 3;
    private final Executor executor;
    private final ExecutionVertex vertex;
    private final ExecutionAttemptID attemptId;
    private final long globalModVersion;
    private final long[] stateTimestamps;
    private final int attemptNumber;
    private final Time rpcTimeout;
    private final Collection<PartitionInfo> partitionInfos;
    private final CompletableFuture<ExecutionState> terminalStateFuture;
    private final CompletableFuture<?> releaseFuture;
    private final CompletableFuture<TaskManagerLocation> taskManagerLocationFuture;
    private volatile ExecutionState state = ExecutionState.CREATED;
    private LogicalSlot assignedResource;
    private Throwable failureCause;
    @Nullable
    private JobManagerTaskRestore taskRestore;
    @Nullable
    private AllocationID assignedAllocationID;
    private final Object accumulatorLock = new Object();
    private Map<String, Accumulator<?, ?>> userAccumulators;
    private IOMetrics ioMetrics;
    private Map<IntermediateResultPartitionID, ResultPartitionDeploymentDescriptor> producedPartitions;

    public Execution(Executor executor, ExecutionVertex vertex, int attemptNumber, long globalModVersion, long startTimestamp, Time rpcTimeout) {
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.vertex = (ExecutionVertex)Preconditions.checkNotNull((Object)vertex);
        this.attemptId = new ExecutionAttemptID();
        this.rpcTimeout = (Time)Preconditions.checkNotNull((Object)rpcTimeout);
        this.globalModVersion = globalModVersion;
        this.attemptNumber = attemptNumber;
        this.stateTimestamps = new long[ExecutionState.values().length];
        this.markTimestamp(ExecutionState.CREATED, startTimestamp);
        this.partitionInfos = new ArrayList<PartitionInfo>(16);
        this.producedPartitions = Collections.emptyMap();
        this.terminalStateFuture = new CompletableFuture();
        this.releaseFuture = new CompletableFuture();
        this.taskManagerLocationFuture = new CompletableFuture();
        this.assignedResource = null;
    }

    public ExecutionVertex getVertex() {
        return this.vertex;
    }

    @Override
    public ExecutionAttemptID getAttemptId() {
        return this.attemptId;
    }

    @Override
    public int getAttemptNumber() {
        return this.attemptNumber;
    }

    @Override
    public ExecutionState getState() {
        return this.state;
    }

    @Nullable
    public AllocationID getAssignedAllocationID() {
        return this.assignedAllocationID;
    }

    public long getGlobalModVersion() {
        return this.globalModVersion;
    }

    public CompletableFuture<TaskManagerLocation> getTaskManagerLocationFuture() {
        return this.taskManagerLocationFuture;
    }

    public LogicalSlot getAssignedResource() {
        return this.assignedResource;
    }

    public Optional<ResultPartitionDeploymentDescriptor> getResultPartitionDeploymentDescriptor(IntermediateResultPartitionID id) {
        return Optional.ofNullable(this.producedPartitions.get(id));
    }

    public boolean tryAssignResource(LogicalSlot logicalSlot) {
        this.assertRunningInJobMasterMainThread();
        Preconditions.checkNotNull((Object)logicalSlot);
        if (this.state == ExecutionState.SCHEDULED || this.state == ExecutionState.CREATED) {
            if (this.assignedResource == null) {
                this.assignedResource = logicalSlot;
                if (logicalSlot.tryAssignPayload(this)) {
                    if (!(this.state != ExecutionState.SCHEDULED && this.state != ExecutionState.CREATED || this.taskManagerLocationFuture.isDone())) {
                        this.taskManagerLocationFuture.complete(logicalSlot.getTaskManagerLocation());
                        this.assignedAllocationID = logicalSlot.getAllocationId();
                        return true;
                    }
                    this.assignedResource = null;
                    return false;
                }
                this.assignedResource = null;
                return false;
            }
            return false;
        }
        return false;
    }

    public InputSplit getNextInputSplit() {
        LogicalSlot slot = this.getAssignedResource();
        String host = slot != null ? slot.getTaskManagerLocation().getHostname() : null;
        return this.vertex.getNextInputSplit(host);
    }

    @Override
    public TaskManagerLocation getAssignedResourceLocation() {
        LogicalSlot currentAssignedResource = this.assignedResource;
        return currentAssignedResource != null ? currentAssignedResource.getTaskManagerLocation() : null;
    }

    public Throwable getFailureCause() {
        return this.failureCause;
    }

    @Override
    public String getFailureCauseAsString() {
        return ExceptionUtils.stringifyException((Throwable)this.getFailureCause());
    }

    @Override
    public long[] getStateTimestamps() {
        return this.stateTimestamps;
    }

    @Override
    public long getStateTimestamp(ExecutionState state) {
        return this.stateTimestamps[state.ordinal()];
    }

    public boolean isFinished() {
        return this.state.isTerminal();
    }

    @Nullable
    public JobManagerTaskRestore getTaskRestore() {
        return this.taskRestore;
    }

    public void setInitialState(@Nullable JobManagerTaskRestore taskRestore) {
        this.taskRestore = taskRestore;
    }

    public CompletableFuture<ExecutionState> getTerminalStateFuture() {
        return this.terminalStateFuture;
    }

    public CompletableFuture<?> getReleaseFuture() {
        return this.releaseFuture;
    }

    public CompletableFuture<Void> scheduleForExecution() {
        ExecutionGraph executionGraph = this.getVertex().getExecutionGraph();
        SlotProviderStrategy resourceProvider = executionGraph.getSlotProviderStrategy();
        return this.scheduleForExecution(resourceProvider, LocationPreferenceConstraint.ANY, Collections.emptySet());
    }

    public CompletableFuture<Void> scheduleForExecution(SlotProviderStrategy slotProviderStrategy, LocationPreferenceConstraint locationPreferenceConstraint, @Nonnull Set<AllocationID> allPreviousExecutionGraphAllocationIds) {
        this.assertRunningInJobMasterMainThread();
        try {
            CompletableFuture<Execution> allocationFuture = this.allocateResourcesForExecution(slotProviderStrategy, locationPreferenceConstraint, allPreviousExecutionGraphAllocationIds);
            CompletionStage deploymentFuture = allocationFuture.thenRun(ThrowingRunnable.unchecked(this::deploy));
            ((CompletableFuture)deploymentFuture).whenComplete((ignored, failure) -> {
                if (failure != null) {
                    Throwable stripCompletionException = ExceptionUtils.stripCompletionException((Throwable)failure);
                    Object schedulingFailureCause = stripCompletionException instanceof TimeoutException ? new NoResourceAvailableException("Could not allocate enough slots to run the job. Please make sure that the cluster has enough resources.") : stripCompletionException;
                    this.markFailed((Throwable)schedulingFailureCause);
                }
            });
            return deploymentFuture;
        }
        catch (IllegalExecutionStateException e) {
            return FutureUtils.completedExceptionally(e);
        }
    }

    CompletableFuture<Execution> allocateResourcesForExecution(SlotProviderStrategy slotProviderStrategy, LocationPreferenceConstraint locationPreferenceConstraint, @Nonnull Set<AllocationID> allPreviousExecutionGraphAllocationIds) {
        return this.allocateAndAssignSlotForExecution(slotProviderStrategy, locationPreferenceConstraint, allPreviousExecutionGraphAllocationIds).thenCompose(slot -> this.registerProducedPartitions(slot.getTaskManagerLocation()));
    }

    private CompletableFuture<LogicalSlot> allocateAndAssignSlotForExecution(SlotProviderStrategy slotProviderStrategy, LocationPreferenceConstraint locationPreferenceConstraint, @Nonnull Set<AllocationID> allPreviousExecutionGraphAllocationIds) {
        Preconditions.checkNotNull((Object)slotProviderStrategy);
        this.assertRunningInJobMasterMainThread();
        SlotSharingGroup sharingGroup = this.vertex.getJobVertex().getSlotSharingGroup();
        CoLocationConstraint locationConstraint = this.vertex.getLocationConstraint();
        if (locationConstraint != null && sharingGroup == null) {
            throw new IllegalStateException("Trying to schedule with co-location constraint but without slot sharing allowed.");
        }
        if (this.transitionState(ExecutionState.CREATED, ExecutionState.SCHEDULED)) {
            SlotSharingGroupId slotSharingGroupId = sharingGroup != null ? sharingGroup.getSlotSharingGroupId() : null;
            ScheduledUnit toSchedule = locationConstraint == null ? new ScheduledUnit(this, slotSharingGroupId) : new ScheduledUnit(this, slotSharingGroupId, locationConstraint);
            ExecutionVertex executionVertex = this.getVertex();
            AllocationID lastAllocation = executionVertex.getLatestPriorAllocation();
            List<Object> previousAllocationIDs = lastAllocation != null ? Collections.singletonList(lastAllocation) : Collections.emptyList();
            CompletableFuture<Collection<TaskManagerLocation>> preferredLocationsFuture = this.calculatePreferredLocations(locationPreferenceConstraint);
            SlotRequestId slotRequestId = new SlotRequestId();
            CompletionStage logicalSlotFuture = preferredLocationsFuture.thenCompose(preferredLocations -> slotProviderStrategy.allocateSlot(slotRequestId, toSchedule, SlotProfile.priorAllocation(this.vertex.getResourceProfile(), ExecutionVertexSchedulingRequirementsMapper.getPhysicalSlotResourceProfile(this.vertex), preferredLocations, previousAllocationIDs, allPreviousExecutionGraphAllocationIds)));
            this.releaseFuture.whenComplete((arg_0, arg_1) -> this.lambda$allocateAndAssignSlotForExecution$3((CompletableFuture)logicalSlotFuture, slotProviderStrategy, slotRequestId, slotSharingGroupId, arg_0, arg_1));
            return ((CompletableFuture)logicalSlotFuture).handle((logicalSlot, failure) -> {
                if (failure != null) {
                    throw new CompletionException((Throwable)failure);
                }
                if (this.tryAssignResource((LogicalSlot)logicalSlot)) {
                    return logicalSlot;
                }
                logicalSlot.releaseSlot(new FlinkException("Could not assign logical slot to execution " + this + '.'));
                throw new CompletionException(new FlinkException("Could not assign slot " + logicalSlot + " to execution " + this + " because it has already been assigned "));
            });
        }
        throw new IllegalExecutionStateException(this, ExecutionState.CREATED, this.state);
    }

    public CompletableFuture<Execution> registerProducedPartitions(TaskManagerLocation location) {
        Preconditions.checkState((boolean)this.isLegacyScheduling());
        return this.registerProducedPartitions(location, this.vertex.getExecutionGraph().getScheduleMode().allowLazyDeployment());
    }

    public CompletableFuture<Execution> registerProducedPartitions(TaskManagerLocation location, boolean sendScheduleOrUpdateConsumersMessage) {
        this.assertRunningInJobMasterMainThread();
        return FutureUtils.thenApplyAsyncIfNotDone(Execution.registerProducedPartitions(this.vertex, location, this.attemptId, sendScheduleOrUpdateConsumersMessage), this.vertex.getExecutionGraph().getJobMasterMainThreadExecutor(), producedPartitionsCache -> {
            this.producedPartitions = producedPartitionsCache;
            this.startTrackingPartitions(location.getResourceID(), producedPartitionsCache.values());
            return this;
        });
    }

    @VisibleForTesting
    static CompletableFuture<Map<IntermediateResultPartitionID, ResultPartitionDeploymentDescriptor>> registerProducedPartitions(ExecutionVertex vertex, TaskManagerLocation location, ExecutionAttemptID attemptId, boolean sendScheduleOrUpdateConsumersMessage) {
        ProducerDescriptor producerDescriptor = ProducerDescriptor.create(location, attemptId);
        Collection<IntermediateResultPartition> partitions = vertex.getProducedPartitions().values();
        ArrayList<CompletionStage> partitionRegistrations = new ArrayList<CompletionStage>(partitions.size());
        for (IntermediateResultPartition partition : partitions) {
            PartitionDescriptor partitionDescriptor = PartitionDescriptor.from(partition);
            int maxParallelism = Execution.getPartitionMaxParallelism(partition);
            CompletableFuture<?> shuffleDescriptorFuture = vertex.getExecutionGraph().getShuffleMaster().registerPartitionWithProducer(partitionDescriptor, producerDescriptor);
            Preconditions.checkState((boolean)shuffleDescriptorFuture.isDone(), (Object)"ShuffleDescriptor future is incomplete.");
            CompletionStage partitionRegistration = shuffleDescriptorFuture.thenApply(shuffleDescriptor -> new ResultPartitionDeploymentDescriptor(partitionDescriptor, (ShuffleDescriptor)shuffleDescriptor, maxParallelism, sendScheduleOrUpdateConsumersMessage));
            partitionRegistrations.add(partitionRegistration);
        }
        return FutureUtils.combineAll(partitionRegistrations).thenApply(rpdds -> {
            LinkedHashMap producedPartitions = new LinkedHashMap(partitions.size());
            rpdds.forEach(rpdd -> producedPartitions.put(rpdd.getPartitionId(), rpdd));
            return producedPartitions;
        });
    }

    private static int getPartitionMaxParallelism(IntermediateResultPartition partition) {
        List<List<ExecutionEdge>> consumers = partition.getConsumers();
        Preconditions.checkArgument((!consumers.isEmpty() ? 1 : 0) != 0, (Object)"Currently there has to be exactly one consumer in real jobs");
        List<ExecutionEdge> consumer = consumers.get(0);
        ExecutionJobVertex consumerVertex = consumer.get(0).getTarget().getJobVertex();
        int maxParallelism = consumerVertex.getMaxParallelism();
        return maxParallelism;
    }

    public void deploy() throws JobException {
        block9: {
            this.assertRunningInJobMasterMainThread();
            LogicalSlot slot = this.assignedResource;
            Preconditions.checkNotNull((Object)slot, (String)"In order to deploy the execution we first have to assign a resource via tryAssignResource.");
            if (!slot.isAlive()) {
                throw new JobException("Target slot (TaskManager) for deployment is no longer alive.");
            }
            ExecutionState previous = this.state;
            if (previous == ExecutionState.SCHEDULED || previous == ExecutionState.CREATED) {
                if (!this.transitionState(previous, ExecutionState.DEPLOYING)) {
                    throw new IllegalStateException("Cannot deploy task: Concurrent deployment call race.");
                }
            } else {
                throw new IllegalStateException("The vertex must be in CREATED or SCHEDULED state to be deployed. Found state " + (Object)((Object)previous));
            }
            if (this != slot.getPayload()) {
                throw new IllegalStateException(String.format("The execution %s has not been assigned to the assigned slot.", this));
            }
            try {
                if (this.state != ExecutionState.DEPLOYING) {
                    slot.releaseSlot(new FlinkException("Actual state of execution " + this + " (" + (Object)((Object)this.state) + ") does not match expected state DEPLOYING."));
                    return;
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info(String.format("Deploying %s (attempt #%d) to %s", this.vertex.getTaskNameWithSubtaskIndex(), this.attemptNumber, this.getAssignedResourceLocation()));
                }
                TaskDeploymentDescriptor deployment = TaskDeploymentDescriptorFactory.fromExecutionVertex(this.vertex, this.attemptNumber).createDeploymentDescriptor(slot.getAllocationId(), slot.getPhysicalSlotNumber(), this.taskRestore, this.producedPartitions.values());
                this.taskRestore = null;
                TaskManagerGateway taskManagerGateway = slot.getTaskManagerGateway();
                ComponentMainThreadExecutor jobMasterMainThreadExecutor = this.vertex.getExecutionGraph().getJobMasterMainThreadExecutor();
                ((CompletableFuture)CompletableFuture.supplyAsync(() -> taskManagerGateway.submitTask(deployment, this.rpcTimeout), this.executor).thenCompose(Function.identity())).whenCompleteAsync((ack, failure) -> {
                    if (failure != null) {
                        if (failure instanceof TimeoutException) {
                            String taskname = this.vertex.getTaskNameWithSubtaskIndex() + " (" + (Object)((Object)this.attemptId) + ')';
                            this.markFailed(new Exception("Cannot deploy task " + taskname + " - TaskManager (" + this.getAssignedResourceLocation() + ") not responding after a rpcTimeout of " + this.rpcTimeout, (Throwable)failure));
                        } else {
                            this.markFailed((Throwable)failure);
                        }
                    }
                }, (Executor)jobMasterMainThreadExecutor);
            }
            catch (Throwable t) {
                this.markFailed(t);
                if (!this.isLegacyScheduling()) break block9;
                ExceptionUtils.rethrow((Throwable)t);
            }
        }
    }

    public void cancel() {
        ExecutionState current;
        block5: {
            this.assertRunningInJobMasterMainThread();
            while (true) {
                if ((current = this.state) == ExecutionState.CANCELING || current == ExecutionState.CANCELED) {
                    return;
                }
                if (current == ExecutionState.RUNNING || current == ExecutionState.DEPLOYING) {
                    if (!this.startCancelling(3)) continue;
                    return;
                }
                if (current == ExecutionState.FINISHED) {
                    this.sendReleaseIntermediateResultPartitionsRpcCall();
                    return;
                }
                if (current == ExecutionState.FAILED) {
                    return;
                }
                if (current != ExecutionState.CREATED && current != ExecutionState.SCHEDULED) break block5;
                if (this.cancelAtomically()) break;
            }
            return;
        }
        throw new IllegalStateException(current.name());
    }

    public CompletableFuture<?> suspend() {
        switch (this.state) {
            case RUNNING: 
            case DEPLOYING: 
            case CREATED: 
            case SCHEDULED: {
                if (this.cancelAtomically()) break;
                throw new IllegalStateException(String.format("Could not directly go to %s from %s.", ExecutionState.CANCELED.name(), this.state.name()));
            }
            case CANCELING: {
                this.completeCancelling();
                break;
            }
            case FINISHED: {
                this.sendReleaseIntermediateResultPartitionsRpcCall();
                break;
            }
            case FAILED: 
            case CANCELED: {
                break;
            }
            default: {
                throw new IllegalStateException(this.state.name());
            }
        }
        return this.releaseFuture;
    }

    private void scheduleConsumer(ExecutionVertex consumerVertex) {
        assert (this.isLegacyScheduling());
        try {
            ExecutionGraph executionGraph = consumerVertex.getExecutionGraph();
            consumerVertex.scheduleForExecution(executionGraph.getSlotProviderStrategy(), LocationPreferenceConstraint.ANY, Collections.emptySet());
        }
        catch (Throwable t) {
            consumerVertex.fail(new IllegalStateException("Could not schedule consumer vertex " + consumerVertex, t));
        }
    }

    void scheduleOrUpdateConsumers(List<List<ExecutionEdge>> allConsumers) {
        this.assertRunningInJobMasterMainThread();
        HashSet<ExecutionVertex> consumerDeduplicator = new HashSet<ExecutionVertex>();
        this.scheduleOrUpdateConsumers(allConsumers, consumerDeduplicator);
    }

    private void scheduleOrUpdateConsumers(List<List<ExecutionEdge>> allConsumers, HashSet<ExecutionVertex> consumerDeduplicator) {
        if (allConsumers.size() == 0) {
            return;
        }
        if (allConsumers.size() > 1) {
            this.fail(new IllegalStateException("Currently, only a single consumer group per partition is supported."));
            return;
        }
        for (ExecutionEdge edge : allConsumers.get(0)) {
            ExecutionVertex consumerVertex = edge.getTarget();
            Execution consumer = consumerVertex.getCurrentExecutionAttempt();
            ExecutionState consumerState = consumer.getState();
            if (consumerState == ExecutionState.CREATED) {
                if (!this.isLegacyScheduling() || !consumerDeduplicator.add(consumerVertex) || consumerVertex.getInputDependencyConstraint() != InputDependencyConstraint.ANY && !consumerVertex.checkInputDependencyConstraints()) continue;
                this.scheduleConsumer(consumerVertex);
                continue;
            }
            if (consumerState != ExecutionState.DEPLOYING && consumerState != ExecutionState.RUNNING) continue;
            PartitionInfo partitionInfo = Execution.createPartitionInfo(edge);
            if (consumerState == ExecutionState.DEPLOYING) {
                consumerVertex.cachePartitionInfo(partitionInfo);
                continue;
            }
            consumer.sendUpdatePartitionInfoRpcCall(Collections.singleton(partitionInfo));
        }
    }

    private static PartitionInfo createPartitionInfo(ExecutionEdge executionEdge) {
        IntermediateDataSetID intermediateDataSetID = executionEdge.getSource().getIntermediateResult().getId();
        ShuffleDescriptor shuffleDescriptor = TaskDeploymentDescriptorFactory.getConsumedPartitionShuffleDescriptor(executionEdge, false);
        return new PartitionInfo(intermediateDataSetID, shuffleDescriptor);
    }

    @Override
    public void fail(Throwable t) {
        this.processFail(t, false);
    }

    public CompletableFuture<TaskBackPressureResponse> requestBackPressure(int requestId, Time timeout) {
        LogicalSlot slot = this.assignedResource;
        if (slot != null) {
            TaskManagerGateway taskManagerGateway = slot.getTaskManagerGateway();
            return taskManagerGateway.requestTaskBackPressure(this.attemptId, requestId, timeout);
        }
        return FutureUtils.completedExceptionally(new Exception("The execution has no slot assigned."));
    }

    public void notifyCheckpointComplete(long checkpointId, long timestamp) {
        LogicalSlot slot = this.assignedResource;
        if (slot != null) {
            TaskManagerGateway taskManagerGateway = slot.getTaskManagerGateway();
            taskManagerGateway.notifyCheckpointComplete(this.attemptId, this.getVertex().getJobId(), checkpointId, timestamp);
        } else {
            LOG.debug("The execution has no slot assigned. This indicates that the execution is no longer running.");
        }
    }

    public void notifyCheckpointAborted(long abortCheckpointId, long timestamp) {
        LogicalSlot slot = this.assignedResource;
        if (slot != null) {
            TaskManagerGateway taskManagerGateway = slot.getTaskManagerGateway();
            taskManagerGateway.notifyCheckpointAborted(this.attemptId, this.getVertex().getJobId(), abortCheckpointId, timestamp);
        } else {
            LOG.debug("The execution has no slot assigned. This indicates that the execution is no longer running.");
        }
    }

    public void triggerCheckpoint(long checkpointId, long timestamp, CheckpointOptions checkpointOptions) {
        this.triggerCheckpointHelper(checkpointId, timestamp, checkpointOptions, false);
    }

    public void triggerSynchronousSavepoint(long checkpointId, long timestamp, CheckpointOptions checkpointOptions, boolean advanceToEndOfEventTime) {
        this.triggerCheckpointHelper(checkpointId, timestamp, checkpointOptions, advanceToEndOfEventTime);
    }

    private void triggerCheckpointHelper(long checkpointId, long timestamp, CheckpointOptions checkpointOptions, boolean advanceToEndOfEventTime) {
        CheckpointType checkpointType = checkpointOptions.getCheckpointType();
        if (!(!advanceToEndOfEventTime || checkpointType.isSynchronous() && checkpointType.isSavepoint())) {
            throw new IllegalArgumentException("Only synchronous savepoints are allowed to advance the watermark to MAX.");
        }
        LogicalSlot slot = this.assignedResource;
        if (slot != null) {
            TaskManagerGateway taskManagerGateway = slot.getTaskManagerGateway();
            taskManagerGateway.triggerCheckpoint(this.attemptId, this.getVertex().getJobId(), checkpointId, timestamp, checkpointOptions, advanceToEndOfEventTime);
        } else {
            LOG.debug("The execution has no slot assigned. This indicates that the execution is no longer running.");
        }
    }

    public CompletableFuture<Acknowledge> sendOperatorEvent(OperatorID operatorId, SerializedValue<OperatorEvent> event) {
        LogicalSlot slot = this.assignedResource;
        if (slot != null && this.getState() == ExecutionState.RUNNING) {
            TaskManagerGateway eventGateway = slot.getTaskManagerGateway();
            return eventGateway.sendOperatorEventToTask(this.getAttemptId(), operatorId, event);
        }
        return FutureUtils.completedExceptionally((Throwable)((Object)new TaskNotRunningException('\"' + this.vertex.getTaskNameWithSubtaskIndex() + "\" is currently not running or ready.")));
    }

    void markFailed(Throwable t) {
        this.processFail(t, true);
    }

    @Deprecated
    @VisibleForTesting
    void markFailed(Throwable t, Map<String, Accumulator<?, ?>> userAccumulators, IOMetrics metrics) {
        this.markFailed(t, userAccumulators, metrics, false);
    }

    void markFailed(Throwable t, Map<String, Accumulator<?, ?>> userAccumulators, IOMetrics metrics, boolean fromSchedulerNg) {
        this.processFail(t, true, userAccumulators, metrics, false, fromSchedulerNg);
    }

    @VisibleForTesting
    void markFinished() {
        this.markFinished(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void markFinished(Map<String, Accumulator<?, ?>> userAccumulators, IOMetrics metrics) {
        ExecutionState current;
        this.assertRunningInJobMasterMainThread();
        while ((current = this.state) == ExecutionState.RUNNING || current == ExecutionState.DEPLOYING) {
            if (!this.transitionState(current, ExecutionState.FINISHED)) continue;
            try {
                this.finishPartitionsAndScheduleOrUpdateConsumers();
                this.updateAccumulatorsAndMetrics(userAccumulators, metrics);
                this.releaseAssignedResource(null);
                this.vertex.getExecutionGraph().deregisterExecution(this);
            }
            finally {
                this.vertex.executionFinished(this);
            }
            return;
        }
        if (current == ExecutionState.CANCELING) {
            this.completeCancelling(userAccumulators, metrics, true);
            return;
        }
        if (current == ExecutionState.CANCELED || current == ExecutionState.FAILED) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Task FINISHED, but concurrently went to state " + (Object)((Object)this.state));
            }
            return;
        }
        this.markFailed(new Exception("Vertex received FINISHED message while being in state " + (Object)((Object)this.state)));
    }

    private void finishPartitionsAndScheduleOrUpdateConsumers() {
        List<IntermediateResultPartition> newlyFinishedResults = this.getVertex().finishAllBlockingPartitions();
        if (newlyFinishedResults.isEmpty()) {
            return;
        }
        HashSet<ExecutionVertex> consumerDeduplicator = new HashSet<ExecutionVertex>();
        for (IntermediateResultPartition finishedPartition : newlyFinishedResults) {
            IntermediateResultPartition[] allPartitionsOfNewlyFinishedResults;
            for (IntermediateResultPartition partition : allPartitionsOfNewlyFinishedResults = finishedPartition.getIntermediateResult().getPartitions()) {
                this.scheduleOrUpdateConsumers(partition.getConsumers(), consumerDeduplicator);
            }
        }
    }

    private boolean cancelAtomically() {
        if (this.startCancelling(0)) {
            this.completeCancelling();
            return true;
        }
        return false;
    }

    private boolean startCancelling(int numberCancelRetries) {
        if (this.transitionState(this.state, ExecutionState.CANCELING)) {
            this.taskManagerLocationFuture.cancel(false);
            this.sendCancelRpcCall(numberCancelRetries);
            return true;
        }
        return false;
    }

    void completeCancelling() {
        this.completeCancelling(null, null, true);
    }

    void completeCancelling(Map<String, Accumulator<?, ?>> userAccumulators, IOMetrics metrics, boolean releasePartitions) {
        ExecutionState current;
        block3: {
            do {
                if ((current = this.state) == ExecutionState.CANCELED) {
                    return;
                }
                if (current != ExecutionState.CANCELING && current != ExecutionState.RUNNING && current != ExecutionState.DEPLOYING) break block3;
                this.updateAccumulatorsAndMetrics(userAccumulators, metrics);
            } while (!this.transitionState(current, ExecutionState.CANCELED));
            this.finishCancellation(releasePartitions);
            return;
        }
        if (current != ExecutionState.FAILED) {
            String message = String.format("Asynchronous race: Found %s in state %s after successful cancel call.", new Object[]{this.vertex.getTaskNameWithSubtaskIndex(), this.state});
            LOG.error(message);
            this.vertex.getExecutionGraph().failGlobal(new Exception(message));
        }
    }

    private void finishCancellation(boolean releasePartitions) {
        this.releaseAssignedResource(new FlinkException("Execution " + this + " was cancelled."));
        this.vertex.getExecutionGraph().deregisterExecution(this);
        this.handlePartitionCleanup(releasePartitions, releasePartitions);
    }

    void cachePartitionInfo(PartitionInfo partitionInfo) {
        this.partitionInfos.add(partitionInfo);
    }

    private void sendPartitionInfos() {
        if (!this.partitionInfos.isEmpty()) {
            this.sendUpdatePartitionInfoRpcCall(new ArrayList<PartitionInfo>(this.partitionInfos));
            this.partitionInfos.clear();
        }
    }

    private boolean isLegacyScheduling() {
        return this.getVertex().isLegacyScheduling();
    }

    private void processFail(Throwable t, boolean isCallback) {
        this.processFail(t, isCallback, null, null, true, false);
    }

    private void processFail(Throwable t, boolean isCallback, Map<String, Accumulator<?, ?>> userAccumulators, IOMetrics metrics, boolean releasePartitions, boolean fromSchedulerNg) {
        ExecutionState current;
        this.assertRunningInJobMasterMainThread();
        do {
            if ((current = this.state) == ExecutionState.FAILED) {
                return;
            }
            if (current == ExecutionState.CANCELED || current == ExecutionState.FINISHED) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Ignoring transition of vertex {} to {} while being {}.", new Object[]{this.getVertexWithAttempt(), ExecutionState.FAILED, current});
                }
                return;
            }
            if (current == ExecutionState.CANCELING) {
                this.completeCancelling(userAccumulators, metrics, true);
                return;
            }
            if (fromSchedulerNg || this.isLegacyScheduling()) continue;
            this.vertex.getExecutionGraph().notifySchedulerNgAboutInternalTaskFailure(this.attemptId, t);
            this.maybeReleasePartitionsAndSendCancelRpcCall(current, isCallback, releasePartitions);
            return;
        } while (!this.transitionState(current, ExecutionState.FAILED, t));
        this.failureCause = t;
        this.updateAccumulatorsAndMetrics(userAccumulators, metrics);
        this.releaseAssignedResource(t);
        this.vertex.getExecutionGraph().deregisterExecution(this);
        if (this.isLegacyScheduling()) {
            this.maybeReleasePartitionsAndSendCancelRpcCall(current, isCallback, releasePartitions);
        }
    }

    private void maybeReleasePartitionsAndSendCancelRpcCall(ExecutionState stateBeforeFailed, boolean isCallback, boolean releasePartitions) {
        this.handlePartitionCleanup(releasePartitions, releasePartitions);
        if (!(isCallback || stateBeforeFailed != ExecutionState.RUNNING && stateBeforeFailed != ExecutionState.DEPLOYING)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending out cancel request, to remove task execution from TaskManager.");
            }
            try {
                if (this.assignedResource != null) {
                    this.sendCancelRpcCall(3);
                }
            }
            catch (Throwable tt) {
                LOG.error("Error triggering cancel call while marking task {} as failed.", (Object)this.getVertex().getTaskNameWithSubtaskIndex(), (Object)tt);
            }
        }
    }

    boolean switchToRunning() {
        if (this.transitionState(ExecutionState.DEPLOYING, ExecutionState.RUNNING)) {
            this.sendPartitionInfos();
            return true;
        }
        ExecutionState currentState = this.state;
        if (currentState != ExecutionState.FINISHED && currentState != ExecutionState.CANCELED) {
            if (currentState == ExecutionState.CANCELING || currentState == ExecutionState.FAILED) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Concurrent canceling/failing of {} while deployment was in progress.", (Object)this.getVertexWithAttempt());
                }
                this.sendCancelRpcCall(3);
            } else {
                String message = String.format("Concurrent unexpected state transition of task %s to %s while deployment was in progress.", new Object[]{this.getVertexWithAttempt(), currentState});
                LOG.debug(message);
                this.sendCancelRpcCall(3);
                this.markFailed(new Exception(message));
            }
        }
        return false;
    }

    private void sendCancelRpcCall(int numberRetries) {
        LogicalSlot slot = this.assignedResource;
        if (slot != null) {
            TaskManagerGateway taskManagerGateway = slot.getTaskManagerGateway();
            ComponentMainThreadExecutor jobMasterMainThreadExecutor = this.getVertex().getExecutionGraph().getJobMasterMainThreadExecutor();
            CompletableFuture cancelResultFuture = FutureUtils.retry(() -> taskManagerGateway.cancelTask(this.attemptId, this.rpcTimeout), numberRetries, jobMasterMainThreadExecutor);
            cancelResultFuture.whenComplete((ack, failure) -> {
                if (failure != null) {
                    this.fail(new Exception("Task could not be canceled.", (Throwable)failure));
                }
            });
        }
    }

    private void startTrackingPartitions(ResourceID taskExecutorId, Collection<ResultPartitionDeploymentDescriptor> partitions) {
        JobMasterPartitionTracker partitionTracker = this.vertex.getExecutionGraph().getPartitionTracker();
        for (ResultPartitionDeploymentDescriptor partition : partitions) {
            partitionTracker.startTrackingPartition(taskExecutorId, partition);
        }
    }

    void handlePartitionCleanup(boolean releasePipelinedPartitions, boolean releaseBlockingPartitions) {
        if (releasePipelinedPartitions) {
            this.sendReleaseIntermediateResultPartitionsRpcCall();
        }
        Collection<ResultPartitionID> partitionIds = this.getPartitionIds();
        JobMasterPartitionTracker partitionTracker = this.getVertex().getExecutionGraph().getPartitionTracker();
        if (!partitionIds.isEmpty()) {
            if (releaseBlockingPartitions) {
                LOG.info("Discarding the results produced by task execution {}.", (Object)this.attemptId);
                partitionTracker.stopTrackingAndReleasePartitions(partitionIds);
            } else {
                partitionTracker.stopTrackingPartitions(partitionIds);
            }
        }
    }

    private Collection<ResultPartitionID> getPartitionIds() {
        return this.producedPartitions.values().stream().map(ResultPartitionDeploymentDescriptor::getShuffleDescriptor).map(ShuffleDescriptor::getResultPartitionID).collect(Collectors.toList());
    }

    private void sendReleaseIntermediateResultPartitionsRpcCall() {
        LOG.info("Discarding the results produced by task execution {}.", (Object)this.attemptId);
        LogicalSlot slot = this.assignedResource;
        if (slot != null) {
            TaskManagerGateway taskManagerGateway = slot.getTaskManagerGateway();
            ShuffleMaster<?> shuffleMaster = this.getVertex().getExecutionGraph().getShuffleMaster();
            Set<ResultPartitionID> partitionIds = this.producedPartitions.values().stream().filter(resultPartitionDeploymentDescriptor -> resultPartitionDeploymentDescriptor.getPartitionType().isPipelined()).map(ResultPartitionDeploymentDescriptor::getShuffleDescriptor).peek(shuffleMaster::releasePartitionExternally).map(ShuffleDescriptor::getResultPartitionID).collect(Collectors.toSet());
            if (!partitionIds.isEmpty()) {
                taskManagerGateway.releasePartitions(this.getVertex().getJobId(), partitionIds);
            }
        }
    }

    private void sendUpdatePartitionInfoRpcCall(Iterable<PartitionInfo> partitionInfos) {
        LogicalSlot slot = this.assignedResource;
        if (slot != null) {
            TaskManagerGateway taskManagerGateway = slot.getTaskManagerGateway();
            TaskManagerLocation taskManagerLocation = slot.getTaskManagerLocation();
            CompletableFuture<Acknowledge> updatePartitionsResultFuture = taskManagerGateway.updatePartitions(this.attemptId, partitionInfos, this.rpcTimeout);
            updatePartitionsResultFuture.whenCompleteAsync((ack, failure) -> {
                if (failure != null) {
                    this.fail(new IllegalStateException("Update to task [" + this.getVertexWithAttempt() + "] on TaskManager " + taskManagerLocation + " failed", (Throwable)failure));
                }
            }, (Executor)this.getVertex().getExecutionGraph().getJobMasterMainThreadExecutor());
        }
    }

    private void releaseAssignedResource(@Nullable Throwable cause) {
        this.assertRunningInJobMasterMainThread();
        LogicalSlot slot = this.assignedResource;
        if (slot != null) {
            ComponentMainThreadExecutor jobMasterMainThreadExecutor = this.getVertex().getExecutionGraph().getJobMasterMainThreadExecutor();
            slot.releaseSlot(cause).whenComplete((ignored, throwable) -> {
                jobMasterMainThreadExecutor.assertRunningInMainThread();
                if (throwable != null) {
                    this.releaseFuture.completeExceptionally((Throwable)throwable);
                } else {
                    this.releaseFuture.complete(null);
                }
            });
        } else {
            this.releaseFuture.complete(null);
        }
    }

    @VisibleForTesting
    public CompletableFuture<Collection<TaskManagerLocation>> calculatePreferredLocations(LocationPreferenceConstraint locationPreferenceConstraint) {
        CompletableFuture preferredLocationsFuture;
        Collection<CompletableFuture<TaskManagerLocation>> preferredLocationFutures = this.getVertex().getPreferredLocations();
        switch (locationPreferenceConstraint) {
            case ALL: {
                preferredLocationsFuture = FutureUtils.combineAll(preferredLocationFutures);
                break;
            }
            case ANY: {
                ArrayList<TaskManagerLocation> completedTaskManagerLocations = new ArrayList<TaskManagerLocation>(preferredLocationFutures.size());
                for (CompletableFuture<TaskManagerLocation> preferredLocationFuture : preferredLocationFutures) {
                    if (!preferredLocationFuture.isDone() || preferredLocationFuture.isCompletedExceptionally()) continue;
                    TaskManagerLocation taskManagerLocation = preferredLocationFuture.getNow(null);
                    if (taskManagerLocation == null) {
                        throw new FlinkRuntimeException("TaskManagerLocationFuture was completed with null. This indicates a programming bug.");
                    }
                    completedTaskManagerLocations.add(taskManagerLocation);
                }
                preferredLocationsFuture = CompletableFuture.completedFuture(completedTaskManagerLocations);
                break;
            }
            default: {
                throw new RuntimeException("Unknown LocationPreferenceConstraint " + (Object)((Object)locationPreferenceConstraint) + '.');
            }
        }
        return preferredLocationsFuture;
    }

    public void transitionState(ExecutionState targetState) {
        this.transitionState(this.state, targetState);
    }

    private boolean transitionState(ExecutionState currentState, ExecutionState targetState) {
        return this.transitionState(currentState, targetState, null);
    }

    private boolean transitionState(ExecutionState currentState, ExecutionState targetState, Throwable error) {
        if (currentState.isTerminal()) {
            throw new IllegalStateException("Cannot leave terminal state " + (Object)((Object)currentState) + " to transition to " + (Object)((Object)targetState) + '.');
        }
        if (this.state == currentState) {
            this.state = targetState;
            this.markTimestamp(targetState);
            if (error == null) {
                LOG.info("{} ({}) switched from {} to {}.", new Object[]{this.getVertex().getTaskNameWithSubtaskIndex(), this.getAttemptId(), currentState, targetState});
            } else if (LOG.isInfoEnabled()) {
                String locationInformation = this.getAssignedResource() != null ? this.getAssignedResource().toString() : "not deployed";
                LOG.info("{} ({}) switched from {} to {} on {}.", new Object[]{this.getVertex().getTaskNameWithSubtaskIndex(), this.getAttemptId(), currentState, targetState, locationInformation, error});
            }
            if (targetState.isTerminal()) {
                this.terminalStateFuture.complete(targetState);
            }
            try {
                this.vertex.notifyStateTransition(this, targetState, error);
            }
            catch (Throwable t) {
                LOG.error("Error while notifying execution graph of execution state transition.", t);
            }
            return true;
        }
        return false;
    }

    private void markTimestamp(ExecutionState state) {
        this.markTimestamp(state, System.currentTimeMillis());
    }

    private void markTimestamp(ExecutionState state, long timestamp) {
        this.stateTimestamps[state.ordinal()] = timestamp;
    }

    public String getVertexWithAttempt() {
        return this.vertex.getTaskNameWithSubtaskIndex() + " - execution #" + this.attemptNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAccumulators(Map<String, Accumulator<?, ?>> userAccumulators) {
        Object object = this.accumulatorLock;
        synchronized (object) {
            if (!this.state.isTerminal()) {
                this.userAccumulators = userAccumulators;
            }
        }
    }

    public Map<String, Accumulator<?, ?>> getUserAccumulators() {
        return this.userAccumulators;
    }

    @Override
    public StringifiedAccumulatorResult[] getUserAccumulatorsStringified() {
        Map<String, OptionalFailure> accumulators = this.userAccumulators == null ? null : this.userAccumulators.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> OptionalFailure.of(entry.getValue())));
        return StringifiedAccumulatorResult.stringifyAccumulatorResults(accumulators);
    }

    @Override
    public int getParallelSubtaskIndex() {
        return this.getVertex().getParallelSubtaskIndex();
    }

    @Override
    public IOMetrics getIOMetrics() {
        return this.ioMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAccumulatorsAndMetrics(Map<String, Accumulator<?, ?>> userAccumulators, IOMetrics metrics) {
        if (userAccumulators != null) {
            Object object = this.accumulatorLock;
            synchronized (object) {
                this.userAccumulators = userAccumulators;
            }
        }
        if (metrics != null) {
            this.ioMetrics = metrics;
        }
    }

    public String toString() {
        LogicalSlot slot = this.assignedResource;
        return String.format("Attempt #%d (%s) @ %s - [%s]", new Object[]{this.attemptNumber, this.vertex.getTaskNameWithSubtaskIndex(), slot == null ? "(unassigned)" : slot, this.state});
    }

    public ArchivedExecution archive() {
        return new ArchivedExecution(this);
    }

    private void assertRunningInJobMasterMainThread() {
        this.vertex.getExecutionGraph().assertRunningInJobMasterMainThread();
    }

    private /* synthetic */ void lambda$allocateAndAssignSlotForExecution$3(CompletableFuture logicalSlotFuture, SlotProviderStrategy slotProviderStrategy, SlotRequestId slotRequestId, SlotSharingGroupId slotSharingGroupId, Object ignored, Throwable throwable) {
        if (logicalSlotFuture.cancel(false)) {
            slotProviderStrategy.cancelSlotRequest(slotRequestId, slotSharingGroupId, new FlinkException("Execution " + this + " was released."));
        }
    }
}

